/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;

public interface ManaInfusionRecipe extends class_1860<class_1263> {
	class_2960 TYPE_ID = new class_2960(BotaniaAPI.MODID, "mana_infusion");

	/**
	 * Attempts to match the recipe.
	 *
	 * @param stack The whole stack that is in the Mana Pool (when actually crafting)
	 *              or in the player's hand (for the HUD).
	 * @return Whether this recipe matches the given stack.
	 */
	boolean matches(class_1799 stack);

	/**
	 * Get the recipe output, used for display (in JEI or the HUD).
	 * If {@link #getRecipeOutput(class_1799)} isn't overridden, this is also the actual result of the crafting recipe.
	 *
	 * @return The output stack of the recipe.
	 */
	@NotNull
	@Override
	class_1799 method_8110();

	/**
	 * Get the actual recipe output, not just for display. Defaults to a copy of {@link #method_8110()}.
	 *
	 * @param input The whole stack that is in the Mana Pool, not a copy.
	 * @return The output stack of the recipe for the specific input.
	 */
	@NotNull
	default class_1799 getRecipeOutput(@NotNull class_1799 input) {
		return method_8110().method_7972();
	}

	/**
	 * Get the catalyst that must be under the Mana Pool for this recipe, or {@code null} if it can be anything.
	 *
	 * @return The catalyst ingredient.
	 */
	@Nullable
	StateIngredient getRecipeCatalyst();

	/**
	 * @return How much mana this recipe consumes from the pool.
	 */
	int getManaToConsume();

	@NotNull
	@Override
	default class_3956<?> method_17716() {
		return class_2378.field_17597.method_17966(TYPE_ID).get();
	}

	// Ignored IRecipe stuff

	@NotNull
	@Override
	default class_1799 method_8116(@NotNull class_1263 inv) {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8115(@NotNull class_1263 inv, @NotNull class_1937 world) {
		return false;
	}

	@Override
	default boolean method_8113(int width, int height) {
		return false;
	}

	@Override
	default boolean method_8118() {
		return true;
	}
}
