/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.recipe;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public interface ElvenTradeRecipe extends class_1860<class_1263> {
	class_2960 TYPE_ID = new class_2960(BotaniaAPI.MODID, "elven_trade");

	/**
	 * Attempts to match the recipe
	 *
	 * @param stacks Entire contents of the portal's buffer
	 * @return {@link Optional#empty()} if recipe doesn't match, Optional with a set of items used by recipe
	 *         otherwise
	 */
	Optional<List<class_1799>> match(List<class_1799> stacks);

	/**
	 * If the recipe does not contain the item, it will be destroyed upon entering the portal.
	 */
	boolean containsItem(class_1799 stack);

	/**
	 * @return Preview of the inputs
	 */
	@NotNull
	@Override
	class_2371<class_1856> method_8117();

	/**
	 * @return Preview of the outputs
	 */
	List<class_1799> getOutputs();

	/**
	 * Actually evaluate the recipe
	 */
	List<class_1799> getOutputs(List<class_1799> inputs);

	@NotNull
	@Override
	default class_3956<?> method_17716() {
		return class_2378.field_17597.method_17966(TYPE_ID).get();
	}

	// Ignored IRecipe boilerplate

	@Override
	default boolean method_8115(@NotNull class_1263 inv, @NotNull class_1937 world) {
		return false;
	}

	@NotNull
	@Override
	default class_1799 method_8116(@NotNull class_1263 inv) {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8113(int width, int height) {
		return false;
	}

	@Override
	default class_1799 method_8110() {
		return class_1799.field_8037;
	}

	@Override
	default boolean method_8118() {
		return true;
	}

	/**
	 * Checks if this recipe is a "return" recipe, meaning that it returns the item that was thrown into it.
	 *
	 * @return {@code true} if recipe is a return recipe, {@code false} otherwise.
	 */
	default boolean isReturnRecipe() {
		return this.getOutputs().size() == 1
				&& this.method_8117().size() == 1
				&& this.containsItem(this.getOutputs().get(0));
	}
}
