/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.ManaReceiver;

/**
 * An Entity that implements this is considered a Spark.
 */
public interface SparkEntity {

	/**
	 * @return The position of the block that this spark is attached to
	 */
	class_2338 getAttachPos();

	/**
	 * @return The attached mana receiver under the spark, if available
	 */
	@Nullable
	ManaReceiver getAttachedManaReceiver();

	/**
	 * Gets the network that this spark is on, or the color it's displaying. Sparks may only connect to others
	 * of the same network.
	 */
	class_1767 getNetwork();

	void setNetwork(class_1767 color);

	/**
	 * @return this spark as an Entity
	 */
	default class_1297 entity() {
		return (class_1297) this;
	}
}
