/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaCollector;

/**
 * The basic class for a Generating Flower.
 */
public abstract class GeneratingFlowerBlockEntity extends BindableSpecialFlowerBlockEntity<ManaCollector> {
	private static final class_2960 SPREADER_ID = new class_2960(BotaniaAPI.MODID, "mana_spreader");

	public static final int LINK_RANGE = 6;
	private static final String TAG_MANA = "mana";

	private int mana;

	public GeneratingFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state, ManaCollector.class);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			double particleChance = 1F - (double) getMana() / (double) getMaxMana() / 3.5F;
			int color = getColor();
			float red = (color >> 16 & 0xFF) / 255F;
			float green = (color >> 8 & 0xFF) / 255F;
			float blue = (color & 0xFF) / 255F;

			if (Math.random() > particleChance) {
				class_243 offset = method_10997().method_8320(method_11016()).method_26226(method_10997(), method_11016());
				double x = method_11016().method_10263() + offset.field_1352;
				double y = method_11016().method_10264() + offset.field_1351;
				double z = method_11016().method_10260() + offset.field_1350;
				BotaniaAPI.instance().sparkleFX(method_10997(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float) Math.random(), 5);
			}
		}
		emptyManaIntoCollector();
	}

	@Override
	public int getBindingRadius() {
		return LINK_RANGE;
	}

	@Nullable
	@Override
	public class_2338 findClosestTarget() {
		ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
		var closestCollector = network.getClosestCollector(method_11016(), method_10997(), getBindingRadius());
		return closestCollector == null ? null : closestCollector.getManaReceiverPos();
	}

	public void emptyManaIntoCollector() {
		ManaCollector collector = findBoundTile();
		if (collector != null && !collector.isFull() && getMana() > 0) {
			int manaval = Math.min(getMana(), collector.getMaxMana() - collector.getCurrentMana());
			addMana(-manaval);
			collector.receiveMana(manaval);
			sync();
		}
	}

	public void addMana(int mana) {
		this.mana = Math.min(getMaxMana(), this.getMana() + mana);
		method_5431();
	}

	public int getMana() {
		return mana;
	}

	public abstract int getMaxMana();

	public abstract int getColor();

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		mana = cmp.method_10550(TAG_MANA);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_MANA, getMana());
	}

	public class_1799 getHudIcon() {
		return class_2378.field_11142.method_17966(SPREADER_ID).map(class_1799::new).orElse(class_1799.field_8037);
	}

	public static class GeneratingWandHud<T extends GeneratingFlowerBlockEntity> implements WandHUD {
		protected final T flower;

		public GeneratingWandHud(T flower) {
			this.flower = flower;
		}

		@Override
		public void renderHUD(class_4587 ms, class_310 mc) {
			String name = class_1074.method_4662(flower.method_11010().method_26204().method_9539());
			int color = flower.getColor();
			BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, flower.getMana(), flower.getMaxMana(),
					name, flower.getHudIcon(), flower.isValidBinding());
		}
	}
}
