/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api;

import vazkii.botania.api.block.FloatingFlower;

import java.util.Collections;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

/**
 * Class for API calls that must be made clientside
 */
public interface BotaniaAPIClient {
	BotaniaAPIClient INSTANCE = ServiceUtil.findService(BotaniaAPIClient.class, () -> new BotaniaAPIClient() {});

	static BotaniaAPIClient instance() {
		return INSTANCE;
	}

	/**
	 * Registers your model for island type islandType here.
	 * Call this during {@link net.minecraftforge.client.event.ModelRegistryEvent}.
	 *
	 * @param islandType The islandtype to register
	 * @param model      The model, only {@link class_2960} allowed, no {@link ModelResourceLocation} allowed.
	 */
	default void registerIslandTypeModel(FloatingFlower.IslandType islandType, class_2960 model) {}

	/**
	 * @return An immutable and live view of the registered island type model map
	 */
	default Map<FloatingFlower.IslandType, class_2960> getRegisteredIslandTypeModels() {
		return Collections.emptyMap();
	}

	/**
	 * Draw a mana bar on the screen
	 */
	default void drawSimpleManaHUD(class_4587 ms, int color, int mana, int maxMana, String name) {}

	/**
	 * Performs the effects of {@link #drawSimpleManaHUD}, then renders {@code bindDisplay}, and a checkmark or x-mark
	 * dependong on the value of {@code properlyBound}.
	 */
	default void drawComplexManaHUD(class_4587 ms, int color, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {}
}
