/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.internal.DummyManaNetwork;
import vazkii.botania.api.internal.ManaNetwork;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public interface BotaniaAPI {
	String MODID = "botania";
	String GOG_MODID = "gardenofglass";
	Logger LOGGER = LoggerFactory.getLogger(MODID);

	BotaniaAPI INSTANCE = ServiceUtil.findService(BotaniaAPI.class, () -> new BotaniaAPI() {});

	static BotaniaAPI instance() {
		return INSTANCE;
	}

	/**
	 * @return A unique version number for this version of the API. When anything is added, this number will be
	 *         incremented
	 */
	default int apiVersion() {
		return 0;
	}

	/**
	 * Get the registry for brews.
	 * Forge note: This registry is a vanilla registry, not a Forge one. Use vanilla's
	 * methods to register to it. Its integer ID's are not synced, as a result.
	 */
	default class_2378<Brew> getBrewRegistry() {
		return null;
	}

	default Map<class_2960, Function<class_1767, class_2248>> getPaintableBlocks() {
		return Collections.emptyMap();
	}

	default void registerPaintableBlock(class_2248 block, Function<class_1767, class_2248> transformer) {
		registerPaintableBlock(class_2378.field_11146.method_10221(block), transformer);
	}

	/**
	 * Make Botania aware of how to transform between different colors of a block, for use in the paint lens.
	 * This method can be safely called during parallel mod initialization
	 * 
	 * @param blockId     The block ID
	 * @param transformer Function from color to a new block
	 */
	default void registerPaintableBlock(class_2960 blockId, Function<class_1767, class_2248> transformer) {

	}

	class_1741 DUMMY_ARMOR_MATERIAL = new class_1741() {
		@Override
		public int method_7696(@NotNull class_1304 slot) {
			return 0;
		}

		@Override
		public int method_7697(@NotNull class_1304 slot) {
			return 0;
		}

		@Override
		public int method_7699() {
			return 0;
		}

		@NotNull
		@Override
		public class_3414 method_7698() {
			return class_3417.field_14581;
		}

		@NotNull
		@Override
		public class_1856 method_7695() {
			return class_1856.field_9017;
		}

		@Override
		public String method_7694() {
			return "missingno";
		}

		@Override
		public float method_7700() {
			return 0;
		}

		@Override
		public float method_24355() {
			return 0;
		}
	};

	class_1832 DUMMY_ITEM_TIER = new class_1832() {
		@Override
		public int method_8025() {
			return 0;
		}

		@Override
		public float method_8027() {
			return 0;
		}

		@Override
		public float method_8028() {
			return 0;
		}

		@Override
		public int method_8024() {
			return 0;
		}

		@Override
		public int method_8026() {
			return 0;
		}

		@NotNull
		@Override
		public class_1856 method_8023() {
			return class_1856.field_9017;
		}
	};

	default class_1741 getManasteelArmorMaterial() {
		return DUMMY_ARMOR_MATERIAL;
	}

	default class_1741 getElementiumArmorMaterial() {
		return DUMMY_ARMOR_MATERIAL;
	}

	default class_1741 getManaweaveArmorMaterial() {
		return DUMMY_ARMOR_MATERIAL;
	}

	default class_1741 getTerrasteelArmorMaterial() {
		return DUMMY_ARMOR_MATERIAL;
	}

	default class_1832 getManasteelItemTier() {
		return DUMMY_ITEM_TIER;
	}

	default class_1832 getElementiumItemTier() {
		return DUMMY_ITEM_TIER;
	}

	default class_1832 getTerrasteelItemTier() {
		return DUMMY_ITEM_TIER;
	}

	default class_1814 getRelicRarity() {
		return class_1814.field_8904;
	}

	default ManaNetwork getManaNetworkInstance() {
		return DummyManaNetwork.instance;
	}

	default class_1263 getAccessoriesInventory(class_1657 player) {
		return new class_1277(0);
	}

	/**
	 * Break all the blocks the given player has selected with the loki ring.
	 * The item passed must implement {@link vazkii.botania.api.item.SequentialBreaker}.
	 */
	default void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {}

	default boolean hasSolegnoliaAround(class_1297 e) {
		return false;
	}

	default void sparkleFX(class_1937 world, double x, double y, double z, float r, float g, float b, float size, int m) {}

	default void registerCorporeaNodeDetector(CorporeaNodeDetector detector) {

	}
}
