/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item.lens;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2453;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4516;
import net.minecraft.class_6300;
import net.minecraft.class_6301;
import net.minecraft.class_6302;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.test.DelegatingConfigAccess;
import vazkii.botania.test.TestingUtil;
import vazkii.botania.xplat.BotaniaConfig;

public class LensMineTest {
    private static final String ARENA = "botania:item/lens/lens_mine";
    private static final String WOOD_LEVEL_BATCH = "botania:lens_mine_test_mining_level_0";
    private static final String STONE_LEVEL_BATCH = "botania:lens_mine_test_mining_level_1";
    private static final String IRON_LEVEL_BATCH = "botania:lens_mine_test_mining_level_2";
    private static final String DIAMOND_LEVEL_BATCH = "botania:lens_mine_test_mining_level_3";

    private void mockMiningLevel(final int level) {
        BotaniaConfig.setCommon(new DelegatingConfigAccess(BotaniaConfig.common()){

            @Override
            public int harvestLevelBore() {
                return level;
            }
        });
    }

    private void restoreConfig() {
        BotaniaConfig.setCommon(((DelegatingConfigAccess)BotaniaConfig.common()).getInner());
    }

    @class_6301(method_35931="botania:lens_mine_test_mining_level_0")
    public void beforeWoodBatch(class_3218 level) {
        this.mockMiningLevel(0);
    }

    @class_6301(method_35931="botania:lens_mine_test_mining_level_1")
    public void beforeStoneBatch(class_3218 level) {
        this.mockMiningLevel(1);
    }

    @class_6301(method_35931="botania:lens_mine_test_mining_level_2")
    public void beforeIronBatch(class_3218 level) {
        this.mockMiningLevel(2);
    }

    @class_6301(method_35931="botania:lens_mine_test_mining_level_3")
    public void beforeDiamondBatch(class_3218 level) {
        this.mockMiningLevel(3);
    }

    @class_6300(method_35930="botania:lens_mine_test_mining_level_0")
    public void afterWoodBatch(class_3218 level) {
        this.restoreConfig();
    }

    @class_6300(method_35930="botania:lens_mine_test_mining_level_1")
    public void afterStoneBatch(class_3218 level) {
        this.restoreConfig();
    }

    @class_6300(method_35930="botania:lens_mine_test_mining_level_2")
    public void afterIronBatch(class_3218 level) {
        this.restoreConfig();
    }

    @class_6300(method_35930="botania:lens_mine_test_mining_level_3")
    public void afterDiamondBatch(class_3218 level) {
        this.restoreConfig();
    }

    private void testMine(class_4516 helper, class_2248 toMine, boolean expectSuccess) {
        class_2338 spreaderPos = new class_2338(1, 2, 0);
        class_2338 manaVoidPos = new class_2338(1, 2, 3);
        class_2338 lampPos = new class_2338(2, 2, 2);
        class_2338 buttonPos = new class_2338(2, 2, 0);
        class_2338 testPos = new class_2338(1, 2, 1);
        class_1657 player = helper.method_36021();
        TileSpreader spreader = TestingUtil.assertBlockEntity(helper, spreaderPos, ModTiles.SPREADER);
        TestingUtil.assertThat(spreader.bindTo(player, new class_1799((class_1935)ModItems.twigWand), helper.method_36052(manaVoidPos), class_2350.field_11036), () -> "Failed to bind spreader");
        helper.method_35984(testPos, toMine);
        if (expectSuccess) {
            helper.method_36041().method_36085(() -> helper.method_36026(buttonPos)).method_36079(() -> helper.method_35987(lampPos, (class_2769)class_2453.field_11413, (Comparable)Boolean.valueOf(true))).method_36075();
        } else {
            helper.method_36041().method_36085(() -> helper.method_36026(buttonPos)).method_36084(60, () -> helper.method_35987(lampPos, (class_2769)class_2453.field_11413, (Comparable)Boolean.valueOf(false))).method_36075();
        }
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_0")
    public void testSnow(class_4516 helper) {
        this.testMine(helper, class_2246.field_10491, true);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_0")
    public void testStone(class_4516 helper) {
        this.testMine(helper, class_2246.field_10340, true);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_0")
    public void testLog(class_4516 helper) {
        this.testMine(helper, class_2246.field_10431, true);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_0")
    public void testIronBlockTooLow(class_4516 helper) {
        this.testMine(helper, class_2246.field_10085, false);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_1")
    public void testIronBlock(class_4516 helper) {
        this.testMine(helper, class_2246.field_10085, true);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_1")
    public void testGoldOreTooLow(class_4516 helper) {
        this.testMine(helper, class_2246.field_10571, false);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_2")
    public void testGoldOre(class_4516 helper) {
        this.testMine(helper, class_2246.field_10571, true);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_2")
    public void testObsidianTooLow(class_4516 helper) {
        this.testMine(helper, class_2246.field_10540, false);
    }

    @class_6302(method_35936="botania:item/lens/lens_mine", method_35933="botania:lens_mine_test_mining_level_3")
    public void testObsidian(class_4516 helper) {
        this.testMine(helper, class_2246.field_10540, true);
    }
}

