/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.rei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeBrew;
import vazkii.botania.common.crafting.RecipeElvenTrade;
import vazkii.botania.common.crafting.RecipeManaInfusion;
import vazkii.botania.common.crafting.RecipeMarimorphosis;
import vazkii.botania.common.crafting.RecipeOrechid;
import vazkii.botania.common.crafting.RecipeOrechidIgnem;
import vazkii.botania.common.crafting.RecipePetals;
import vazkii.botania.common.crafting.RecipePureDaisy;
import vazkii.botania.common.crafting.RecipeRuneAltar;
import vazkii.botania.common.crafting.RecipeTerraPlate;
import vazkii.botania.common.item.ItemAncientWill;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.fabric.integration.rei.BotaniaREICategoryIdentifiers;
import vazkii.botania.fabric.integration.rei.BreweryREICategory;
import vazkii.botania.fabric.integration.rei.BreweryREIDisplay;
import vazkii.botania.fabric.integration.rei.ElvenTradeREICategory;
import vazkii.botania.fabric.integration.rei.ElvenTradeREIDisplay;
import vazkii.botania.fabric.integration.rei.ManaPoolREICategory;
import vazkii.botania.fabric.integration.rei.ManaPoolREIDisplay;
import vazkii.botania.fabric.integration.rei.MarimorphosisREIDisplay;
import vazkii.botania.fabric.integration.rei.OrechidIgnemREIDisplay;
import vazkii.botania.fabric.integration.rei.OrechidREICategory;
import vazkii.botania.fabric.integration.rei.OrechidREIDisplay;
import vazkii.botania.fabric.integration.rei.PetalApothecaryREICategory;
import vazkii.botania.fabric.integration.rei.PetalApothecaryREIDisplay;
import vazkii.botania.fabric.integration.rei.PureDaisyREICategory;
import vazkii.botania.fabric.integration.rei.PureDaisyREIDisplay;
import vazkii.botania.fabric.integration.rei.RunicAltarREICategory;
import vazkii.botania.fabric.integration.rei.RunicAltarREIDisplay;
import vazkii.botania.fabric.integration.rei.TerraPlateREICategory;
import vazkii.botania.fabric.integration.rei.TerraPlateREIDisplay;
import vazkii.botania.fabric.xplat.FabricXplatImpl;

public class BotaniaREIPlugin
implements REIClientPlugin {
    public BotaniaREIPlugin() {
        Supplier<class_1799> old = CorporeaInputHandler.hoveredStackGetter;
        CorporeaInputHandler.hoveredStackGetter = () -> {
            class_1799 stack = BotaniaREIPlugin.getHoveredREIStack();
            if (!stack.method_7960()) {
                return stack;
            }
            return (class_1799)old.get();
        };
        CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(s -> s instanceof DisplayScreen);
    }

    public void registerCategories(CategoryRegistry helper) {
        helper.add(List.of(new PetalApothecaryREICategory(), new PureDaisyREICategory(), new ManaPoolREICategory(), new RunicAltarREICategory(), new ElvenTradeREICategory(), new BreweryREICategory(), new TerraPlateREICategory(), new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID, ModSubtiles.orechid), new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, ModSubtiles.orechidIgnem), new OrechidREICategory(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, ModSubtiles.marimorphosis)));
        helper.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1935)ModItems.craftingHalo), EntryStacks.of((class_1935)ModItems.autocraftingHalo)});
        ImmutableSet apothecaries = ImmutableSet.of((Object)ModBlocks.defaultAltar, (Object)ModBlocks.desertAltar, (Object)ModBlocks.forestAltar, (Object)ModBlocks.fungalAltar, (Object)ModBlocks.mesaAltar, (Object)ModBlocks.mossyAltar, (Object[])new class_1935[]{ModBlocks.mountainAltar, ModBlocks.plainsAltar, ModBlocks.swampAltar, ModBlocks.taigaAltar});
        for (class_1935 altar : apothecaries) {
            helper.addWorkstations(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, new EntryStack[]{EntryStacks.of((class_1935)altar)});
        }
        helper.addWorkstations(BotaniaREICategoryIdentifiers.BREWERY, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.brewery)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ELVEN_TRADE, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.alfPortal)});
        ImmutableSet manaPools = ImmutableSet.of((Object)ModBlocks.manaPool, (Object)ModBlocks.dilutedPool, (Object)ModBlocks.fabulousPool);
        for (class_1935 pool : manaPools) {
            helper.addWorkstations(BotaniaREICategoryIdentifiers.MANA_INFUSION, new EntryStack[]{EntryStacks.of((class_1935)pool)});
        }
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID, new EntryStack[]{EntryStacks.of((class_1935)ModSubtiles.orechid), EntryStacks.of((class_1935)ModSubtiles.orechidFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, new EntryStack[]{EntryStacks.of((class_1935)ModSubtiles.orechidIgnem), EntryStacks.of((class_1935)ModSubtiles.orechidIgnemFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, new EntryStack[]{EntryStacks.of((class_1935)ModSubtiles.marimorphosis), EntryStacks.of((class_1935)ModSubtiles.marimorphosisFloating), EntryStacks.of((class_1935)ModSubtiles.marimorphosisChibi), EntryStacks.of((class_1935)ModSubtiles.marimorphosisChibiFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.PURE_DAISY, new EntryStack[]{EntryStacks.of((class_1935)ModSubtiles.pureDaisy), EntryStacks.of((class_1935)ModSubtiles.pureDaisyFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.RUNE_ALTAR, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.runeAltar)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.TERRA_PLATE, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.terraPlate)});
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.BREWERY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ELVEN_TRADE, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MANA_INFUSION, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PURE_DAISY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.RUNE_ALTAR, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.TERRA_PLATE, null);
    }

    public void registerDisplays(DisplayRegistry helper) {
        this.registerAncientWillRecipeWrapper(helper);
        this.registerCompositeLensRecipeWrapper(helper);
        this.registerTerraPickTippingRecipeWrapper(helper);
        helper.registerFiller(RecipePetals.class, PetalApothecaryREIDisplay::new);
        helper.registerFiller(RecipeBrew.class, BreweryREIDisplay::new);
        Predicate<RecipeElvenTrade> pred = recipe -> !recipe.isReturnRecipe();
        helper.registerFiller(RecipeElvenTrade.class, pred, ElvenTradeREIDisplay::new);
        helper.registerFiller(LexiconElvenTradeRecipe.class, ElvenTradeREIDisplay::new);
        helper.registerFiller(RecipeManaInfusion.class, ManaPoolREIDisplay::new);
        helper.registerFiller(RecipePureDaisy.class, PureDaisyREIDisplay::new);
        helper.registerFiller(RecipeRuneAltar.class, RunicAltarREIDisplay::new);
        helper.registerFiller(RecipeTerraPlate.class, TerraPlateREIDisplay::new);
        try {
            for (Map.Entry<class_2248, class_2248> entry : FabricXplatImpl.CUSTOM_STRIPPING.entrySet()) {
                helper.add((Display)new DefaultStrippingDisplay(EntryStacks.of((class_1935)((class_1935)entry.getKey())), EntryStacks.of((class_1935)((class_1935)entry.getValue()))));
            }
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error adding strippable entry to REI", (Throwable)e);
        }
        Object2IntMap<class_2248> weights = BotaniaREIPlugin.getWeights(ModRecipeTypes.ORECHID_TYPE, helper.getRecipeManager());
        helper.registerRecipeFiller(RecipeOrechid.class, ModRecipeTypes.ORECHID_TYPE, r -> new OrechidREIDisplay((RecipeOrechid)r, weights.getInt((Object)r.getInput())));
        Object2IntMap<class_2248> weightsIgnem = BotaniaREIPlugin.getWeights(ModRecipeTypes.ORECHID_IGNEM_TYPE, helper.getRecipeManager());
        helper.registerRecipeFiller(RecipeOrechidIgnem.class, ModRecipeTypes.ORECHID_IGNEM_TYPE, r -> new OrechidIgnemREIDisplay((RecipeOrechidIgnem)r, weightsIgnem.getInt((Object)r.getInput())));
        Object2IntMap<class_2248> weightsMarim = BotaniaREIPlugin.getWeights(ModRecipeTypes.MARIMORPHOSIS_TYPE, helper.getRecipeManager());
        helper.registerRecipeFiller(RecipeMarimorphosis.class, ModRecipeTypes.MARIMORPHOSIS_TYPE, r -> new MarimorphosisREIDisplay((RecipeMarimorphosis)r, weightsMarim.getInt((Object)r.getInput())));
    }

    public static Object2IntMap<class_2248> getWeights(class_3956<? extends IOrechidRecipe> type, class_1863 manager) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (IOrechidRecipe recipe : manager.method_30027(type)) {
            map.addTo((Object)recipe.getInput(), recipe.getWeight());
        }
        return map;
    }

    void registerAncientWillRecipeWrapper(DisplayRegistry helper) {
        ImmutableList.Builder input = ImmutableList.builder();
        ImmutableList.Builder output = ImmutableList.builder();
        ImmutableSet wills = ImmutableSet.of((Object)new class_1799((class_1935)ModItems.ancientWillAhrim), (Object)new class_1799((class_1935)ModItems.ancientWillDharok), (Object)new class_1799((class_1935)ModItems.ancientWillGuthan), (Object)new class_1799((class_1935)ModItems.ancientWillKaril), (Object)new class_1799((class_1935)ModItems.ancientWillTorag), (Object)new class_1799((class_1935)ModItems.ancientWillVerac), (Object[])new class_1799[0]);
        IAncientWillContainer container = (IAncientWillContainer)ModItems.terrasteelHelm;
        class_1799 helmet = new class_1799((class_1935)ModItems.terrasteelHelm);
        input.add((Object)EntryIngredients.of((class_1799)helmet));
        input.add((Object)EntryIngredients.ofItemStacks((Collection)wills));
        for (class_1799 will : wills) {
            class_1799 copy = helmet.method_7972();
            container.addAncientWill(copy, ((ItemAncientWill)will.method_7909()).type);
            output.add((Object)EntryStacks.of((class_1799)copy));
        }
        helper.add((Display)new DefaultCustomDisplay(null, (List)input.build(), Collections.singletonList(EntryIngredient.of((Iterable)output.build()))));
    }

    void registerCompositeLensRecipeWrapper(DisplayRegistry helper) {
        List<class_1799> lensStacks = StreamSupport.stream(class_2378.field_11142.method_40286(ModTags.Items.LENS).spliterator(), false).map(class_1799::new).filter(s -> !((ItemLens)s.method_7909()).isControlLens((class_1799)s)).filter(s -> ((ItemLens)s.method_7909()).isCombinable((class_1799)s)).toList();
        List<class_1792> lenses = lensStacks.stream().map(class_1799::method_7909).toList();
        List<EntryIngredient> inputs = Arrays.asList(EntryIngredients.ofItemStacks(lensStacks), EntryIngredients.of((class_1799)new class_1799((class_1935)class_1802.field_8777)), EntryIngredients.ofItemStacks(lensStacks));
        int end = lenses.size() - 1;
        ArrayList<class_1799> firstInput = new ArrayList<class_1799>();
        ArrayList<class_1799> secondInput = new ArrayList<class_1799>();
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (int i = 1; i <= end; ++i) {
            class_1799 firstLens = new class_1799((class_1935)lenses.get(i));
            for (class_1792 secondLens : lenses) {
                if (secondLens == firstLens.method_7909()) continue;
                class_1799 secondLensStack = new class_1799((class_1935)secondLens);
                if (!((ItemLens)firstLens.method_7909()).canCombineLenses(firstLens, secondLensStack)) continue;
                firstInput.add(firstLens);
                secondInput.add(secondLensStack);
                outputs.add(((ItemLens)firstLens.method_7909()).setCompositeLens(firstLens.method_7972(), secondLensStack));
            }
        }
        inputs.set(0, EntryIngredients.ofItemStacks(firstInput));
        inputs.set(2, EntryIngredients.ofItemStacks(secondInput));
        helper.add((Display)new DefaultCustomDisplay(null, inputs, Collections.singletonList(EntryIngredients.ofItemStacks(outputs))));
    }

    void registerTerraPickTippingRecipeWrapper(DisplayRegistry helper) {
        ImmutableList inputs = ImmutableList.of((Object)EntryIngredients.of((class_1935)ModItems.terraPick), (Object)EntryIngredients.of((class_1935)ModItems.elementiumPick));
        class_1799 output = new class_1799((class_1935)ModItems.terraPick);
        ItemTerraPick.setTipped(output);
        helper.add((Display)new DefaultCustomDisplay(null, (List)inputs, Collections.singletonList(EntryIngredients.of((class_1799)output))));
    }

    private static class_1799 getHoveredREIStack() {
        return REIRuntime.getInstance().getOverlay().map(o -> {
            class_1799 stack;
            if (REIRuntime.getInstance().isOverlayVisible()) {
                stack = BotaniaREIPlugin.unwrapEntry(o.getEntryList().getFocusedStack());
                if (!stack.method_7960()) {
                    return stack;
                }
                stack = o.getFavoritesList().map(OverlayListWidget::getFocusedStack).map(BotaniaREIPlugin::unwrapEntry).orElse(class_1799.field_8037);
                if (!stack.method_7960()) {
                    return stack;
                }
            }
            if (class_310.method_1551().field_1755 instanceof DisplayScreen) {
                Point point = PointHelper.ofMouse();
                for (class_364 child : class_310.method_1551().field_1755.method_25396()) {
                    Slot slot;
                    if (!child.method_25405((double)point.x, (double)point.y) || !(child instanceof Slot) || (stack = BotaniaREIPlugin.unwrapEntry((slot = (Slot)child).getCurrentEntry())).method_7960()) continue;
                    return stack;
                }
            }
            return class_1799.field_8037;
        }).orElse(class_1799.field_8037);
    }

    private static class_1799 unwrapEntry(@Nullable EntryStack<?> stack) {
        if (stack != null && !stack.isEmpty() && stack.getType() == VanillaEntryTypes.ITEM) {
            return (class_1799)stack.getValue();
        }
        return class_1799.field_8037;
    }
}

