/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2521;
import net.minecraft.class_2544;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4778;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4938;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7403;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockBuriedPetals;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.decor.panes.BlockModPane;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorBlockModelGenerators;
import vazkii.botania.mixin.AccessorTextureSlot;

public class BlockstateProvider
implements class_2405 {
    private final class_2403 generator;
    private final List<class_4917> blockstates = new ArrayList<class_4917>();
    private final Map<class_2960, Supplier<JsonElement>> models = new HashMap<class_2960, Supplier<JsonElement>>();
    private final BiConsumer<class_2960, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(class_2403 generator) {
        this.generator = generator;
    }

    @NotNull
    public String method_10321() {
        return "Botania Blockstates and Models";
    }

    public void method_10319(class_7403 cache) {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Path root = this.generator.method_10313();
        for (class_4917 class_49172 : this.blockstates) {
            class_2960 id = class_2378.field_11146.method_10221((Object)class_49172.method_25743());
            path = root.resolve("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json");
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)class_49172.get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating blockstate file for {}", (Object)id, (Object)ex);
            }
        }
        for (Map.Entry entry : this.models.entrySet()) {
            class_2960 modelId = (class_2960)entry.getKey();
            path = root.resolve("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json");
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating model file {}", (Object)modelId, (Object)ex);
            }
        }
    }

    private void registerStatesAndModels() {
        Set<class_2248> remainingBlocks = class_2378.field_11146.method_10220().filter(b -> "botania".equals(class_2378.field_11146.method_10221(b).method_12836())).collect(Collectors.toSet());
        remainingBlocks.remove(ModBlocks.ghostRail);
        remainingBlocks.remove(ModBlocks.solidVines);
        this.manualModel(remainingBlocks, ModBlocks.cocoon);
        this.manualModel(remainingBlocks, ModBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, ModBlocks.distributor);
        this.manualModel(remainingBlocks, ModBlocks.prism);
        this.manualModel(remainingBlocks, ModBlocks.runeAltar);
        this.manualModel(remainingBlocks, ModBlocks.spawnerClaw);
        class_2960 alfPortalModel = class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.alfPortal), class_4944.method_25864((class_2248)ModBlocks.alfPortal), this.modelOutput);
        class_2960 alfPortalActivatedModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated"), class_4944.method_25875((class_2960)class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.alfPortal).method_25775((class_4926)class_4926.method_25783(BotaniaStateProps.ALFPORTAL_STATE).method_25793((Comparable)((Object)AlfPortalState.OFF), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalModel)).method_25793((Comparable)((Object)AlfPortalState.ON_X), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel)).method_25793((Comparable)((Object)AlfPortalState.ON_Z), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(ModBlocks.alfPortal);
        this.singleVariantBlockState(ModBlocks.bifrostPerm, class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.bifrostPerm), class_4944.method_25864((class_2248)ModBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(ModBlocks.bifrostPerm);
        this.singleVariantBlockState(ModBlocks.cacophonium, class_4943.field_22976.method_25846(ModBlocks.cacophonium, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)class_2246.field_10179)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.cacophonium);
        class_4942 crateTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23018});
        class_2960 craftCrateBottomTex = class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)"_bottom");
        class_4926.class_4927 crateDispatch = class_4926.method_25783(BotaniaStateProps.CRATE_PATTERN);
        for (CratePattern pattern : CratePattern.values()) {
            String suffix = pattern == CratePattern.NONE ? "" : "_" + pattern.method_15434().substring("crafty_".length());
            class_2960 model = crateTemplate.method_25852(class_4941.method_25843((class_2248)ModBlocks.craftCrate, (String)suffix), new class_4944().method_25868(class_4945.field_23014, craftCrateBottomTex).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.method_25793((Comparable)((Object)pattern), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model));
        }
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.craftCrate).method_25775((class_4926)crateDispatch));
        remainingBlocks.remove(ModBlocks.craftCrate);
        class_2960 corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        class_2960 corpBlock = class_4944.method_25860((class_2248)ModBlocks.corporeaBlock);
        class_2960 corpSlabBottomModel = class_4943.field_22909.method_25846((class_2248)ModBlocks.corporeaSlab, new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabTopModel = class_4943.field_22910.method_25852(class_4941.method_25843((class_2248)ModBlocks.corporeaSlab, (String)"_top"), new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabDoubleModel = class_4943.field_22977.method_25852(ResourceLocationHelper.prefix("block/corporea_double_slab"), new class_4944().method_25868(class_4945.field_23018, corpSlabSide).method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock), this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeSlabState((class_2248)ModBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(ModBlocks.corporeaSlab);
        this.stairsBlock(remainingBlocks, (class_2248)ModBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        this.blockstates.add((class_4917)class_4925.method_25771((class_2248)ModBlocks.elfGlass, (class_4935[])((class_4935[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            class_2960 model = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.elfGlass, (String)("_" + i)), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)ModBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
        }).toArray(class_4935[]::new))));
        remainingBlocks.remove(ModBlocks.elfGlass);
        this.singleVariantBlockState(ModBlocks.enchantedSoil, class_4943.field_22977.method_25846(ModBlocks.enchantedSoil, class_4944.method_25898((class_2248)ModBlocks.enchantedSoil).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)), this.modelOutput));
        remainingBlocks.remove(ModBlocks.enchantedSoil);
        class_2960 pumpkinModel = class_4943.field_22978.method_25846(ModBlocks.felPumpkin, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_side")).method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)ModBlocks.felPumpkin)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_top")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.felPumpkin, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)pumpkinModel)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.felPumpkin);
        class_4942 eightByEightTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021});
        this.singleVariantBlockState(ModBlocks.forestEye, eightByEightTemplate.method_25846(ModBlocks.forestEye, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_bottom")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_top")).method_25868(class_4945.field_23019, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_north")).method_25868(class_4945.field_23020, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_south")).method_25868(class_4945.field_23022, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_west")).method_25868(class_4945.field_23021, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.forestEye);
        class_2960 plateFile = class_4941.method_25842((class_2248)ModBlocks.incensePlate);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.incensePlate, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plateFile)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.incensePlate);
        class_4942 fourHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.lightLauncher, fourHighBottomTopTemplate.method_25846(ModBlocks.lightLauncher, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.lightLauncher);
        this.singleVariantBlockState(ModBlocks.openCrate, crateTemplate.method_25846(ModBlocks.openCrate, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)ModBlocks.openCrate)).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.openCrate);
        class_4942 threeHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.sparkChanger, threeHighBottomTopTemplate.method_25846(ModBlocks.sparkChanger, class_4944.method_25898((class_2248)ModBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(ModBlocks.sparkChanger);
        this.singleVariantBlockState(ModBlocks.starfield, fourHighBottomTopTemplate.method_25846(ModBlocks.starfield, class_4944.method_25898((class_2248)ModBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(ModBlocks.starfield);
        this.singleVariantBlockState(ModBlocks.terraPlate, threeHighBottomTopTemplate.method_25846(ModBlocks.terraPlate, class_4944.method_25898((class_2248)ModBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(ModBlocks.terraPlate);
        class_4942 tenByTenAllTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        this.singleVariantBlockState(ModBlocks.tinyPlanet, tenByTenAllTemplate.method_25846(ModBlocks.tinyPlanet, class_4944.method_25864((class_2248)ModBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(ModBlocks.tinyPlanet);
        this.singleVariantBlockState(ModBlocks.turntable, class_4943.field_22977.method_25846(ModBlocks.turntable, class_4944.method_25898((class_2248)ModBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(ModBlocks.turntable);
        class_2960[] topTexs = new class_2960[6];
        class_2960[] sideTexs = new class_2960[6];
        class_2960[] topStrippedTexs = new class_2960[6];
        class_2960[] sideStrippedTexs = new class_2960[6];
        class_2960[] sideGlimmeringTexs = new class_2960[6];
        class_2960[] sideGlimmeringStrippedTexs = new class_2960[6];
        class_2960[] logModels = new class_2960[6];
        class_2960[] strippedLogModels = new class_2960[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            Object suffix = i2 == 0 ? "" : "_" + i2;
            sideTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)suffix);
            topTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)"_top");
            sideStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)suffix);
            topStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)"_top");
            sideGlimmeringTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogGlimmering, (String)suffix);
            sideGlimmeringStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStrippedGlimmering, (String)suffix);
            logModels[i2] = class_4941.method_25843((class_2248)ModBlocks.dreamwood, (String)suffix);
            strippedLogModels[i2] = class_4941.method_25843((class_2248)ModBlocks.dreamwoodStripped, (String)suffix);
        }
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLog, topTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwood, sideTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStairs, sideTexs, sideTexs, sideTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodWall, sideTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedWall, sideStrippedTexs);
        this.pillar(remainingBlocks, ModBlocks.livingwoodLog, class_4944.method_25866((class_2248)ModBlocks.livingwoodLog, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwood, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStripped, class_4944.method_25866((class_2248)ModBlocks.livingwoodLogStripped, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStripped, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogGlimmering, class_4944.method_25866((class_2248)ModBlocks.livingwoodLog, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodGlimmering, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStrippedGlimmering, class_4944.method_25866((class_2248)ModBlocks.livingwoodLogStripped, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStrippedGlimmering, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillarAlt(remainingBlocks, ModBlocks.livingwoodFramed, class_4944.method_25860((class_2248)ModBlocks.livingwoodPatternFramed), class_4944.method_25860((class_2248)ModBlocks.livingwoodFramed));
        this.pillarAlt(remainingBlocks, ModBlocks.dreamwoodFramed, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPatternFramed), class_4944.method_25860((class_2248)ModBlocks.dreamwoodFramed));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStairs, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedStairs, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodSlab, class_4941.method_25842((class_2248)ModBlocks.livingwood), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedSlab, class_4941.method_25842((class_2248)ModBlocks.livingwoodStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodWall, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedWall, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.fenceBlock(ModFluffBlocks.dreamwoodFence, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.dreamwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceBlock(ModFluffBlocks.livingwoodFence, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.livingwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFence);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFenceGate);
        this.particleOnly(remainingBlocks, ModBlocks.animatedTorch, class_4944.method_25860((class_2248)class_2246.field_10523));
        this.particleOnly(remainingBlocks, ModBlocks.avatar, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.bellows, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.brewery, class_4944.method_25860((class_2248)ModBlocks.livingrock));
        this.particleOnly(remainingBlocks, ModBlocks.corporeaIndex, class_4944.method_25860((class_2248)ModBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDetector, class_4944.method_25860((class_2248)ModBlocks.lightRelayDetector));
        this.singleVariantBlockState(ModBlocks.fakeAir, new class_4942(Optional.empty(), Optional.empty(), new class_4945[0]).method_25846(ModBlocks.fakeAir, new class_4944(), this.modelOutput));
        remainingBlocks.remove(ModBlocks.fakeAir);
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayFork, class_4944.method_25860((class_2248)ModBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHead, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHeadWall, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaPylon, class_4944.method_25860((class_2248)ModBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, ModBlocks.hourglass, class_4944.method_25860((class_2248)ModBlocks.manaGlass));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDefault, class_4944.method_25860((class_2248)ModBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, ModBlocks.manaFlame, new class_2960("block/fire_0"));
        this.particleOnly(remainingBlocks, ModBlocks.manaPylon, class_4944.method_25860((class_2248)ModBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.naturaPylon, class_4944.method_25860((class_2248)ModBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.teruTeruBozu, class_4944.method_25860((class_2248)class_2246.field_10446));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayToggle, class_4944.method_25860((class_2248)ModBlocks.lightRelayToggle));
        Predicate<class_2248> flowers = b -> b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockModFlower;
        class_4942 crossTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new class_4945[]{class_4945.field_23025});
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockMotifFlower).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832().replace("_motif", "");
            this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23025, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.corporeaFunnel, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4943.field_22974.method_25846(b, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)b, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)b, (String)"_end")), this.modelOutput)));
        class_4942 drumModelTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23018});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.gatheringDrum, ModBlocks.canopyDrum, ModBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((class_2248)b, drumModelTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23015, ResourceLocationHelper.prefix("block/drum_top")).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)b)), this.modelOutput)));
        class_4945 outsideSlot = AccessorTextureSlot.make("outside");
        class_4945 coreSlot = AccessorTextureSlot.make("core");
        class_4942 spreaderTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_23017, class_4945.field_27791, outsideSlot});
        class_4942 spreaderCoreTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_core")), Optional.of("_core"), new class_4945[]{coreSlot});
        class_4942 spreaderPaddingTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_padding")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23017, class_4945.field_23018});
        class_4942 spreaderScaffoldingTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_scaffolding")), Optional.of("_scaffolding"), new class_4945[]{class_4945.field_23015, class_4945.field_23018, class_4945.field_23014});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaSpreader, ModBlocks.redstoneSpreader, ModBlocks.gaiaSpreader, ModBlocks.elvenSpreader).forEach(b -> {
            class_2960 outside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? class_4944.method_25860((class_2248)ModBlocks.livingwoodLog) : (b == ModBlocks.elvenSpreader ? class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)"_3") : class_4944.method_25866((class_2248)b, (String)"_outside"));
            class_2960 inside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped) : (b == ModBlocks.elvenSpreader ? class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)"_3") : class_4944.method_25866((class_2248)b, (String)"_inside"));
            this.singleVariantBlockState((class_2248)b, spreaderTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)b, (String)"_back")).method_25868(class_4945.field_27791, inside).method_25868(outsideSlot, outside), this.modelOutput));
            spreaderCoreTemplate.method_25846(b, new class_4944().method_25868(coreSlot, class_4944.method_25866((class_2248)b, (String)"_core")), this.modelOutput);
            if (b != ModBlocks.redstoneSpreader) {
                spreaderScaffoldingTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_scaffolding_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_scaffolding_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)b, (String)"_scaffolding_bottom")), this.modelOutput);
            }
        });
        for (class_1767 color : class_1767.values()) {
            class_2248 wool = ColorHelper.WOOL_MAP.apply(color);
            spreaderPaddingTemplate.method_25852(ResourceLocationHelper.prefix("block/" + color.method_7792() + "_spreader_padding"), new class_4944().method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)wool)).method_25868(class_4945.field_23017, class_4944.method_25860((class_2248)wool)).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)wool)), this.modelOutput);
        }
        class_4945 liquidSlot = AccessorTextureSlot.make("liquid");
        class_4942 poolTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        class_4942 poolFullTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool_full")), Optional.of("_full"), new class_4945[]{class_4945.field_23010, liquidSlot});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaPool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.creativePool).forEach(b -> {
            class_2960 tex = b == ModBlocks.manaPool || b == ModBlocks.fabulousPool ? class_4944.method_25860((class_2248)ModBlocks.livingrock) : class_4944.method_25860((class_2248)b);
            poolFullTemplate.method_25846(b, class_4944.method_25875((class_2960)tex).method_25868(liquidSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
            this.singleVariantBlockState((class_2248)b, poolTemplate.method_25846(b, class_4944.method_25875((class_2960)tex), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.pump, ModBlocks.tinyPotato).forEach(b -> this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)b))).method_25775(AccessorBlockModelGenerators.horizontalDispatch())));
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.enderEye, ModBlocks.manaDetector).forEach(b -> {
            class_2960 offModel = class_4943.field_22972.method_25846(b, class_4944.method_25864((class_2248)b), this.modelOutput);
            class_2960 onModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)b, (String)"_powered"), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12484).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)offModel)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)onModel))));
        });
        class_2960 petalBlockModel = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new class_4945[]{class_4945.field_23010}).method_25852(ResourceLocationHelper.prefix("block/petal_block"), new class_4944().method_25868(class_4945.field_23010, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockPetalBlock).forEach(b -> this.singleVariantBlockState((class_2248)b, petalBlockModel));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltGrass).forEach(b -> {
            class_2960 model = class_4943.field_22977.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25771((class_2248)b, (class_4935[])AccessorBlockModelGenerators.createRotatedVariants(model)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockRedString).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModDoubleFlower).forEach(b -> {
            class_2960 bottom = class_4943.field_22921.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput);
            class_2960 top = class_4943.field_22921.method_25852(class_4941.method_25843((class_2248)b, (String)"_top"), class_4944.method_25880((class_2960)class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2521.field_10929).method_25793((Comparable)class_2756.field_12607, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottom)).method_25793((Comparable)class_2756.field_12609, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)top))));
        });
        class_2960[] mountainTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeStoneMountain), class_4944.method_25866((class_2248)ModFluffBlocks.biomeStoneMountain, (String)"_1")};
        class_2960[] mountainModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeStoneMountain), class_4941.method_25843((class_2248)ModFluffBlocks.biomeStoneMountain, (String)"_1")};
        Integer[] mountainWeights = new Integer[]{5, 1};
        this.rotatedMirroredWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneMountain, mountainTextures, mountainWeights);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneMountainStairs, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneMountainSlab, mountainModels, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneMountainWall, mountainTextures, mountainWeights);
        class_2960[] mountainBrickTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickMountain), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_1"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_2"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_3"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_4"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_5")};
        class_2960[] mountainBrickModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeBrickMountain), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_1"), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_2"), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_3"), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_4"), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickMountain, (String)"_5")};
        this.cubeAllWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickMountain, mountainBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickMountainStairs, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickMountainSlab, mountainBrickModels, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickMountainWall, mountainBrickTextures);
        class_2960[] taigaTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeStoneTaiga), class_4944.method_25866((class_2248)ModFluffBlocks.biomeStoneTaiga, (String)"_1")};
        class_2960[] taigaModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeStoneTaiga), class_4941.method_25843((class_2248)ModFluffBlocks.biomeStoneTaiga, (String)"_1")};
        this.rotatedMirroredWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneTaiga, taigaTextures);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneTaigaStairs, taigaTextures, taigaTextures, taigaTextures);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneTaigaSlab, taigaModels, taigaTextures, taigaTextures, taigaTextures);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeStoneTaigaWall, taigaTextures);
        class_2960 plainsBrickSide = class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickPlains);
        class_2960 plainsBrickTop = class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickPlains, (String)"_top");
        this.pillarAlt(remainingBlocks, ModFluffBlocks.biomeBrickPlains, plainsBrickTop, plainsBrickSide);
        this.stairsBlock(remainingBlocks, ModFluffBlocks.biomeBrickPlainsStairs, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.slabBlock(remainingBlocks, ModFluffBlocks.biomeBrickPlainsSlab, class_4941.method_25842((class_2248)ModFluffBlocks.biomeBrickPlains), plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.wallBlock(remainingBlocks, ModFluffBlocks.biomeBrickPlainsWall, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        class_2960[] forestBrickTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickForest), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickForest, (String)"_1")};
        class_2960[] forestBrickModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeBrickForest), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickForest, (String)"_1")};
        Integer[] forestBrickWeights = new Integer[]{2, 1};
        this.cubeAllWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickForest, forestBrickTextures, forestBrickWeights);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickForestStairs, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickForestSlab, forestBrickModels, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickForestWall, forestBrickTextures, forestBrickWeights);
        class_2960[] fungalBrickTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickFungal), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickFungal, (String)"_1")};
        class_2960[] fungalBrickModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeBrickFungal), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickFungal, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickFungal, fungalBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickFungalStairs, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickFungalSlab, fungalBrickModels, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickFungalWall, fungalBrickTextures);
        class_2960[] swampBrickTopTextures = new class_2960[]{class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickSwamp, (String)"_top"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickSwamp, (String)"_top_1")};
        class_2960[] swampBrickBottomTextures = new class_2960[]{class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickSwamp, (String)"_bottom"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickSwamp, (String)"_bottom")};
        class_2960[] swampBrickSideTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickSwamp), class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickSwamp)};
        class_2960[] swampBrickModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeBrickSwamp), class_4941.method_25843((class_2248)ModFluffBlocks.biomeBrickSwamp, (String)"_1")};
        this.directionalPillarWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickSwamp, swampBrickTopTextures, swampBrickBottomTextures, swampBrickSideTextures);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickSwampStairs, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickSwampSlab, swampBrickModels, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeBrickSwampWall, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        class_2960[] swampChiseledBrickTopTextures = new class_2960[]{class_4944.method_25866((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp, (String)"_top"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp, (String)"_top_1")};
        class_2960[] swampChiseledBrickBottomTextures = new class_2960[]{class_4944.method_25866((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp, (String)"_bottom"), class_4944.method_25866((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp, (String)"_bottom")};
        class_2960[] swampChiseledBrickSideTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp), class_4944.method_25860((class_2248)ModFluffBlocks.biomeChiseledBrickSwamp)};
        this.directionalPillarWithVariants(remainingBlocks, ModFluffBlocks.biomeChiseledBrickSwamp, swampChiseledBrickTopTextures, swampChiseledBrickBottomTextures, swampChiseledBrickSideTextures);
        class_2960[] swampCobblestoneTextures = new class_2960[]{class_4944.method_25860((class_2248)ModFluffBlocks.biomeCobblestoneSwamp), class_4944.method_25866((class_2248)ModFluffBlocks.biomeCobblestoneSwamp, (String)"_1")};
        class_2960[] swampCobblestoneModels = new class_2960[]{class_4941.method_25842((class_2248)ModFluffBlocks.biomeCobblestoneSwamp), class_4941.method_25843((class_2248)ModFluffBlocks.biomeCobblestoneSwamp, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, ModFluffBlocks.biomeCobblestoneSwamp, swampCobblestoneTextures);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeCobblestoneSwampStairs, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeCobblestoneSwampSlab, swampCobblestoneModels, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.biomeCobblestoneSwampWall, swampCobblestoneTextures);
        class_2960 mesaBrick = class_4944.method_25860((class_2248)ModFluffBlocks.biomeBrickMesa);
        class_2960 mesaBrickMirrored = class_4944.method_25866((class_2248)ModFluffBlocks.biomeBrickMesa, (String)"_mirrored");
        class_2960 mesaBrickModel = this.checkeredBlockWithBlockstate(remainingBlocks, ModFluffBlocks.biomeBrickMesa, mesaBrick, mesaBrickMirrored);
        this.checkeredSlabBlock(remainingBlocks, ModFluffBlocks.biomeBrickMesaSlab, mesaBrickModel, mesaBrick, mesaBrickMirrored);
        this.checkeredStairsBlock(remainingBlocks, ModFluffBlocks.biomeBrickMesaStairs, mesaBrick, mesaBrickMirrored);
        this.checkeredWallBlock(remainingBlocks, ModFluffBlocks.biomeBrickMesaWall, mesaBrick, mesaBrickMirrored);
        class_2960 mesaChiseledBrickSide = class_4944.method_25860((class_2248)ModFluffBlocks.biomeChiseledBrickMesa);
        class_2960 mesaChiseledBrickTop = class_4944.method_25866((class_2248)ModFluffBlocks.biomeChiseledBrickMesa, (String)"_top");
        this.pillarAlt(remainingBlocks, ModFluffBlocks.biomeChiseledBrickMesa, mesaChiseledBrickTop, mesaChiseledBrickSide);
        for (class_2248 class_22482 : new class_2248[]{ModFluffBlocks.biomeStoneDesert, ModFluffBlocks.biomeStoneForest, ModFluffBlocks.biomeStoneFungal, ModFluffBlocks.biomeStoneMesa, ModFluffBlocks.biomeStonePlains, ModFluffBlocks.biomeStoneSwamp}) {
            this.rotatedMirrored(remainingBlocks, class_22482, class_4944.method_25860((class_2248)class_22482));
        }
        for (String string : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            class_2960 quartzId = ResourceLocationHelper.prefix(string + "_quartz");
            class_2248 quartz = (class_2248)class_2378.field_11146.method_17966(quartzId).get();
            this.singleVariantBlockState(quartz, class_4943.field_22977.method_25846(quartz, class_4944.method_25898((class_2248)quartz), this.modelOutput));
            class_2960 pillarId = ResourceLocationHelper.prefix(string + "_quartz_pillar");
            class_2248 pillar = (class_2248)class_2378.field_11146.method_17966(pillarId).get();
            class_2960 pillarModel = class_4943.field_22974.method_25846(pillar, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)pillar, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(AccessorBlockModelGenerators.createAxisAlignedPillarBlock(pillar, pillarModel));
            class_2960 chiseledId = ResourceLocationHelper.prefix("chiseled_" + string + "_quartz");
            class_2248 chiseled = (class_2248)class_2378.field_11146.method_17966(chiseledId).get();
            this.singleVariantBlockState(chiseled, class_4943.field_22974.method_25846(chiseled, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)chiseled, (String)"_side")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockBuriedPetals).forEach(b -> {
            class_1767 color = ((BlockBuriedPetals)b).color;
            class_2960 wool = new class_2960("block/" + color.method_15434() + "_wool");
            this.particleOnly(remainingBlocks, (class_2248)b, wool);
        });
        class_4942 class_49422 = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_23015, class_4945.field_23014});
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltar).forEach(b -> this.singleVariantBlockState((class_2248)b, apothecaryTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)b, (String)"_bottom")), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockFloatingFlower).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4941.method_25842((class_2248)b)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModPane).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23032, class_4944.method_25860((class_2248)b)).method_25868(class_4945.field_23031, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            class_2960 postModel = class_4943.field_22953.method_25846(b, mapping, this.modelOutput);
            class_2960 sideModel = class_4943.field_22954.method_25846(b, mapping, this.modelOutput);
            class_2960 sideAltModel = class_4943.field_22955.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideModel = class_4943.field_22951.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideAltModel = class_4943.field_22952.method_25846(b, mapping, this.modelOutput);
            this.blockstates.add((class_4917)class_4922.method_25758((class_2248)b).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2510).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_2960 side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                class_2960 bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                class_2960 top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)b, side, bottom, top);
            } else {
                class_2960 tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)b, tex, tex, tex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2482).forEach(slabBlock -> {
            String name = class_2378.field_11146.method_10221(slabBlock).method_12832();
            String baseName = name.substring(0, name.length() - "_slab".length());
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(ResourceLocationHelper.prefix(baseName)).get();
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_2960 side = class_4944.method_25866((class_2248)base, (String)"_side");
                class_2960 bottom = class_4944.method_25866((class_2248)base, (String)"_bottom");
                class_2960 top = class_4944.method_25866((class_2248)base, (String)"_top");
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.slabBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)slabBlock, doubleModel, side, bottom, top);
            } else {
                class_2960 baseTex = class_4944.method_25860((class_2248)base);
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.slabBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2544).forEach(wallBlock -> {
            String name = class_2378.field_11146.method_10221(wallBlock).method_12832();
            String baseName = name.substring(0, name.length() - "_wall".length());
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(ResourceLocationHelper.prefix(baseName)).get();
            class_2960 baseTexture = class_4944.method_25860((class_2248)base);
            this.wallBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)wallBlock, baseTexture);
        });
        remainingBlocks.forEach(this::cubeAllNoRemove);
    }

    protected void particleOnly(Set<class_2248> blocks, class_2248 b, class_2960 particle) {
        this.singleVariantBlockState(b, class_4943.field_22908.method_25846(b, class_4944.method_25891((class_2960)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<class_2248> blocks, class_2248 b) {
        this.singleVariantBlockState(b, class_4941.method_25842((class_2248)b));
        blocks.remove(b);
    }

    protected void stairsBlock(Set<class_2248> blocks, class_2248 block, class_2960 sideTex, class_2960 bottomTex, class_2960 topTex) {
        this.stairsBlockWithVariants(blocks, block, new class_2960[]{sideTex}, new class_2960[]{bottomTex}, new class_2960[]{topTex});
    }

    protected void checkeredStairsBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
        BiFunction<String, Optional, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new class_4945[]{class_4945.field_23018, class_4945.field_23019});
        class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);
        class_2960 checkeredStairsModel = checkeredTemplate.apply("stairs_checkered", Optional.empty()).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        class_2960 checkeredStairsModelRot90 = checkeredTemplate.apply("stairs_checkered_90deg", Optional.of("_90deg")).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        class_2960 checkeredStairsOuterModel = checkeredTemplate.apply("stairs_outer_checkered", Optional.of("_outer")).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        class_2960 checkeredStairsOuterModelRot90 = checkeredTemplate.apply("stairs_outer_checkered_90deg", Optional.of("_outer_90deg")).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        class_2960 checkeredStairsInnerModel = checkeredTemplate.apply("stairs_inner_checkered", Optional.of("_inner")).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        class_2960 checkeredStairsInnerModelRot90 = checkeredTemplate.apply("stairs_inner_checkered_90deg", Optional.of("_inner_90deg")).method_25846(ModFluffBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        this.stairsBlockWithModels(blocks, block, checkeredStairsInnerModel, checkeredStairsInnerModelRot90, checkeredStairsModel, checkeredStairsModelRot90, checkeredStairsOuterModel, checkeredStairsOuterModelRot90);
    }

    protected void stairsBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.stairsBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void stairsBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] innerModels = new class_2960[length];
        class_2960[] straightModels = new class_2960[length];
        class_2960[] outerModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]).method_25868(class_4945.field_23015, topTextures[i]);
            class_2960 modelIdInner = class_4941.method_25843((class_2248)block, (String)("_inner" + (String)suffix));
            class_2960 modelIdStraight = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdOuter = class_4941.method_25843((class_2248)block, (String)("_outer" + (String)suffix));
            innerModels[i] = class_4943.field_22913.method_25852(modelIdInner, mapping, this.modelOutput);
            straightModels[i] = class_4943.field_22912.method_25852(modelIdStraight, mapping, this.modelOutput);
            outerModels[i] = class_4943.field_22914.method_25852(modelIdOuter, mapping, this.modelOutput);
        }
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights);
    }

    protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] straightModels, class_2960[] outerModels, Integer[] weights) {
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights, true);
    }

    protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 innerModel, class_2960 innerModelRot90, class_2960 straightModel, class_2960 straightModelRot90, class_2960 outerModel, class_2960 outerModelRot90) {
        this.stairsBlockWithModels(blocks, block, new class_2960[]{innerModel}, new class_2960[]{innerModelRot90}, new class_2960[]{straightModel}, new class_2960[]{straightModelRot90}, new class_2960[]{outerModel}, new class_2960[]{outerModelRot90}, new Integer[]{1}, true);
    }

    protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] straightModels, class_2960[] outerModels, Integer[] weights, Boolean uvlock) {
        this.stairsBlockWithModels(blocks, block, innerModels, innerModels, straightModels, straightModels, outerModels, outerModels, weights, uvlock);
    }

    protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] innerModelsRot90, class_2960[] straightModels, class_2960[] straightModelsRot90, class_2960[] outerModels, class_2960[] outerModelsRot90, Integer[] weights, Boolean uvlock) {
        int length = innerModels.length;
        if (length != straightModels.length || length != outerModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_4926.class_4929 propertyDispatch = class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12518, (class_2769)class_2741.field_12503);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            for (class_2760 half : class_2760.values()) {
                for (class_2778 stairsShape : class_2778.values()) {
                    boolean isRight;
                    boolean isLeft = stairsShape == class_2778.field_12712 || stairsShape == class_2778.field_12708;
                    boolean bl = isRight = stairsShape == class_2778.field_12713 || stairsShape == class_2778.field_12709;
                    int rotationOffset = isLeft && half == class_2760.field_12617 ? -1 : (isRight && half == class_2760.field_12619 ? 1 : 0);
                    class_4936.class_4937[] rotations = class_4936.class_4937.values();
                    class_4936.class_4937 yRot = switch (direction) {
                        case class_2350.field_11034 -> rotations[(4 + rotationOffset) % 4];
                        case class_2350.field_11039 -> rotations[(2 + rotationOffset) % 4];
                        case class_2350.field_11035 -> rotations[(1 + rotationOffset) % 4];
                        case class_2350.field_11043 -> rotations[(3 + rotationOffset) % 4];
                        default -> throw new IllegalStateException();
                    };
                    class_4936.class_4937 xRot = switch (half) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2760.field_12617 -> class_4936.class_4937.field_22890;
                        case class_2760.field_12619 -> class_4936.class_4937.field_22892;
                    };
                    boolean rotatedModel = yRot == class_4936.class_4937.field_22891 || yRot == class_4936.class_4937.field_22893;
                    class_2960[] models = switch (stairsShape) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2778.field_12710 -> {
                            if (rotatedModel) {
                                yield straightModelsRot90;
                            }
                            yield straightModels;
                        }
                        case class_2778.field_12709, class_2778.field_12708 -> {
                            if (rotatedModel) {
                                yield outerModelsRot90;
                            }
                            yield outerModels;
                        }
                        case class_2778.field_12713, class_2778.field_12712 -> rotatedModel ? innerModelsRot90 : innerModels;
                    };
                    Stream<Integer> indices = IntStream.range(0, length).boxed();
                    propertyDispatch.method_25807((Comparable)direction, (Comparable)half, (Comparable)stairsShape, indices.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, this.maybeXRot(xRot, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models[i])))))).toList());
                }
            }
        }
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)propertyDispatch));
        blocks.remove(block);
    }

    protected void slabBlock(Set<class_2248> blocks, class_2248 block, class_2960 doubleModel, class_2960 side, class_2960 bottom, class_2960 top) {
        this.slabBlockWithVariants(blocks, block, new class_2960[]{doubleModel}, new class_2960[]{side}, new class_2960[]{bottom}, new class_2960[]{top});
    }

    protected void checkeredSlabBlock(Set<class_2248> blocks, class_2248 block, class_2960 doubleModel, class_2960 texture, class_2960 mirroredTexture) {
        BiFunction<String, Optional, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new class_4945[]{class_4945.field_23018, class_4945.field_23019});
        class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);
        class_2960 slabModel = checkeredTemplate.apply("slab_checkered", Optional.empty()).method_25846(ModFluffBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        class_2960 slabTopModel = checkeredTemplate.apply("slab_top_checkered", Optional.of("_top")).method_25846(ModFluffBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        this.slabBlockWithModels(blocks, block, slabModel, slabTopModel, doubleModel);
    }

    protected void slabBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] doubleModels, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.slabBlockWithVariants(blocks, block, doubleModels, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void slabBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] doubleModels, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] bottomModels = new class_2960[length];
        class_2960[] topModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]).method_25868(class_4945.field_23015, topTextures[i]);
            class_2960 modelIdBottom = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)("_top" + (String)suffix));
            bottomModels[i] = class_4943.field_22909.method_25852(modelIdBottom, mapping, this.modelOutput);
            topModels[i] = class_4943.field_22910.method_25852(modelIdTop, mapping, this.modelOutput);
        }
        this.slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels, weights);
    }

    protected void slabBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 bottomModel, class_2960 topModel, class_2960 doubleModel) {
        this.slabBlockWithModels(blocks, block, new class_2960[]{bottomModel}, new class_2960[]{topModel}, new class_2960[]{doubleModel}, new Integer[]{1});
    }

    protected void slabBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] bottomModels, class_2960[] topModels, class_2960[] doubleModels, Integer[] weights) {
        int length = doubleModels.length;
        if (length != topModels.length || length != bottomModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesBottom = IntStream.range(0, length).boxed();
        Stream<Integer> indicesTop = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDouble = IntStream.range(0, length).boxed();
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12485).method_25794((Comparable)class_2771.field_12681, indicesBottom.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottomModels[i]))).toList()).method_25794((Comparable)class_2771.field_12679, indicesTop.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModels[i]))).toList()).method_25794((Comparable)class_2771.field_12682, indicesDouble.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)doubleModels[i]))).toList())));
        blocks.remove(block);
    }

    protected void wallBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture) {
        this.wallBlock(blocks, block, texture, texture, texture);
    }

    protected void wallBlock(Set<class_2248> blocks, class_2248 block, class_2960 sideTexture, class_2960 bottomTexture, class_2960 topTexture) {
        this.wallBlockWithVariants(blocks, block, new class_2960[]{sideTexture}, new class_2960[]{bottomTexture}, new class_2960[]{topTexture});
    }

    protected void checkeredWallBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
        BiFunction<String, Optional, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new class_4945[]{class_4945.field_23018, class_4945.field_23019});
        class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);
        class_2960 checkeredWallPostModel = checkeredTemplate.apply("wall_post_checkered", Optional.of("_post")).method_25846(ModFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        class_2960 checkeredWallSideModel = checkeredTemplate.apply("wall_side_checkered", Optional.of("_side")).method_25846(ModFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        class_2960 checkeredWallSideModelRot90 = checkeredTemplate.apply("wall_side_checkered_90deg", Optional.of("_side_90deg")).method_25846(ModFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        class_2960 checkeredWallSideTallModel = checkeredTemplate.apply("wall_side_tall_checkered", Optional.of("_side_tall")).method_25846(ModFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        class_2960 checkeredWallSideTallModelRot90 = checkeredTemplate.apply("wall_side_tall_checkered_90deg", Optional.of("_side_tall_90deg")).method_25846(ModFluffBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        this.wallBlockWithModels(blocks, block, checkeredWallPostModel, checkeredWallSideModel, checkeredWallSideModelRot90, checkeredWallSideTallModel, checkeredWallSideTallModelRot90);
    }

    protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures);
    }

    protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures, weights);
    }

    protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.wallBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != bottomTextures.length && length != topTextures.length && length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] postModels = new class_2960[length];
        class_2960[] lowModels = new class_2960[length];
        class_2960[] tallModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23027, sideTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]).method_25868(class_4945.field_23015, topTextures[i]);
            class_2960 modelIdPost = class_4941.method_25843((class_2248)block, (String)("_post" + (String)suffix));
            class_2960 modelIdLow = class_4941.method_25843((class_2248)block, (String)("_side" + (String)suffix));
            class_2960 modelIdTall = class_4941.method_25843((class_2248)block, (String)("_side_tall" + (String)suffix));
            class_4942 postTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_post")), Optional.of("_post"), new class_4945[]{class_4945.field_23027, class_4945.field_23014, class_4945.field_23015});
            class_4942 sideTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side")), Optional.of("_side"), new class_4945[]{class_4945.field_23027, class_4945.field_23014, class_4945.field_23015});
            class_4942 sideTallTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side_tall")), Optional.of("_side_tall"), new class_4945[]{class_4945.field_23027, class_4945.field_23014, class_4945.field_23015});
            postModels[i] = postTemplate.method_25852(modelIdPost, mapping, this.modelOutput);
            lowModels[i] = sideTemplate.method_25852(modelIdLow, mapping, this.modelOutput);
            tallModels[i] = sideTallTemplate.method_25852(modelIdTall, mapping, this.modelOutput);
        }
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights);
    }

    protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] tallModels, Integer[] weights) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights, true);
    }

    protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 postModel, class_2960 lowModel, class_2960 lowModelRot90, class_2960 tallModel, class_2960 tallodelRot90) {
        this.wallBlockWithModels(blocks, block, new class_2960[]{postModel}, new class_2960[]{lowModel}, new class_2960[]{lowModelRot90}, new class_2960[]{tallModel}, new class_2960[]{tallodelRot90}, new Integer[]{1}, true);
    }

    protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] tallModels, Integer[] weights, Boolean uvlock) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, lowModels, tallModels, tallModels, weights, uvlock);
    }

    protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] lowModelsRot90, class_2960[] tallModels, class_2960[] tallodelsRot90, Integer[] weights, Boolean uvlock) {
        int length = postModels.length;
        if (length != lowModels.length || length != tallModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_4922 multiPartGenerator = class_4922.method_25758((class_2248)block);
        Stream<Integer> indicesPost = IntStream.range(0, length).boxed();
        multiPartGenerator.method_25762((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), (class_4935[])indicesPost.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModels[i]))).toArray(class_4935[]::new));
        List<class_2754> wallSides = List.of(class_2741.field_22174, class_2741.field_22177, class_2741.field_22176, class_2741.field_22175);
        for (class_2754 wallSide : wallSides) {
            class_4936.class_4937 yRot = wallSide == class_2741.field_22174 ? class_4936.class_4937.field_22891 : (wallSide == class_2741.field_22177 ? class_4936.class_4937.field_22893 : (wallSide == class_2741.field_22176 ? class_4936.class_4937.field_22892 : class_4936.class_4937.field_22890));
            boolean rotatedModel = yRot == class_4936.class_4937.field_22891 || yRot == class_4936.class_4937.field_22893;
            Stream<Integer> indicesLow = IntStream.range(0, length).boxed();
            Stream<Integer> indicesTall = IntStream.range(0, length).boxed();
            multiPartGenerator.method_25762((class_4918)class_4918.method_25744().method_25751((class_2769)wallSide, (Comparable)class_4778.field_22179), (class_4935[])indicesLow.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(rotatedModel ? lowModelsRot90[i] : lowModels[i])))))).toArray(class_4935[]::new)).method_25762((class_4918)class_4918.method_25744().method_25751((class_2769)wallSide, (Comparable)class_4778.field_22180), (class_4935[])indicesTall.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(rotatedModel ? tallodelsRot90[i] : tallModels[i])))))).toArray(class_4935[]::new));
        }
        this.blockstates.add((class_4917)multiPartGenerator);
        blocks.remove(block);
    }

    protected void fenceBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 postModel = class_4943.field_22988.method_25846(block, mapping, this.modelOutput);
        class_2960 sideModel = class_4943.field_22989.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceState(block, postModel, sideModel));
    }

    protected void fenceGateBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 openModel = class_4943.field_22996.method_25846(block, mapping, this.modelOutput);
        class_2960 closedModel = class_4943.field_22995.method_25846(block, mapping, this.modelOutput);
        class_2960 openWallModel = class_4943.field_22905.method_25846(block, mapping, this.modelOutput);
        class_2960 closedWallModel = class_4943.field_22904.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel));
    }

    protected void cubeAllNoRemove(class_2248 block) {
        this.cubeAll(new HashSet<class_2248>(), block);
    }

    protected void cubeAll(Set<class_2248> blocks, class_2248 block) {
        class_2960 texture = class_4944.method_25860((class_2248)block);
        this.cubeAllWithVariants(blocks, block, new class_2960[]{texture});
    }

    protected class_2960 checkeredBlockWithBlockstate(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
        BiFunction<String, Optional, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new class_4945[]{class_4945.field_23018, class_4945.field_23019});
        class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);
        class_2960 blockModel = checkeredTemplate.apply("cube_checkered", Optional.empty()).method_25846(ModFluffBlocks.biomeBrickMesa, checkeredMapping, this.modelOutput);
        this.cubeAllWithModels(blocks, block, new class_2960[]{blockModel}, new Integer[]{1});
        return blockModel;
    }

    protected void cubeAllWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.cubeAllWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void cubeAllWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] models = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_2960 modelId = class_4941.method_25843((class_2248)block, (String)suffix);
            models[i] = class_4943.field_22972.method_25852(modelId, class_4944.method_25875((class_2960)textures[i]), this.modelOutput);
        }
        this.cubeAllWithModels(blocks, block, models, weights);
    }

    protected void cubeAllWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] models, Integer[] weights) {
        int length = models.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((class_4917)class_4925.method_25771((class_2248)block, (class_4935[])((class_4935[])indices.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models[i]))).toArray(class_4935[]::new))));
        blocks.remove(block);
    }

    protected void singleVariantBlockState(class_2248 b, class_2960 model) {
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)));
    }

    protected void rotatedMirrored(Set<class_2248> blocks, class_2248 block, class_2960 texture) {
        this.rotatedMirroredWithVariants(blocks, block, new class_2960[]{texture});
    }

    protected void rotatedMirroredWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.rotatedMirroredWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void rotatedMirroredWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] models = new class_2960[length];
        class_2960[] mirroredModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_2960 modelId = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 mirriredModelId = class_4941.method_25843((class_2248)block, (String)("_mirrored" + (String)suffix));
            models[i] = class_4943.field_22972.method_25852(modelId, class_4944.method_25875((class_2960)textures[i]), this.modelOutput);
            mirroredModels[i] = class_4943.field_22973.method_25852(mirriredModelId, class_4944.method_25875((class_2960)textures[i]), this.modelOutput);
        }
        this.rotatedMirroredWithModels(blocks, block, models, mirroredModels, weights);
    }

    protected void rotatedMirroredWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] models, class_2960[] mirroredModels, Integer[] weights) {
        int length = models.length;
        if (length != mirroredModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((class_4917)class_4925.method_25771((class_2248)block, (class_4935[])((class_4935[])indices.flatMap(i -> Stream.of(this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models[i])), this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)mirroredModels[i])), this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)models[i]).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)), this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)mirroredModels[i]).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)))).toArray(class_4935[]::new))));
        blocks.remove(block);
    }

    protected void pillar(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
        this.pillarWithVariants(blocks, block, new class_2960[]{top}, new class_2960[]{side});
    }

    protected void pillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.pillarWithVariants(blocks, block, topTextures, sideTextures, (Integer[])weights);
    }

    protected void pillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] topModels = new class_2960[length];
        class_2960[] horizontalModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdHorizontal = class_4941.method_25843((class_2248)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalModels[i] = class_4943.field_22975.method_25852(modelIdHorizontal, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
        }
        this.pillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void pillarWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] topModels, class_2960[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesX = IntStream.range(0, length).boxed();
        Stream<Integer> indicesY = IntStream.range(0, length).boxed();
        Stream<Integer> indicesZ = IntStream.range(0, length).boxed();
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12496).method_25794((Comparable)class_2350.class_2351.field_11052, indicesX.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModels[i]))).toList()).method_25794((Comparable)class_2350.class_2351.field_11051, indicesY.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891))).toList()).method_25794((Comparable)class_2350.class_2351.field_11048, indicesZ.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891))).toList())));
        blocks.remove(block);
    }

    protected void pillarAlt(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
        this.pillarAltWithVariants(blocks, block, new class_2960[]{top}, new class_2960[]{side});
    }

    protected void pillarAltWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] topModels = new class_2960[length];
        class_2960[] horizontalXModels = new class_2960[length];
        class_2960[] horizontalZModels = new class_2960[length];
        class_4942 horizontalXTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), new class_4945[]{class_4945.field_23013, class_4945.field_23018});
        class_4942 horizontalZTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), new class_4945[]{class_4945.field_23013, class_4945.field_23018});
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdHorizontalX = class_4941.method_25843((class_2248)block, (String)("_horizontal_x" + (String)suffix));
            class_2960 modelIdHorizontalZ = class_4941.method_25843((class_2248)block, (String)("_horizontal_z" + (String)suffix));
            topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalXModels[i] = horizontalXTemplate.method_25852(modelIdHorizontalX, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalZModels[i] = horizontalZTemplate.method_25852(modelIdHorizontalZ, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
        }
        this.pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
    }

    protected void pillarAltWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] yModels, class_2960[] xModels, class_2960[] zModels) {
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12496).method_25794((Comparable)class_2350.class_2351.field_11052, Stream.of(yModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2350.class_2351.field_11048, Stream.of(xModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2350.class_2351.field_11051, Stream.of(zModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())));
        blocks.remove(block);
    }

    protected void directionalPillar(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 bottom, class_2960 side) {
        this.directionalPillarWithVariants(blocks, block, new class_2960[]{top}, new class_2960[]{top}, new class_2960[]{side});
    }

    protected void directionalPillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] bottomTextures, class_2960[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.directionalPillarWithVariants(blocks, block, topTextures, bottomTextures, sideTextures, (Integer[])weights);
    }

    protected void directionalPillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] bottomTextures, class_2960[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != bottomTextures.length || length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] topModels = new class_2960[length];
        class_2960[] horizontalModels = new class_2960[length];
        class_4942 topTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional")), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23018});
        class_4942 horizontalTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional_horizontal")), Optional.of("_horizontal"), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23018});
        for (int i = 0; i < length; ++i) {
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTextures[i]).method_25868(class_4945.field_23015, topTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]);
            Object suffix = i == 0 ? "" : "_" + i;
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdHorizontal = class_4941.method_25843((class_2248)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = topTemplate.method_25852(modelIdTop, mapping, this.modelOutput);
            horizontalModels[i] = horizontalTemplate.method_25852(modelIdHorizontal, mapping, this.modelOutput);
        }
        this.directionalPillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void directionalPillarWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] topModels, class_2960[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesUp = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDown = IntStream.range(0, length).boxed();
        Stream<Integer> indicesNorth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesSouth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesEast = IntStream.range(0, length).boxed();
        Stream<Integer> indicesWest = IntStream.range(0, length).boxed();
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12525).method_25794((Comparable)class_2350.field_11036, indicesUp.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModels[i]))).toList()).method_25794((Comparable)class_2350.field_11033, indicesDown.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)topModels[i]).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892))).toList()).method_25794((Comparable)class_2350.field_11043, indicesNorth.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]))).toList()).method_25794((Comparable)class_2350.field_11035, indicesSouth.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892))).toList()).method_25794((Comparable)class_2350.field_11034, indicesEast.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891))).toList()).method_25794((Comparable)class_2350.field_11039, indicesWest.map(i -> this.maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, (Object)horizontalModels[i]).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893))).toList())));
        blocks.remove(block);
    }

    protected <T> class_4935 withMaybe(class_4938<T> property, T value, boolean shouldAdd, class_4935 variant) {
        if (shouldAdd) {
            variant.method_25828(property, value);
        }
        return variant;
    }

    protected class_4935 maybeUVLock(Boolean uvlock, class_4935 variant) {
        return this.withMaybe(class_4936.field_22888, uvlock, uvlock, variant);
    }

    protected class_4935 maybeWeight(int weight, class_4935 variant) {
        return this.withMaybe(class_4936.field_22889, weight, weight != 1, variant);
    }

    protected class_4935 maybeXRot(class_4936.class_4937 rotation, class_4935 variant) {
        return this.withMaybe(class_4936.field_22885, rotation, rotation != class_4936.class_4937.field_22890, variant);
    }

    protected class_4935 maybeYRot(class_4936.class_4937 rotation, class_4935 variant) {
        return this.withMaybe(class_4936.field_22886, rotation, rotation != class_4936.class_4937.field_22890, variant);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void redStringBlock(class_2248 b) {
        class_2960 selfName = class_4944.method_25860((class_2248)b);
        class_2960 front = ResourceLocationHelper.prefix("block/red_string_sender");
        class_2960 model = class_4943.field_22978.method_25846(b, new class_4944().method_25868(class_4945.field_23015, selfName).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23018, selfName), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25775(AccessorBlockModelGenerators.facingDispatch()));
    }
}

