/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_101;
import net.minecraft.class_104;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2521;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5651;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_65;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockLootProvider
implements class_2405 {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final class_5341.class_210 SILK_TOUCH = class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1))));
    private static final Function<class_2248, class_52.class_53> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final class_2403 generator;
    private final Map<class_2248, Function<class_2248, class_52.class_53>> functionTable = new HashMap<class_2248, Function<class_2248, class_52.class_53>>();

    public BlockLootProvider(class_2403 generator) {
        this.generator = generator;
        for (class_2248 b2 : class_2378.field_11146) {
            class_2960 id = class_2378.field_11146.method_10221((Object)b2);
            if (!"botania".equals(id.method_12836())) continue;
            if (b2 instanceof class_2482) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (b2 instanceof BlockModDoubleFlower) {
                this.functionTable.put(b2, BlockLootProvider::genDoubleFlower);
                continue;
            }
            if (b2 instanceof BlockAltGrass) {
                this.functionTable.put(b2, BlockLootProvider::genAltGrass);
                continue;
            }
            if (!id.method_12832().matches("metamorphic_\\w+_stone")) continue;
            this.functionTable.put(b2, BlockLootProvider::genMetamorphicStone);
        }
        this.functionTable.put(ModBlocks.bifrost, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.cocoon, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.fakeAir, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.manaFlame, BlockLootProvider::empty);
        this.functionTable.put(ModBlocks.cacophonium, b -> BlockLootProvider.genRegular(class_2246.field_10179));
        this.functionTable.put(ModBlocks.enchantedSoil, b -> BlockLootProvider.genRegular(class_2246.field_10566));
        this.functionTable.put(ModBlocks.enchanter, b -> BlockLootProvider.genRegular(class_2246.field_10441));
        this.functionTable.put(ModBlocks.cellBlock, BlockLootProvider::genCellBlock);
        this.functionTable.put(ModBlocks.root, BlockLootProvider::genRoot);
        this.functionTable.put(ModBlocks.solidVines, BlockLootProvider::genSolidVine);
        this.functionTable.put(ModBlocks.tinyPotato, BlockLootProvider::genTinyPotato);
        this.functionTable.put(ModSubtiles.gourmaryllis, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(ModSubtiles.gourmaryllisFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFoods", "lastFoodCount", "streakLength"));
        this.functionTable.put(ModSubtiles.hydroangeas, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(ModSubtiles.hydroangeasFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown", "passiveDecayTicks"));
        this.functionTable.put(ModSubtiles.munchdew, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.munchdewFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.rafflowsia, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(ModSubtiles.rafflowsiaFloating, b -> BlockLootProvider.genCopyNbt(b, "lastFlowers", "lastFlowerTimes"));
        this.functionTable.put(ModSubtiles.spectrolus, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(ModSubtiles.spectrolusFloating, b -> BlockLootProvider.genCopyNbt(b, "nextColor"));
        this.functionTable.put(ModSubtiles.thermalily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ModSubtiles.thermalilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
    }

    public void method_10319(class_7403 cache) throws IOException {
        HashMap<class_2960, class_52.class_53> tables = new HashMap<class_2960, class_52.class_53>();
        for (class_2248 b : class_2378.field_11146) {
            Function<class_2248, class_52.class_53> func;
            class_2960 id = class_2378.field_11146.method_10221((Object)b);
            if (!"botania".equals(id.method_12836()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        for (Map.Entry e : tables.entrySet()) {
            Path path = BlockLootProvider.getPath(this.generator.method_10313(), (class_2960)e.getKey());
            class_2405.method_10320((class_7403)cache, (JsonElement)class_60.method_372((class_52)((class_52.class_53)e.getValue()).method_334(class_173.field_1172).method_338()), (Path)path);
        }
    }

    public static Path getPath(Path root, class_2960 id) {
        return root.resolve("data/" + id.method_12836() + "/loot_tables/blocks/" + id.method_12832() + ".json");
    }

    protected static class_52.class_53 empty(class_2248 b) {
        return class_52.method_324();
    }

    @Nullable
    protected static class_52.class_53 skip(class_2248 b) {
        return null;
    }

    protected static class_52.class_53 genCopyNbt(class_2248 b, String ... tags) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_3837.class_3838 func = class_3837.method_16848((class_5651)class_5646.field_27914);
        for (String tag : tags) {
            func = func.method_16856(tag, "BlockEntityTag." + tag);
        }
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871()).method_353((class_117.class_118)func);
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genCellBlock(class_2248 b) {
        class_2073.class_2074 silkPred = class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1)));
        class_79.class_80 silk = class_77.method_411((class_1935)b).method_421(class_223.method_945((class_2073.class_2074)silkPred));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(silk));
    }

    protected static class_52.class_53 genTinyPotato(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b).method_438((class_117.class_118)class_101.method_473((class_101.class_102)class_101.class_102.field_1023));
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genMetamorphicStone(class_2248 b) {
        String cobbleName = class_2378.field_11146.method_10221((Object)b).method_12832().replaceAll("_stone", "_cobblestone");
        class_2248 cobble = (class_2248)class_2378.field_11146.method_17966(ResourceLocationHelper.prefix(cobbleName)).get();
        return BlockLootProvider.genSilkDrop((class_1935)b, (class_1935)cobble);
    }

    protected static class_52.class_53 genSilkDrop(class_1935 silkDrop, class_1935 normalDrop) {
        class_79.class_80 cobbleDrop = class_77.method_411((class_1935)normalDrop).method_421(class_201.method_871());
        class_79.class_80 stoneDrop = class_77.method_411((class_1935)silkDrop).method_421(SILK_TOUCH);
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)stoneDrop.method_417(cobbleDrop)));
    }

    protected static class_52.class_53 genSolidVine(class_2248 b) {
        class_85.class_86 entry = class_83.method_428((class_2960)new class_2960("blocks/vine"));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genRoot(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)ModItems.livingroot).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)2.0f, (float)4.0f))).method_438((class_117.class_118)class_104.method_478());
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genSlab(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)).method_524((class_5341.class_210)class_212.method_900((class_2248)b).method_22584(class_4559.class_4560.method_22523().method_22525((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)))).method_438((class_117.class_118)class_104.method_478());
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genDoubleFlower(class_2248 b) {
        class_85.class_86 entry = (class_85.class_86)((class_85.class_86)class_77.method_411((class_1935)b).method_421(class_201.method_871())).method_421((class_5341.class_210)class_212.method_900((class_2248)b).method_22584(class_4559.class_4560.method_22523().method_22525((class_2769)class_2521.field_10929, (Comparable)class_2756.field_12607)));
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 genAltGrass(class_2248 b) {
        class_79.class_80 silk = class_77.method_411((class_1935)b).method_421(SILK_TOUCH);
        class_79.class_80 dirt = class_77.method_411((class_1935)class_2246.field_10566).method_421(class_201.method_871());
        class_65.class_66 entry = class_65.method_386((class_79.class_80[])new class_79.class_80[]{silk, dirt});
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry);
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genRegular(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    @NotNull
    public String method_10321() {
        return "Botania block loot tables";
    }
}

