/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3793;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.mixin.AccessorSoundType;
import vazkii.botania.network.clientbound.PacketGogWorld;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public final class SkyblockWorldEvents {
    private static final class_6862<class_2248> PEBBLE_SOURCES = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("gardenofglass:pebble_sources"));
    private static final class_2960 PEBBLES_TABLE = new class_2960("gardenofglass", "pebbles");

    private SkyblockWorldEvents() {
    }

    public static void syncGogStatus(class_3222 e) {
        boolean isGog = SkyblockChunkGenerator.isWorldSkyblock(e.field_6002);
        if (isGog) {
            IXplatAbstractions.INSTANCE.sendToPlayer((class_1657)e, PacketGogWorld.INSTANCE);
        }
    }

    public static void onPlayerJoin(class_3222 player) {
        class_3218 world = player.method_14220();
        if (SkyblockChunkGenerator.isWorldSkyblock((class_1937)world)) {
            SkyblockSavedData data = SkyblockSavedData.get(world);
            if (!data.skyblocks.containsValue((Object)class_156.field_25140)) {
                IslandPos islandPos = data.getSpawn();
                world.method_8554(islandPos.getCenter(), 0.0f);
                SkyblockWorldEvents.spawnPlayer((class_1657)player, islandPos);
                BotaniaAPI.LOGGER.info("Created the spawn GoG island");
            }
        }
    }

    public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            class_2338 pos;
            class_3965 rtr;
            class_1799 equipped = player.method_5998(hand);
            if (equipped.method_7960() && player.method_5715()) {
                class_2680 state = world.method_8320(hit.method_17777());
                if (state.method_26164(PEBBLE_SOURCES)) {
                    class_2498 st = state.method_26231();
                    class_3414 sound = ((AccessorSoundType)st).botania_getBreakSound();
                    player.method_5783(sound, st.method_10597() * 0.4f, st.method_10599() + (float)(Math.random() * 0.2 - 0.1));
                    if (world.field_9236) {
                        player.method_6104(hand);
                    } else if (world instanceof class_3218) {
                        class_3218 level = (class_3218)world;
                        class_52 table = level.method_8503().method_3857().method_367(PEBBLES_TABLE);
                        class_47 context = new class_47.class_48(level).method_312(class_181.field_1224, (Object)state).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)hit.method_17777())).method_312(class_181.field_1229, (Object)equipped).method_312(class_181.field_1226, (Object)player).method_306(class_181.field_1228, (Object)level.method_8321(hit.method_17777())).method_309(class_173.field_1172);
                        table.method_320(context, s -> player.method_7328(s, false));
                    }
                    return class_1269.field_5812;
                }
            } else if (!equipped.method_7960() && equipped.method_31574(class_1802.field_8428) && (rtr = ToolCommons.raytraceFromEntity((class_1297)player, 4.5, true)).method_17783() == class_239.class_240.field_1332 && world.method_8320(pos = rtr.method_17777()).method_26207() == class_3614.field_15920) {
                if (!world.field_9236) {
                    equipped.method_7934(1);
                    if (equipped.method_7960()) {
                        player.method_6122(hand, new class_1799((class_1935)ModItems.waterBowl));
                    } else {
                        player.method_31548().method_7398(new class_1799((class_1935)ModItems.waterBowl));
                    }
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void spawnPlayer(class_1657 player, IslandPos islandPos) {
        class_2338 pos = islandPos.getCenter();
        if (player instanceof class_3222) {
            class_3222 pmp = (class_3222)player;
            SkyblockWorldEvents.createSkyblock(pmp.method_14220(), pos);
            pmp.method_5859((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.6, (double)pos.method_10260() + 0.5);
            pmp.method_26284(pmp.field_6002.method_27983(), pos, 0.0f, true, false);
            if (BotaniaConfig.common().gogSpawnWithLexicon()) {
                player.method_31548().method_7394(new class_1799((class_1935)ModItems.lexicon));
            }
        }
    }

    public static void createSkyblock(class_3218 level, class_2338 pos) {
        class_2338 offset;
        class_3485 manager = level.method_14183();
        class_3499 template = (class_3499)manager.method_15094(ResourceLocationHelper.prefix("gog_island")).orElseThrow();
        ObjectArrayList structureBlockInfos = template.method_15165(pos, new class_3492(), class_2246.field_10465, false);
        structureBlockInfos.removeIf(info -> info.field_15595 == null);
        Optional<class_3499.class_3501> infoOptional = structureBlockInfos.stream().filter(info -> "spawn_point".equals(info.field_15595.method_10558("metadata"))).findFirst();
        if (infoOptional.isPresent()) {
            offset = infoOptional.get().field_15597;
        } else {
            BotaniaAPI.LOGGER.error("Structure botania:gog_island has no spawn_point data marker block, trying to offset it somewhat in the center");
            class_2382 size = template.method_15160();
            offset = new class_2338(size.method_10263() / 2, size.method_10264(), size.method_10260() / 2);
        }
        class_2338 startPoint = pos.method_10059((class_2382)offset);
        template.method_15172((class_5425)level, startPoint, startPoint, new class_3492().method_16184((class_3491)class_3793.field_16718), level.field_9229, 3);
        for (class_3499.class_3501 info2 : structureBlockInfos) {
            class_2338 lightPos;
            if (!"light".equals(info2.field_15595.method_10558("metadata")) || !level.method_8501(lightPos = startPoint.method_10081((class_2382)info2.field_15597), ModBlocks.manaFlame.method_9564())) continue;
            int r = 70 + level.field_9229.method_43048(185);
            int g = 70 + level.field_9229.method_43048(185);
            int b = 70 + level.field_9229.method_43048(185);
            int color = r << 16 | g << 8 | b;
            ((TileManaFlame)level.method_8321(lightPos)).setColor(color);
        }
    }
}

