/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6746;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_6954;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorNoiseChunk;

public class SkyblockChunkGenerator
extends class_2794 {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> SkyblockChunkGenerator.method_41042((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6903.method_40419((class_5321)class_2378.field_35433).forGetter(gen -> gen.noises), (App)class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.field_12761), (App)class_5284.field_24781.fieldOf("settings").forGetter(gen -> gen.settings))).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    protected final class_2680 defaultBlock;
    private final class_2378<class_5216.class_5487> noises;
    protected final class_6880<class_5284> settings;
    private final class_6350.class_6565 globalFluidPicker;

    public static void submitRegistration(BiConsumer<Codec<? extends class_2794>, class_2960> consumer) {
        consumer.accept(CODEC, ResourceLocationHelper.prefix("skyblock"));
    }

    public static boolean isWorldSkyblock(class_1937 world) {
        return world.method_8398() instanceof class_3215 && ((class_3215)world.method_8398()).method_12129() instanceof SkyblockChunkGenerator;
    }

    private SkyblockChunkGenerator(class_2378<class_7059> structureSets, class_2378<class_5216.class_5487> noises, class_1966 biomeSource, class_6880<class_5284> settings) {
        super(structureSets, Optional.empty(), biomeSource);
        this.noises = noises;
        this.settings = settings;
        class_5284 genSettings = (class_5284)this.settings.comp_349();
        this.defaultBlock = genSettings.comp_475();
        class_6350.class_6351 lava = new class_6350.class_6351(-54, class_2246.field_10164.method_9564());
        int i = genSettings.comp_479();
        class_6350.class_6351 defaultFluid = new class_6350.class_6351(i, genSettings.comp_476());
        this.globalFluidPicker = (x, y, z) -> y < Math.min(-54, i) ? lava : defaultFluid;
    }

    public CompletableFuture<class_2791> method_38275(class_2378<class_1959> biomes, Executor executor, class_7138 randomState, class_6748 blender, class_5138 structureManager, class_2791 chunkAccess) {
        return CompletableFuture.supplyAsync(class_156.method_37910((String)"init_biomes", () -> {
            this.doCreateBiomes(blender, randomState, structureManager, chunkAccess);
            return chunkAccess;
        }), class_156.method_18349());
    }

    private void doCreateBiomes(class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_6568 chunk = chunkAccess.method_38255(access -> this.createNoiseChunk((class_2791)access, structureManager, blender, randomState));
        class_6780 biomeResolver = class_6746.method_39767((class_6780)blender.method_39563((class_6780)this.field_12761), (class_2791)chunkAccess);
        chunkAccess.method_38257(biomeResolver, ((AccessorNoiseChunk)chunk).botania_cachedClimateSampler(randomState.method_42370(), ((class_5284)this.settings.comp_349()).comp_538()));
    }

    private class_6568 createNoiseChunk(class_2791 chunkAccess, class_5138 structureManager, class_6748 blender, class_7138 randomState) {
        return class_6568.method_39543((class_2791)chunkAccess, (class_7138)randomState, (class_6916.class_7050)class_5817.method_42695((class_5138)structureManager, (class_1923)chunkAccess.method_12004()), (class_5284)((class_5284)this.settings.comp_349()), (class_6350.class_6565)this.globalFluidPicker, (class_6748)blender);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmapTypes, class_5539 levelHeightAccessor, class_7138 randomState) {
        return levelHeightAccessor.method_31607();
    }

    public class_4966 method_26261(int x, int z, class_5539 levelHeightAccessor, class_7138 randomState) {
        return new class_4966(levelHeightAccessor.method_31607(), new class_2680[0]);
    }

    public void method_40450(List<String> strings, class_7138 randomState, class_2338 pos) {
        DecimalFormat format = new DecimalFormat("0.000");
        class_6953 router = randomState.method_42370();
        class_6910.class_6914 ctx = new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260());
        double $$6 = router.comp_485().method_40464((class_6910.class_6912)ctx);
        String var10001 = format.format(router.comp_420().method_40464((class_6910.class_6912)ctx));
        strings.add("NoiseRouter T: " + var10001 + " V: " + format.format(router.comp_539().method_40464((class_6910.class_6912)ctx)) + " C: " + format.format(router.comp_484().method_40464((class_6910.class_6912)ctx)) + " E: " + format.format(router.comp_423().method_40464((class_6910.class_6912)ctx)) + " D: " + format.format(router.comp_424().method_40464((class_6910.class_6912)ctx)) + " W: " + format.format($$6) + " PV: " + format.format(class_6954.method_41546((float)((float)$$6))) + " AS: " + format.format(router.comp_486().method_40464((class_6910.class_6912)ctx)) + " N: " + format.format(router.comp_487().method_40464((class_6910.class_6912)ctx)));
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 randomState, class_2791 chunk) {
    }

    public void method_12108(class_3233 worldGenRegion, long seed, class_7138 randomState, class_4543 biomeManager, class_5138 structureManager, class_2791 chunkAccess, class_2893.class_2894 carving) {
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_12104() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_174();
    }

    public int method_16398() {
        return ((class_5284)this.settings.comp_349()).comp_479();
    }

    public int method_33730() {
        return ((class_5284)this.settings.comp_349()).comp_474().comp_173();
    }

    public void method_12107(class_3233 region) {
    }
}

