/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketAvatarTornadoRod;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemTornadoRod
extends class_1792 {
    private static final class_2960 avatarOverlay = new class_2960("botania:textures/model/avatar_tornado.png");
    private static final int FLY_TIME = 20;
    private static final int FALL_MULTIPLIER = 3;
    private static final int MAX_COUNTER = 60;
    private static final int COST = 350;
    private static final String TAG_FLYING = "flying";
    private static final String TAG_FLYCOUNTER = "flyCounter";

    public ItemTornadoRod(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 ent, int slot, boolean active) {
        if (ent instanceof class_1657) {
            boolean held;
            class_1657 player = (class_1657)ent;
            boolean damaged = this.getFlyCounter(stack) > 0;
            boolean bl = held = player.method_6047() == stack || player.method_6079() == stack;
            if (damaged && !ItemTornadoRod.isFlying(stack)) {
                this.setFlyCounter(stack, this.getFlyCounter(stack) - 1);
            }
            if (this.getFlyCounter(stack) >= 60) {
                this.setFlying(stack, false);
            } else if (ItemTornadoRod.isFlying(stack)) {
                if (held) {
                    player.field_6017 = 0.0f;
                    double my = ManaItemHandler.instance().hasProficiency(player, stack) ? 1.6 : 1.25;
                    class_243 oldMot = player.method_18798();
                    if (player.method_6128()) {
                        class_243 lookDir = player.method_5720();
                        player.method_18799(new class_243(lookDir.method_10216() * my, lookDir.method_10214() * my, lookDir.method_10215() * my));
                    } else {
                        player.method_18799(new class_243(oldMot.method_10216(), my, oldMot.method_10215()));
                    }
                    player.method_5783(ModSounds.airRod, 1.0f, 1.0f);
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                        world.method_8406((class_2394)data, player.method_23317(), player.method_23318(), player.method_23321(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                    }
                }
                this.setFlyCounter(stack, this.getFlyCounter(stack) + 3);
                if (this.getFlyCounter(stack) == 60) {
                    this.setFlying(stack, false);
                }
            }
            if (damaged) {
                player.field_6017 = 0.0f;
            }
        }
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        return this.getFlyCounter(stack) > 0;
    }

    public int method_31569(@NotNull class_1799 stack) {
        float frac = 1.0f - (float)this.getFlyCounter(stack) / 60.0f;
        return Math.round(13.0f * frac);
    }

    public int method_31571(@NotNull class_1799 stack) {
        float frac = 1.0f - (float)this.getFlyCounter(stack) / 60.0f;
        return class_3532.method_15369((float)(frac / 3.0f), (float)1.0f, (float)1.0f);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        int fly = this.getFlyCounter(stack);
        if (fly == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, false)) {
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, true);
            this.setFlying(stack, true);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public static boolean isFlying(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
    }

    private void setFlying(class_1799 stack, boolean flying) {
        ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
    }

    private int getFlyCounter(class_1799 stack) {
        return stack.method_7948().method_10550(TAG_FLYCOUNTER);
    }

    private void setFlyCounter(class_1799 stack, int counter) {
        stack.method_7948().method_10569(TAG_FLYCOUNTER, counter);
    }

    public static void doAvatarElytraBoost(class_1657 p, class_1937 world) {
        class_243 lookDir = p.method_5720();
        double mult = 1.25 * Math.pow(Math.E, -0.5 * p.method_18798().method_1033());
        p.method_18800(p.method_18798().method_10216() + lookDir.method_10216() * mult, p.method_18798().method_10214() + lookDir.method_10214() * mult, p.method_18798().method_10215() + lookDir.method_10215() * mult);
        if (!world.field_9236) {
            IXplatAbstractions.INSTANCE.sendToPlayer(p, new PacketAvatarTornadoRod(true));
            IXplatAbstractions.INSTANCE.sendToTracking((class_1297)p, new PacketBotaniaEffect(EffectType.AVATAR_TORNADO_BOOST, p.method_23317(), p.method_23318(), p.method_23321(), p.method_5628()));
        }
    }

    public static void doAvatarJump(class_1657 p, class_1937 world) {
        p.method_18800(p.method_18798().method_10216(), 2.8, p.method_18798().method_10215());
        if (!world.field_9236) {
            IXplatAbstractions.INSTANCE.sendToPlayer(p, new PacketAvatarTornadoRod(false));
            IXplatAbstractions.INSTANCE.sendToTracking((class_1297)p, new PacketBotaniaEffect(EffectType.AVATAR_TORNADO_JUMP, p.method_23317(), p.method_23318(), p.method_23321(), p.method_5628()));
        }
    }

    private static void doAvatarMiscEffects(class_1657 p, IManaReceiver tile) {
        p.field_6002.method_43128(null, p.method_23317(), p.method_23318(), p.method_23321(), ModSounds.dash, class_3419.field_15248, 1.0f, 1.0f);
        p.method_6092(new class_1293(ModPotions.featherfeet, 100, 0));
        tile.receiveMana(-350);
    }

    private static void decAvatarCooldowns(Map<UUID, Integer> cooldownTag) {
        for (UUID key : cooldownTag.keySet()) {
            int val = cooldownTag.get(key);
            if (val > 0) {
                cooldownTag.put(key, val - 1);
                continue;
            }
            cooldownTag.remove(key);
        }
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(class_1799 before, class_1799 after) {
        return !before.method_31574((class_1792)this) || ItemTornadoRod.isFlying(before) != ItemTornadoRod.isFlying(after);
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            class_2586 te = (class_2586)tile;
            class_1937 world = te.method_10997();
            Map<UUID, Integer> cooldowns = tile.getBoostCooldowns();
            IManaReceiver receiver = IXplatAbstractions.INSTANCE.findManaReceiver(world, te.method_11016(), te.method_11010(), te, null);
            if (!world.field_9236) {
                ItemTornadoRod.decAvatarCooldowns(cooldowns);
            }
            if (!world.field_9236 && receiver.getCurrentMana() >= 350 && tile.isEnabled()) {
                int range = 5;
                int rangeY = 3;
                List players = world.method_18467(class_1657.class, new class_238(te.method_11016().method_10080(-0.5 - (double)range, -0.5 - (double)rangeY, -0.5 - (double)range), te.method_11016().method_10080(0.5 + (double)range, 0.5 + (double)rangeY, 0.5 + (double)range)));
                for (class_1657 p : players) {
                    int cooldown = 0;
                    if (cooldowns.containsKey(p.method_5667())) {
                        cooldown = cooldowns.get(p.method_5667());
                    }
                    if (p.method_5715() || cooldown > 0) continue;
                    if (p.method_18798().method_1033() > 0.2 && p.method_18798().method_1033() < 5.0 && p.method_6128()) {
                        ItemTornadoRod.doAvatarElytraBoost(p, world);
                        ItemTornadoRod.doAvatarMiscEffects(p, receiver);
                        cooldowns.put(p.method_5667(), 20);
                        te.method_5431();
                        continue;
                    }
                    if (!(p.method_18798().method_10214() > 0.3) || !(p.method_18798().method_10214() < 2.0) || p.method_6128()) continue;
                    ItemTornadoRod.doAvatarJump(p, world);
                    ItemTornadoRod.doAvatarMiscEffects(p, receiver);
                }
            }
        }

        @Override
        public class_2960 getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }
}

