/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.material.ItemSelfReturning;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemRainbowRod
extends ItemSelfReturning {
    private static final class_2960 avatarOverlay = new class_2960("botania:textures/model/avatar_rainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 4;
    private static final int TIME = 600;

    public ItemRainbowRod(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false)) {
            class_2680 bifrost = ModBlocks.bifrost.method_9564();
            class_243 vector = player.method_5720().method_1029();
            double x = player.method_23317();
            double y = player.method_23318() - 1.0;
            double z = player.method_23321();
            class_2338.class_2339 pos = new class_2338.class_2339((int)x, (int)y, (int)z);
            double lastX = 0.0;
            double lastY = -1.0;
            double lastZ = 0.0;
            class_2338.class_2339 previousPos = new class_2338.class_2339();
            boolean placedAny = false;
            boolean prof = ManaItemHandler.instance().hasProficiency(player, stack);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            class_2338.class_2339 placePos = new class_2338.class_2339();
            for (int count = 0; count < maxlen; ++count) {
                previousPos.method_10102(lastX, lastY, lastZ);
                if (!previousPos.equals((Object)pos)) {
                    if (!world.method_22347((class_2338)pos) && world.method_8320((class_2338)pos) != bifrost && count >= 4 || world.method_31601(pos.method_10264())) break;
                    if (ItemRainbowRod.placeBridgeSegment(world, (class_2338)pos, placePos, time)) {
                        placedAny = true;
                    }
                }
                lastX = x;
                lastY = y;
                lastZ = z;
                pos.method_10102(x += vector.field_1352, y += vector.field_1351, z += vector.field_1350);
            }
            if (placedAny) {
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.bifrostRod, class_3419.field_15248, 1.0f, 1.0f);
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 750, false);
                player.method_7357().method_7906((class_1792)this, player.method_7337() ? 10 : 600);
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    private static boolean placeBridgeSegment(class_1937 world, class_2338 center, class_2338.class_2339 placePos, int time) {
        class_2680 bifrost = ModBlocks.bifrost.method_9564();
        boolean placed = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                placePos.method_10103(center.method_10263() + i, center.method_10264(), center.method_10260() + j);
                if (!world.method_22347((class_2338)placePos) && world.method_8320((class_2338)placePos) != bifrost) continue;
                world.method_8652((class_2338)placePos, bifrost, 2);
                TileBifrost tile = (TileBifrost)world.method_8321((class_2338)placePos);
                if (tile == null) continue;
                tile.ticks = time;
                placed = true;
            }
        }
        return placed;
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            class_2586 te = (class_2586)tile;
            class_1937 world = te.method_10997();
            IManaReceiver receiver = IXplatAbstractions.INSTANCE.findManaReceiver(world, te.method_11016(), te.method_11010(), te, null);
            if (world.field_9236 || receiver.getCurrentMana() < 100 || !tile.isEnabled() || world.method_31601(te.method_11016().method_10264() - 1)) {
                return;
            }
            class_2338 tePos = te.method_11016();
            int w = 1;
            int h = 1;
            int l = 20;
            class_238 axis = null;
            switch ((class_2350)world.method_8320(tePos).method_11654((class_2769)class_2741.field_12481)) {
                case field_11043: {
                    axis = new class_238(tePos.method_10069(-w, -h, -l), tePos.method_10069(w + 1, h, 0));
                    break;
                }
                case field_11035: {
                    axis = new class_238(tePos.method_10069(-w, -h, 1), tePos.method_10069(w + 1, h, l + 1));
                    break;
                }
                case field_11039: {
                    axis = new class_238(tePos.method_10069(-l, -h, -w), tePos.method_10069(0, h, w + 1));
                    break;
                }
                case field_11034: {
                    axis = new class_238(tePos.method_10069(1, -h, -w), tePos.method_10069(l + 1, h, w + 1));
                    break;
                }
            }
            List players = world.method_18467(class_1657.class, axis);
            for (class_1657 p : players) {
                int px = class_3532.method_15357((double)p.method_23317());
                int py = class_3532.method_15357((double)p.method_23318()) - 1;
                int pz = class_3532.method_15357((double)p.method_23321());
                int dist = 5;
                int diff = dist / 2;
                for (int i = 0; i < dist; ++i) {
                    for (int j = 0; j < dist; ++j) {
                        TileBifrost tileBifrost;
                        int ex = px + i - diff;
                        int ez = pz + j - diff;
                        if (!axis.method_1006(new class_243((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                        class_2338 pos = new class_2338(ex, py, ez);
                        class_2680 state = world.method_8320(pos);
                        if (state.method_26215()) {
                            if (!world.method_8501(pos, ModBlocks.bifrost.method_9564())) continue;
                            tileBifrost = (TileBifrost)world.method_8321(pos);
                            tileBifrost.ticks = 10;
                            receiver.receiveMana(-4);
                            continue;
                        }
                        if (!state.method_27852(ModBlocks.bifrost)) continue;
                        tileBifrost = (TileBifrost)world.method_8321(pos);
                        if (tileBifrost.ticks >= 2) continue;
                        tileBifrost.ticks += 10;
                        receiver.receiveMana(-4);
                    }
                }
            }
        }

        @Override
        public class_2960 getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }
}

