/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemKingKey
extends ItemRelic {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    public static final int WEAPON_TYPES = 12;

    public ItemKingKey(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        ItemKingKey.setCharging(stack, true);
        return class_5328.method_29282((class_1937)world, (class_1657)player, (class_1268)hand);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int time) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (spawned == 20) {
            ItemKingKey.setCharging(stack, false);
            ItemKingKey.setWeaponsSpawned(stack, 0);
        }
    }

    public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
        block5: {
            int spawned;
            block6: {
                spawned = ItemKingKey.getWeaponsSpawned(stack);
                if (count == this.method_7881(stack) || spawned >= 20 || world.field_9236) break block5;
                if (!(living instanceof class_1657)) break block6;
                class_1657 player = (class_1657)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, 150, true)) break block5;
            }
            class_243 look = living.method_5720().method_18805(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.method_36454() + 90.0f);
            if (look.field_1352 == 0.0 && look.field_1350 == 0.0) {
                look = new class_243(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.method_1029().method_1021(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            class_243 pl = look.method_1019(VecHelper.fromEntityCenter((class_1297)living)).method_1031(0.0, 1.6, (double)div * 0.1);
            class_5819 rand = world.field_9229;
            class_243 axis = look.method_1029().method_1036(new class_243(-1.0, 0.0, -1.0)).method_1029();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            class_243 axis1 = VecHelper.rotate(axis.method_1021((double)div * 3.5 + 5.0), rot, look);
            if (axis1.field_1351 < 0.0) {
                axis1 = axis1.method_18805(1.0, -1.0, 1.0);
            }
            class_243 end = pl.method_1019(axis1);
            EntityBabylonWeapon weapon = new EntityBabylonWeapon(living, world);
            weapon.method_5814(end.field_1352, end.field_1351, end.field_1350);
            weapon.method_36456(living.method_36454());
            weapon.setVariety(rand.method_43048(12));
            weapon.setDelay(spawned);
            weapon.setRotation(class_3532.method_15393((float)(-living.method_36454() + 180.0f)));
            world.method_8649((class_1297)weapon);
            weapon.method_5783(ModSounds.babylonSpawn, 1.0f, 1.0f + world.field_9229.method_43057() * 3.0f);
            ItemKingKey.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public static boolean isCharging(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
    }

    public static int getWeaponsSpawned(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
    }

    public static void setCharging(class_1799 stack, boolean charging) {
        ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
    }

    public static void setWeaponsSpawned(class_1799 stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
    }

    public static IRelic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/king_key"));
    }
}

