/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.equipment.bauble.ItemCloudPendant;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemTravelBelt
extends ItemBauble {
    private static final UUID STEP_BOOST_UUID = UUID.fromString("8511cd62-2650-4078-8d69-9ebe80b21eb5");
    private static final class_1322 STEP_BOOST = new class_1322(STEP_BOOST_UUID, "botania:travel_belt", 0.65, class_1322.class_1323.field_6328);
    private static final class_2960 texture = new class_2960("botania:textures/model/belt_travel.png");
    private static final int COST = 1;
    private static final int COST_INTERVAL = 10;
    public final float speed;
    public final float jump;
    public final float fallBuffer;

    public ItemTravelBelt(class_1792.class_1793 props) {
        this(props, 0.035f, 0.2f, 2.0f);
    }

    public static float onPlayerFall(class_1657 entity, float dist) {
        boolean pendantJump = ItemCloudPendant.popJumping(entity);
        class_1799 stack = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, (class_1309)entity);
        if (!stack.method_7960()) {
            class_1799 amulet;
            float fallBuffer = ((ItemTravelBelt)stack.method_7909()).fallBuffer;
            if (pendantJump && !(amulet = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemCloudPendant, (class_1309)entity)).method_7960()) {
                fallBuffer *= (float)((ItemCloudPendant)amulet.method_7909()).getMaxAllowedJumps();
            }
            return Math.max(0.0f, dist - fallBuffer);
        }
        return dist;
    }

    public ItemTravelBelt(class_1792.class_1793 props, float speed, float jump, float fallBuffer) {
        super(props);
        this.speed = speed;
        this.jump = jump;
        this.fallBuffer = fallBuffer;
        IProxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public static void tickBelt(class_1657 player) {
        class_1799 belt = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, (class_1309)player);
        class_1320 stepHeight = IXplatAbstractions.INSTANCE.getStepHeightAttribute();
        class_1324 attrib = player.method_5996(stepHeight);
        boolean hasBoost = attrib.method_6196(STEP_BOOST);
        if (ItemTravelBelt.tryConsumeMana(player)) {
            if (player.field_6002.field_9236) {
                ItemTravelBelt beltItem = (ItemTravelBelt)belt.method_7909();
                if ((player.method_24828() || player.method_31549().field_7479) && player.field_6250 > 0.0f && !player.method_5816()) {
                    float speed = beltItem.getSpeed(belt);
                    player.method_5724(player.method_31549().field_7479 ? speed : speed, new class_243(0.0, 0.0, 1.0));
                    beltItem.onMovedTick(belt, player);
                    if (player.field_6012 % 10 == 0) {
                        ManaItemHandler.instance().requestManaExact(belt, player, 1, true);
                    }
                } else {
                    beltItem.onNotMovingTick(belt, player);
                }
            } else if (player.method_5715()) {
                if (hasBoost) {
                    attrib.method_6202(STEP_BOOST);
                }
            } else if (!hasBoost) {
                attrib.method_26835(STEP_BOOST);
            }
        } else if (!player.field_6002.field_9236 && hasBoost) {
            attrib.method_6202(STEP_BOOST);
        }
    }

    public float getSpeed(class_1799 stack) {
        return this.speed;
    }

    public void onMovedTick(class_1799 stack, class_1657 player) {
    }

    public void onNotMovingTick(class_1799 stack, class_1657 player) {
    }

    public static void onPlayerJump(class_1309 living) {
        class_1657 player;
        class_1799 belt;
        if (living instanceof class_1657 && !(belt = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, (class_1309)(player = (class_1657)living))).method_7960() && ManaItemHandler.instance().requestManaExact(belt, player, 1, false)) {
            player.method_18799(player.method_18798().method_1031(0.0, (double)((ItemTravelBelt)belt.method_7909()).jump, 0.0));
        }
    }

    private static boolean tryConsumeMana(class_1657 player) {
        class_1799 result = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, (class_1309)player);
        return !result.method_7960() && ManaItemHandler.instance().requestManaExact(result, player, 1, false);
    }

    class_2960 getRenderTexture() {
        return texture;
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static class_572<class_1309> model = null;

        @Override
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryRenderHelper.rotateIfSneaking(ms, living);
            float s = 1.15f;
            ms.method_22905(s, s, s);
            if (model == null) {
                model = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27577));
            }
            class_2960 texture = ((ItemTravelBelt)stack.method_7909()).getRenderTexture();
            class_4588 buffer = buffers.getBuffer(model.method_23500(texture));
            Renderer.model.field_3391.method_22699(ms, buffer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

