/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.Optional;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemManaRing
extends ItemBauble {
    protected static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";

    public ItemManaRing(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7850(@NotNull class_1761 tab, @NotNull class_2371<class_1799> stacks) {
        if (this.method_7877(tab)) {
            stacks.add((Object)new class_1799((class_1935)this));
            class_1799 full = new class_1799((class_1935)this);
            ItemManaRing.setMana(full, 500000);
            stacks.add((Object)full);
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(class_1799 stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int method_31571(class_1799 stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return class_3532.method_15369((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItem
    implements IManaItem {
        protected final class_1799 stack;

        public ManaItem(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemNBTHelper.getInt(this.stack, ItemManaRing.TAG_MANA, 0) * this.stack.method_7947();
        }

        @Override
        public int getMaxMana() {
            return 500000 * this.stack.method_7947();
        }

        @Override
        public void addMana(int mana) {
            ItemManaRing.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.method_7947());
        }

        @Override
        public boolean canReceiveManaFromPool(class_2586 pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(class_1799 otherStack) {
            return true;
        }

        @Override
        public boolean canExportManaToPool(class_2586 pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(class_1799 otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

