/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.mixin.AccessorItemEntity;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemMagnetRing
extends ItemBauble {
    private static final String TAG_COOLDOWN = "cooldown";
    private final int range;

    public ItemMagnetRing(class_1792.class_1793 props) {
        this(props, 6);
    }

    public ItemMagnetRing(class_1792.class_1793 props, int range) {
        super(props);
        this.range = range;
    }

    public static void onTossItem(class_1657 player) {
        class_1799 ring = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemMagnetRing, (class_1309)player);
        if (!ring.method_7960()) {
            ItemMagnetRing.setCooldown(ring, 100);
        }
    }

    @Override
    public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
        if (IXplatAbstractions.INSTANCE.isModLoaded("malum")) {
            HashMultimap attributes = HashMultimap.create();
            attributes.put((Object)((class_1320)class_2378.field_23781.method_10223(new class_2960("malum", "spirit_reach"))), (Object)new class_1322(ItemMagnetRing.getBaubleUUID(stack), "Magnet Ring reach boost", 0.5, class_1322.class_1323.field_6330));
            return attributes;
        }
        return super.getEquippedAttributeModifiers(stack);
    }

    @Override
    public void onWornTick(class_1799 stack, class_1309 living) {
        super.onWornTick(stack, living);
        if (living.method_7325()) {
            return;
        }
        int cooldown = ItemMagnetRing.getCooldown(stack);
        if (BotaniaAPI.instance().hasSolegnoliaAround((class_1297)living)) {
            if (cooldown < 0) {
                ItemMagnetRing.setCooldown(stack, 2);
            }
            return;
        }
        if (cooldown <= 0) {
            if (living.method_5715() == BotaniaConfig.common().invertMagnetRing()) {
                double x = living.method_23317();
                double y = living.method_23318() + 0.75;
                double z = living.method_23321();
                int range = ((ItemMagnetRing)stack.method_7909()).range;
                List items = living.field_6002.method_18467(class_1542.class, new class_238(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                int pulled = 0;
                for (class_1542 item : items) {
                    if (!((ItemMagnetRing)stack.method_7909()).canPullItem(item)) continue;
                    if (pulled <= 200) {
                        MathHelper.setEntityMotionFromVector((class_1297)item, new class_243(x, y, z), 0.45f);
                        if (living.field_6002.field_9236) {
                            boolean red = living.field_6002.field_9229.method_43056();
                            float r = red ? 1.0f : 0.0f;
                            float b = red ? 0.0f : 1.0f;
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, 0.0f, b, 3);
                            living.field_6002.method_8406((class_2394)data, item.method_23317(), item.method_23318(), item.method_23321(), 0.0, 0.0, 0.0);
                        }
                        ++pulled;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ItemMagnetRing.setCooldown(stack, cooldown - 1);
        }
    }

    private boolean canPullItem(class_1542 item) {
        int pickupDelay = ((AccessorItemEntity)item).getPickupDelay();
        if (!item.method_5805() || pickupDelay >= 40 || BotaniaAPI.instance().hasSolegnoliaAround((class_1297)item) || IXplatAbstractions.INSTANCE.preventsRemoteMovement(item)) {
            return false;
        }
        class_1799 stack = item.method_6983();
        if (stack.method_7960() || IXplatAbstractions.INSTANCE.findManaItem(stack) != null || IXplatAbstractions.INSTANCE.findRelic(stack) != null || stack.method_31573(ModTags.Items.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        class_2338 pos = item.method_24515();
        if (item.field_6002.method_8320(pos).method_26164(ModTags.Blocks.MAGNET_RING_BLACKLIST)) {
            return false;
        }
        return !item.field_6002.method_8320(pos.method_10074()).method_26164(ModTags.Blocks.MAGNET_RING_BLACKLIST);
    }

    public static int getCooldown(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(class_1799 stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }
}

