/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaInterceptor;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.block.tile.corporea.TileCorporeaRetainer;
import vazkii.botania.common.impl.corporea.CorporeaItemStackMatcher;
import vazkii.botania.common.impl.corporea.CorporeaRequest;
import vazkii.botania.common.impl.corporea.CorporeaResult;
import vazkii.botania.common.impl.corporea.CorporeaStringMatcher;
import vazkii.botania.xplat.IXplatAbstractions;

public class CorporeaHelperImpl
implements CorporeaHelper {
    private final WeakHashMap<List<ICorporeaSpark>, List<ICorporeaNode>> cachedNetworks = new WeakHashMap();

    @Override
    public List<ICorporeaNode> getNodesOnNetwork(ICorporeaSpark spark) {
        List<ICorporeaNode> cache;
        ICorporeaSpark master = spark.getMaster();
        if (master == null) {
            return Collections.emptyList();
        }
        List<ICorporeaSpark> network = master.getConnections();
        if (this.cachedNetworks.containsKey(network) && (cache = this.cachedNetworks.get(network)) != null) {
            return cache;
        }
        ArrayList<ICorporeaNode> nodes = new ArrayList<ICorporeaNode>();
        if (network != null) {
            for (ICorporeaSpark otherSpark : network) {
                if (otherSpark == null) continue;
                nodes.add(otherSpark.getSparkNode());
            }
        }
        this.cachedNetworks.put(network, nodes);
        return nodes;
    }

    @Override
    public int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return this.getCountInNetwork(matcher, this.getNodesOnNetwork(spark));
    }

    @Override
    public int getCountInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> inventories) {
        Map<ICorporeaNode, Integer> map = this.getInventoriesWithMatchInNetwork(matcher, inventories);
        int count = 0;
        for (int value : map.values()) {
            count += value;
        }
        return count;
    }

    @Override
    public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        List<ICorporeaNode> inventories = this.getNodesOnNetwork(spark);
        return this.getInventoriesWithMatchInNetwork(matcher, inventories);
    }

    @Override
    public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> nodes) {
        HashMap<ICorporeaNode, Integer> countMap = new HashMap<ICorporeaNode, Integer>();
        for (ICorporeaNode node : nodes) {
            CorporeaRequest request = new CorporeaRequest(matcher, -1);
            node.countItems(request);
            if (request.getFound() <= 0) continue;
            countMap.put(node, request.getFound());
        }
        return countMap;
    }

    @Override
    public ICorporeaRequestMatcher createMatcher(class_1799 stack, boolean checkNBT) {
        return new CorporeaItemStackMatcher(stack, checkNBT);
    }

    @Override
    public ICorporeaRequestMatcher createMatcher(String name) {
        return new CorporeaStringMatcher(name);
    }

    @Override
    public ICorporeaResult requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (IXplatAbstractions.INSTANCE.fireCorporeaRequestEvent(matcher, itemCount, spark, !doit)) {
            return new CorporeaResult(stacks, 0, 0);
        }
        List<ICorporeaNode> nodes = this.getNodesOnNetwork(spark);
        HashMap<ICorporeaInterceptor, ICorporeaSpark> interceptors = new HashMap<ICorporeaInterceptor, ICorporeaSpark>();
        CorporeaRequest request = new CorporeaRequest(matcher, itemCount);
        for (ICorporeaNode node : nodes) {
            ICorporeaSpark invSpark = node.getSpark();
            class_2586 te = node.getWorld().method_8321(node.getPos());
            if (te instanceof ICorporeaInterceptor) {
                ICorporeaInterceptor interceptor = (ICorporeaInterceptor)te;
                interceptor.interceptRequest(matcher, itemCount, invSpark, spark, stacks, nodes, doit);
                interceptors.put(interceptor, invSpark);
            }
            if (doit) {
                stacks.addAll(node.extractItems(request));
                continue;
            }
            stacks.addAll(node.countItems(request));
        }
        for (ICorporeaInterceptor interceptor : interceptors.keySet()) {
            interceptor.interceptRequestLast(matcher, itemCount, (ICorporeaSpark)interceptors.get(interceptor), spark, stacks, nodes, doit);
        }
        return new CorporeaResult(stacks, request.getFound(), request.getExtracted());
    }

    @Override
    public ICorporeaSpark getSparkForBlock(class_1937 world, class_2338 pos) {
        List sparks = world.method_8390(class_1297.class, new class_238(pos.method_10084(), pos.method_10069(1, 2, 1)), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
        return sparks.isEmpty() ? null : (ICorporeaSpark)sparks.get(0);
    }

    @Override
    public int signalStrengthForRequestSize(int requestSize) {
        if (requestSize <= 0) {
            return 0;
        }
        if (requestSize >= 16384) {
            return 15;
        }
        return Math.min(15, class_3532.method_15351((int)requestSize) + 1);
    }

    @Override
    public <T extends ICorporeaRequestMatcher> void registerRequestMatcher(class_2960 id, Class<T> clazz, Function<class_2487, T> deserializer) {
        TileCorporeaRetainer.addCorporeaRequestMatcher(id, clazz, deserializer);
    }

    public void clearCache() {
        this.cachedNetworks.clear();
    }
}

