/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public final class PlayerHelper {
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*]|ComputerCraft)$");

    public static boolean isTruePlayer(@Nullable class_1297 e) {
        if (!(e instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)e;
        String name = player.method_5477().getString();
        return !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static List<class_1657> getRealPlayersIn(class_1937 level, class_238 aabb) {
        return level.method_8390(class_1657.class, aabb, player -> PlayerHelper.isTruePlayer((class_1297)player) && !player.method_7325());
    }

    public static boolean hasAnyHeldItem(class_1657 player) {
        return !player.method_6047().method_7960() || !player.method_6079().method_7960();
    }

    public static boolean hasHeldItem(class_1657 player, class_1792 item) {
        return !player.method_6047().method_7960() && player.method_6047().method_31574(item) || !player.method_6079().method_7960() && player.method_6079().method_31574(item);
    }

    public static boolean hasHeldItemClass(class_1657 player, Class<?> template) {
        return !player.method_6047().method_7960() && template.isAssignableFrom(player.method_6047().method_7909().getClass()) || !player.method_6079().method_7960() && template.isAssignableFrom(player.method_6079().method_7909().getClass());
    }

    public static class_1799 getFirstHeldItem(class_1309 living, class_1792 item) {
        return PlayerHelper.getFirstHeldItem(living, (class_1799 s) -> s.method_31574(item));
    }

    public static class_1799 getFirstHeldItem(class_1309 living, Predicate<class_1799> pred) {
        class_1799 main = living.method_6047();
        class_1799 offhand = living.method_6079();
        if (!main.method_7960() && pred.test(main)) {
            return main;
        }
        if (!offhand.method_7960() && pred.test(offhand)) {
            return offhand;
        }
        return class_1799.field_8037;
    }

    public static class_1799 getFirstHeldItemClass(class_1309 living, Class<?> template) {
        return PlayerHelper.getFirstHeldItem(living, (class_1799 s) -> template.isAssignableFrom(s.method_7909().getClass()));
    }

    public static class_1799 getAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
        if (ammoFunc.test(player.method_5998(class_1268.field_5810))) {
            return player.method_5998(class_1268.field_5810);
        }
        if (ammoFunc.test(player.method_5998(class_1268.field_5808))) {
            return player.method_5998(class_1268.field_5808);
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 itemstack = player.method_31548().method_5438(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return class_1799.field_8037;
    }

    public static boolean hasAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
        return !PlayerHelper.getAmmo(player, ammoFunc).method_7960();
    }

    public static void consumeAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
        class_1799 ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (!ammo.method_7960()) {
            ammo.method_7934(1);
        }
    }

    public static class_1799 getItemFromInventory(class_1657 player, Predicate<class_1799> itemPred) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 item = player.method_31548().method_5438(i);
            if (!itemPred.test(item)) continue;
            return item;
        }
        return class_1799.field_8037;
    }

    public static class_1799 getItemClassFromInventory(class_1657 player, Class<?> template) {
        return PlayerHelper.getItemFromInventory(player, s -> template.isAssignableFrom(s.method_7909().getClass()));
    }

    public static boolean hasAdvancement(class_3222 player, class_2960 advancementId) {
        class_2985 advancements = player.method_14236();
        class_2989 manager = player.method_14220().method_8503().method_3851();
        class_161 advancement = manager.method_12896(advancementId);
        return advancement != null && advancements.method_12882(advancement).method_740();
    }

    public static void grantCriterion(class_3222 player, class_2960 advancementId, String criterion) {
        class_2985 advancements = player.method_14236();
        class_2989 manager = player.method_14220().method_8503().method_3851();
        class_161 advancement = manager.method_12896(advancementId);
        if (advancement != null && !advancements.method_12882(advancement).method_740()) {
            advancements.method_12878(advancement, criterion);
        }
    }

    public static class_1269 substituteUse(class_1838 ctx, class_1799 toUse) {
        return (class_1269)PlayerHelper.substituteUseTrackPos(ctx, toUse).getFirst();
    }

    public static Pair<class_1269, class_2338> substituteUseTrackPos(class_1838 ctx, class_1799 toUse) {
        ItemUseContextWithNullPlayer newCtx;
        class_1799 save = class_1799.field_8037;
        class_3965 hit = new class_3965(ctx.method_17698(), ctx.method_8038(), ctx.method_8037(), ctx.method_17699());
        if (ctx.method_8036() != null) {
            save = ctx.method_8036().method_5998(ctx.method_20287());
            ctx.method_8036().method_6122(ctx.method_20287(), toUse);
            newCtx = new class_1838(ctx.method_8036(), ctx.method_20287(), hit);
        } else {
            newCtx = new ItemUseContextWithNullPlayer(ctx.method_8045(), ctx.method_20287(), toUse, hit);
        }
        class_2338 finalPos = new class_1750((class_1838)newCtx).method_8037();
        class_1269 result = toUse.method_7981((class_1838)newCtx);
        if (ctx.method_8036() != null) {
            ctx.method_8036().method_6122(ctx.method_20287(), save);
        }
        return Pair.of((Object)result, (Object)finalPos);
    }

    private PlayerHelper() {
    }

    private static class ItemUseContextWithNullPlayer
    extends class_1838 {
        public ItemUseContextWithNullPlayer(class_1937 world, class_1268 hand, class_1799 stack, class_3965 rayTraceResult) {
            super(world, null, hand, stack, rayTraceResult);
        }
    }
}

