/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final Map<class_1937, Set<IManaPool>> manaPools = new WeakHashMap<class_1937, Set<IManaPool>>();
    private final Map<class_1937, Set<IManaCollector>> manaCollectors = new WeakHashMap<class_1937, Set<IManaCollector>>();

    public void onNetworkEvent(IManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        switch (type) {
            case COLLECTOR: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaCollectors, thing.getManaReceiverLevel(), (IManaCollector)thing);
                    break;
                }
                this.remove(this.manaCollectors, thing.getManaReceiverLevel(), (IManaCollector)thing);
                break;
            }
            case POOL: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaPools, thing.getManaReceiverLevel(), (IManaPool)thing);
                    break;
                }
                this.remove(this.manaPools, thing.getManaReceiverLevel(), (IManaPool)thing);
            }
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public IManaPool getClosestPool(class_2338 pos, class_1937 world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public IManaCollector getClosestCollector(class_2338 pos, class_1937 world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(class_1937 level, IManaCollector collector) {
        return this.manaCollectors.getOrDefault(level, Collections.emptySet()).contains(collector);
    }

    public boolean isPoolIn(class_1937 level, IManaPool pool) {
        return this.manaPools.getOrDefault(level, Collections.emptySet()).contains(pool);
    }

    @Nullable
    private <T extends IManaReceiver> T getClosest(Set<T> receivers, class_2338 pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        IManaReceiver closest = null;
        for (IManaReceiver receiver : receivers) {
            long distance = MathHelper.distSqr((class_2382)receiver.getManaReceiverPos(), (class_2382)pos);
            if (distance > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = receiver;
        }
        return (T)closest;
    }

    private <T> void remove(Map<class_1937, Set<T>> map, class_1937 level, T thing) {
        if (!map.containsKey(level)) {
            return;
        }
        Set<T> set = map.get(level);
        set.remove(thing);
        if (set.isEmpty()) {
            map.remove(level);
        }
    }

    private <T> void add(Map<class_1937, Set<T>> map, class_1937 level, T thing) {
        map.computeIfAbsent(level, k -> new HashSet()).add(thing);
    }

    @Override
    public Set<IManaCollector> getAllCollectorsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<IManaPool> getAllPoolsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    @Override
    public void fireManaNetworkEvent(IManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        IXplatAbstractions.INSTANCE.fireManaNetworkEvent(thing, type, action);
    }

    private <T> Set<T> getAllInWorld(Map<class_1937, Set<T>> map, class_1937 world) {
        Set<T> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

