/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ModItems;

public class EntityThornChakram
extends class_1682
implements class_3856 {
    private static final class_2940<Integer> BOUNCES = class_2945.method_12791(EntityThornChakram.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FLARE = class_2945.method_12791(EntityThornChakram.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> RETURN_TO = class_2945.method_12791(EntityThornChakram.class, (class_2941)class_2943.field_13327);
    private static final int MAX_BOUNCES = 16;
    private boolean bounced = false;
    private class_1799 stack = class_1799.field_8037;

    public EntityThornChakram(class_1299<EntityThornChakram> type, class_1937 world) {
        super(type, world);
    }

    public EntityThornChakram(class_1309 e, class_1937 world, class_1799 stack) {
        super(ModEntities.THORN_CHAKRAM, e, world);
        this.stack = stack.method_7972();
    }

    protected void method_5693() {
        this.field_6011.method_12784(BOUNCES, (Object)0);
        this.field_6011.method_12784(FLARE, (Object)false);
        this.field_6011.method_12784(RETURN_TO, (Object)-1);
    }

    public boolean method_5659() {
        return true;
    }

    public void method_5773() {
        class_1297 thrower;
        class_243 old = this.method_18798();
        super.method_5773();
        if (!this.bounced) {
            this.method_18799(old);
        }
        this.bounced = false;
        if (this.isReturning() && (thrower = this.method_24921()) != null) {
            class_243 motion = VecHelper.fromEntityCenter(thrower).method_1020(VecHelper.fromEntityCenter((class_1297)this)).method_1029();
            this.method_18799(motion);
        }
        if (this.field_6002.field_9236 && this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11240, this.method_23317() + r * (Math.random() - 0.5), this.method_23318() + r * (Math.random() - 0.5), this.method_23321() + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
            }
        }
        if (!(this.field_6002.field_9236 || this.getTimesBounced() < 16 && this.field_6012 <= 60)) {
            thrower = this.method_24921();
            if (thrower == null) {
                this.dropAndKill();
            } else {
                this.setEntityToReturnTo(thrower.method_5628());
                if (this.method_5858(thrower) < 2.0) {
                    this.dropAndKill();
                }
            }
        }
    }

    private void dropAndKill() {
        class_1799 stack = this.getItemStack();
        class_1542 item = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.field_6002.method_8649((class_1297)item);
        this.method_31472();
    }

    private class_1799 getItemStack() {
        return !this.stack.method_7960() ? this.stack.method_7972() : (this.isFire() ? new class_1799((class_1935)ModItems.flareChakram) : new class_1799((class_1935)ModItems.thornChakram));
    }

    protected void method_7488(@NotNull class_239 pos) {
        if (!this.isReturning()) {
            super.method_7488(pos);
        }
    }

    protected void method_24920(@NotNull class_3965 hit) {
        super.method_24920(hit);
        class_2680 state = this.field_6002.method_8320(hit.method_17777());
        if (state.method_26204() instanceof class_2261 || state.method_26164(class_3481.field_15503)) {
            return;
        }
        int bounces = this.getTimesBounced();
        if (bounces < 16) {
            class_243 currentMovementVec = this.method_18798();
            class_2350 dir = hit.method_17780();
            class_243 normalVector = new class_243((double)dir.method_10148(), (double)dir.method_10164(), (double)dir.method_10165()).method_1029();
            class_243 movementVec = normalVector.method_1021(-2.0 * currentMovementVec.method_1026(normalVector)).method_1019(currentMovementVec);
            this.method_18799(movementVec);
            this.bounced = true;
            if (!this.field_6002.field_9236) {
                this.setTimesBounced(this.getTimesBounced() + 1);
            }
        }
    }

    protected void method_7454(@NotNull class_3966 hit) {
        class_1297 class_12972;
        super.method_7454(hit);
        if (!this.field_6002.field_9236 && (class_12972 = hit.method_17782()) instanceof class_1309) {
            class_1309 hitEntity = (class_1309)class_12972;
            if (hit.method_17782() != this.method_24921()) {
                class_1297 thrower = this.method_24921();
                class_1282 src = class_1282.field_5869;
                if (thrower instanceof class_1657) {
                    src = class_1282.method_5524((class_1297)this, (class_1297)thrower);
                } else if (thrower instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)thrower;
                    src = class_1282.method_5511((class_1309)livingEntity);
                }
                hitEntity.method_5643(src, 12.0f);
                if (this.isFire()) {
                    hitEntity.method_5639(5);
                } else if (this.field_6002.field_9229.method_43048(3) == 0) {
                    hitEntity.method_6092(new class_1293(class_1294.field_5899, 60, 0));
                }
            }
        }
    }

    protected float method_7490() {
        return 0.0f;
    }

    private int getTimesBounced() {
        return (Integer)this.field_6011.method_12789(BOUNCES);
    }

    private void setTimesBounced(int times) {
        this.field_6011.method_12778(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.field_6011.method_12789(FLARE);
    }

    public void setFire(boolean fire) {
        this.field_6011.method_12778(FLARE, (Object)fire);
    }

    private boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.field_6011.method_12789(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.field_6011.method_12778(RETURN_TO, (Object)entityID);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (!this.stack.method_7960()) {
            compound.method_10566("fly_stack", (class_2520)this.stack.method_7953(new class_2487()));
        }
        compound.method_10556("flare", this.isFire());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("fly_stack")) {
            this.stack = class_1799.method_7915((class_2487)compound.method_10562("fly_stack"));
        }
        this.setFire(compound.method_10577("flare"));
    }

    @NotNull
    public class_1799 method_7495() {
        return this.getItemStack();
    }
}

