/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.ItemSparkUpgrade;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.PacketBotaniaEffect;
import vazkii.botania.xplat.IXplatAbstractions;

public class EntityManaSpark
extends EntitySparkBase
implements IManaSpark {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final class_2940<Integer> UPGRADE = class_2945.method_12791(EntityManaSpark.class, (class_2941)class_2943.field_13327);
    private final Set<IManaSpark> transfers = Collections.newSetFromMap(new WeakHashMap());
    private int removeTransferants = 2;

    public EntityManaSpark(class_1299<EntityManaSpark> type, class_1937 world) {
        super(type, world);
    }

    public EntityManaSpark(class_1937 world) {
        this(ModEntities.SPARK, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(UPGRADE, (Object)0);
    }

    @NotNull
    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.spark);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            return;
        }
        ISparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            this.dropAndKill();
            return;
        }
        IManaReceiver receiver = this.getAttachedManaReceiver();
        SparkUpgradeType upgrade = this.getUpgrade();
        Collection<IManaSpark> transfers = this.getTransfers();
        switch (upgrade) {
            case DISPERSIVE: {
                class_1657 player2;
                List<class_1657> players = SparkHelper.getEntitiesAround(class_1657.class, this.field_6002, this.method_23317(), this.method_23318() + (double)this.method_17682() / 2.0, this.method_23321());
                HashMap receivingPlayers = new HashMap();
                class_1799 input = new class_1799((class_1935)ModItems.spark);
                for (class_1657 player2 : players) {
                    ArrayList<class_1799> stacks = new ArrayList<class_1799>();
                    stacks.addAll((Collection<class_1799>)player2.method_31548().field_7547);
                    stacks.addAll((Collection<class_1799>)player2.method_31548().field_7548);
                    class_1263 inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                    for (int i = 0; i < inv.method_5439(); ++i) {
                        stacks.add(inv.method_5438(i));
                    }
                    for (class_1799 stack : stacks) {
                        int recv;
                        HashMap<IManaItem, Integer> receivingStacks;
                        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
                        if (stack.method_7960() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                        boolean add = false;
                        if (!receivingPlayers.containsKey(player2)) {
                            add = true;
                            receivingStacks = new HashMap<IManaItem, Integer>();
                        } else {
                            receivingStacks = (HashMap<IManaItem, Integer>)receivingPlayers.get(player2);
                        }
                        if ((recv = Math.min(receiver.getCurrentMana(), Math.min(1000, manaItem.getMaxMana() - manaItem.getMana()))) <= 0) continue;
                        receivingStacks.put(manaItem, recv);
                        if (!add) continue;
                        receivingPlayers.put(player2, receivingStacks);
                    }
                }
                if (receivingPlayers.isEmpty()) break;
                ArrayList keys = new ArrayList(receivingPlayers.keySet());
                Collections.shuffle(keys);
                player2 = (class_1657)keys.iterator().next();
                Map items = (Map)receivingPlayers.get(player2);
                Map.Entry e = items.entrySet().iterator().next();
                IManaItem manaItem = (IManaItem)e.getKey();
                int cost = (Integer)e.getValue();
                int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                manaItem.addMana(manaToPut);
                receiver.receiveMana(-manaToPut);
                this.particlesTowards((class_1297)player2);
                break;
            }
            case DOMINANT: {
                List validSparks = SparkHelper.getSparksAround(this.field_6002, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade == SparkUpgradeType.NONE && s.getAttachedManaReceiver() instanceof IManaPool;
                }).collect(Collectors.toList());
                if (validSparks.size() <= 0) break;
                ((IManaSpark)validSparks.get(this.field_6002.field_9229.method_43048(validSparks.size()))).registerTransfer(this);
                break;
            }
            case RECESSIVE: {
                SparkHelper.getSparksAround(this.field_6002, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork()).filter(s -> {
                    SparkUpgradeType otherUpgrade = s.getUpgrade();
                    return s != this && otherUpgrade != SparkUpgradeType.DOMINANT && otherUpgrade != SparkUpgradeType.RECESSIVE && otherUpgrade != SparkUpgradeType.ISOLATED;
                }).forEach(transfers::add);
                break;
            }
        }
        if (!transfers.isEmpty()) {
            int manaTotal = Math.min(1000 * transfers.size(), receiver.getCurrentMana());
            int count = transfers.size();
            int manaSpent = 0;
            if (manaTotal > 0) {
                for (IManaSpark spark : transfers) {
                    --count;
                    ISparkAttachable attached = spark.getAttachedTile();
                    IManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                    if (attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone()) continue;
                    int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                    attachedReceiver.receiveMana(spend);
                    manaSpent += spend;
                    this.particlesTowards(spark.entity());
                }
                receiver.receiveMana(-manaSpent);
            }
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
        this.filterTransfers();
    }

    private void particlesTowards(class_1297 e) {
        IXplatAbstractions.INSTANCE.sendToTracking(this, new PacketBotaniaEffect(EffectType.SPARK_MANA_FLOW, this.method_23317(), this.method_23318(), this.method_23321(), this.method_5628(), e.method_5628(), ColorHelper.getColorValue(this.getNetwork())));
    }

    public static void particleBeam(class_1657 player, class_1297 e1, class_1297 e2) {
        if (e1 != null && e2 != null && !e1.field_6002.field_9236) {
            IXplatAbstractions.INSTANCE.sendToPlayer(player, new PacketBotaniaEffect(EffectType.SPARK_NET_INDICATOR, e1.method_23317(), e1.method_23318(), e1.method_23321(), e1.method_5628(), e2.method_5628()));
        }
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.method_5699(new class_1799((class_1935)ModItems.spark), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.method_5699(ItemSparkUpgrade.getByType(upgrade), 0.0f);
        }
        this.method_31472();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_5805() && !stack.method_7960()) {
            class_1769 dye;
            class_1767 color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.method_7909() instanceof ItemTwigWand) {
                if (!this.field_6002.field_9236) {
                    if (player.method_5715()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.method_5699(ItemSparkUpgrade.getByType(upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.transfers.clear();
                            this.removeTransferants = 2;
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround(this.field_6002, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), this.getNetwork()).forEach(s -> EntityManaSpark.particleBeam(player, this, s.entity()));
                    }
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof ItemSparkUpgrade) {
                ItemSparkUpgrade newUpgrade = (ItemSparkUpgrade)class_17922;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.field_6002.field_9236) {
                        this.setUpgrade(newUpgrade.type);
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)this.field_6002.field_9236);
                }
            }
            if (stack.method_31574(ModItems.phantomInk)) {
                if (!this.field_6002.field_9236) {
                    this.method_5648(true);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769 && (color = (dye = (class_1769)class_17922).method_7802()) != this.getNetwork()) {
                if (!this.field_6002.field_9236) {
                    this.setNetwork(color);
                    stack.method_7934(1);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_5749(@NotNull class_2487 cmp) {
        super.method_5749(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.method_10550(TAG_UPGRADE)]);
    }

    @Override
    protected void method_5652(@NotNull class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10569(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    @Override
    public ISparkAttachable getAttachedTile() {
        return IXplatAbstractions.INSTANCE.findSparkAttachable(this.field_6002, this.getAttachPos(), this.field_6002.method_8320(this.getAttachPos()), this.field_6002.method_8321(this.getAttachPos()), class_2350.field_11036);
    }

    private void filterTransfers() {
        Iterator<IManaSpark> iter = this.transfers.iterator();
        while (iter.hasNext()) {
            IManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            IManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((class_1297)spark).method_5805() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof IManaPool))) continue;
            iter.remove();
        }
    }

    @Override
    public Collection<IManaSpark> getTransfers() {
        this.filterTransfers();
        return this.transfers;
    }

    private boolean hasTransfer(IManaSpark entity) {
        return this.transfers.contains(entity);
    }

    @Override
    public void registerTransfer(IManaSpark entity) {
        if (this.hasTransfer(entity)) {
            return;
        }
        this.transfers.add(entity);
    }

    @Override
    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.field_6011.method_12789(UPGRADE)];
    }

    @Override
    public void setUpgrade(SparkUpgradeType upgrade) {
        this.field_6011.method_12778(UPGRADE, (Object)upgrade.ordinal());
    }

    @Override
    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        ISparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }
}

