/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.entity.EntityManaSpark;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.entity.SparkArrayList;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class EntityCorporeaSpark
extends EntitySparkBase
implements ICorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_CREATIVE = "creative";
    private static final class_2940<Boolean> MASTER = class_2945.method_12791(EntityCorporeaSpark.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CREATIVE = class_2945.method_12791(EntityCorporeaSpark.class, (class_2941)class_2943.field_13323);
    private ICorporeaSpark master;
    private List<ICorporeaSpark> connections = new SparkArrayList<ICorporeaSpark>();
    private List<ICorporeaSpark> relatives = new ArrayList<ICorporeaSpark>();
    private boolean firstTick = true;

    public EntityCorporeaSpark(class_1299<EntityCorporeaSpark> type, class_1937 world) {
        super(type, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MASTER, (Object)false);
        this.field_6011.method_12784(CREATIVE, (Object)false);
    }

    @NotNull
    public class_1799 method_31480() {
        return new class_1799((class_1935)(this.isCreative() ? ModItems.corporeaSparkCreative : (this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark)));
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            return;
        }
        ICorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.field_6002.method_8320(this.getAttachPos()).method_26164(ModTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (!(this.master == null || this.master.entity().method_5805() && this.master.getNetwork() == this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.method_5699(new class_1799((class_1935)(this.isCreative() ? ModItems.corporeaSparkCreative : (this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark))), 0.0f);
        this.method_31472();
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
        this.relatives.clear();
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || connections.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || !spark.entity().method_5805()) continue;
            connections.add(spark);
            this.relatives.add(spark);
            spark.registerConnections(master, this, connections);
        }
        this.master = master;
        this.connections = connections;
    }

    private List<ICorporeaSpark> getNearbySparks() {
        return this.field_6002.method_8390(class_1297.class, new class_238(this.method_23317() - 8.0, this.method_23318() - 8.0, this.method_23321() - 8.0, this.method_23317() + 8.0, this.method_23318() + 8.0, this.method_23321() + 8.0), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new SparkArrayList<ICorporeaSpark>();
        this.relatives = new ArrayList<ICorporeaSpark>();
        if (this.master != null) {
            ICorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.registerConnections(oldMaster, this, new SparkArrayList<ICorporeaSpark>());
        }
    }

    private void findNetwork() {
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            ICorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || !spark.entity().method_5805() || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(class_1657 player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<ICorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            EntityManaSpark.particleBeam(player, spark.entity(), spark.getMaster().entity());
        } else {
            for (ICorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                EntityManaSpark.particleBeam(player, spark.entity(), endSpark.entity());
                checked.add(endSpark);
                EntityCorporeaSpark.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public ICorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.field_6002, this);
    }

    @Override
    public List<ICorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<ICorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(class_1799 stack) {
        ((class_3218)this.field_6002).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<class_1799> stacks) {
        ArrayList<class_1792> shownItems = new ArrayList<class_1792>();
        for (class_1799 stack : stacks) {
            if (shownItems.contains(stack.method_7909())) continue;
            shownItems.add(stack.method_7909());
            ((class_3218)this.field_6002).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public ICorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.field_6011.method_12778(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.field_6011.method_12789(MASTER);
    }

    public void setCreative(boolean creative) {
        this.field_6011.method_12778(CREATIVE, (Object)creative);
    }

    @Override
    public boolean isCreative() {
        return (Boolean)this.field_6011.method_12789(CREATIVE);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_5805() && !stack.method_7960()) {
            if (stack.method_7909() instanceof ItemTwigWand) {
                if (!this.field_6002.field_9236) {
                    if (player.method_5715()) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        EntityCorporeaSpark.displayRelatives(player, new ArrayList<ICorporeaSpark>(), this.master);
                    }
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1769) {
                class_1769 dye = (class_1769)class_17922;
                class_1767 color = dye.method_7802();
                if (color != this.getNetwork()) {
                    if (!this.field_6002.field_9236) {
                        this.setNetwork(color);
                        stack.method_7934(1);
                    }
                    return class_1269.method_29236((boolean)this.field_6002.field_9236);
                }
            } else if (stack.method_31574(ModItems.phantomInk)) {
                if (!this.field_6002.field_9236) {
                    this.method_5648(true);
                }
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public void setNetwork(class_1767 color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Override
    protected void method_5749(@NotNull class_2487 cmp) {
        super.method_5749(cmp);
        this.setMaster(cmp.method_10577(TAG_MASTER));
        this.setCreative(cmp.method_10577(TAG_CREATIVE));
    }

    @Override
    protected void method_5652(@NotNull class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10556(TAG_MASTER, this.isMaster());
        cmp.method_10556(TAG_CREATIVE, this.isCreative());
    }
}

