/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipePureDaisy
implements IPureDaisyRecipe {
    public static final int DEFAULT_TIME = 150;
    private final class_2960 id;
    private final StateIngredient input;
    private final class_2680 outputState;
    private final int time;
    private final class_2158.class_2159 function;

    public RecipePureDaisy(class_2960 id, StateIngredient input, class_2680 state, int time, class_2158.class_2159 function) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.id = id;
        this.input = input;
        this.outputState = state;
        this.time = time;
        this.function = function;
    }

    @Override
    public boolean matches(class_1937 world, class_2338 pos, TileEntitySpecialFlower pureDaisy, class_2680 state) {
        return this.input.test(state);
    }

    @Override
    public boolean set(class_1937 world, class_2338 pos, TileEntitySpecialFlower pureDaisy) {
        if (!world.field_9236) {
            boolean success = world.method_8501(pos, this.outputState);
            if (success) {
                class_3218 serverLevel = (class_3218)world;
                MinecraftServer server = serverLevel.method_8503();
                this.function.method_9196(server.method_3740()).ifPresent(command -> {
                    class_2168 context = server.method_3740().method_12899().method_9208(class_243.method_24955((class_2382)pos));
                    server.method_3740().method_12904(command, context);
                });
            }
            return success;
        }
        return true;
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public class_2680 getOutputState() {
        return this.outputState;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipeTypes.PURE_DAISY_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipePureDaisy> {
        @NotNull
        public RecipePureDaisy fromJson(@NotNull class_2960 id, JsonObject object) {
            StateIngredient input = StateIngredientHelper.deserialize(class_3518.method_15296((JsonObject)object, (String)"input"));
            class_2680 output = StateIngredientHelper.readBlockState(class_3518.method_15296((JsonObject)object, (String)"output"));
            int time = class_3518.method_15282((JsonObject)object, (String)"time", (int)150);
            String functionIdString = class_3518.method_15253((JsonObject)object, (String)"success_function", null);
            class_2960 functionId = functionIdString == null ? null : new class_2960(functionIdString);
            class_2158.class_2159 function = functionId == null ? class_2158.class_2159.field_9809 : new class_2158.class_2159(functionId);
            return new RecipePureDaisy(id, input, output, time, function);
        }

        public void toNetwork(@NotNull class_2540 buf, RecipePureDaisy recipe) {
            recipe.input.write(buf);
            buf.method_10804(class_2248.method_9507((class_2680)recipe.outputState));
            buf.method_10804(recipe.time);
        }

        @Nullable
        public RecipePureDaisy fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buf) {
            StateIngredient input = StateIngredientHelper.read(buf);
            class_2680 output = class_2248.method_9531((int)buf.method_10816());
            int time = buf.method_10816();
            return new RecipePureDaisy(id, input, output, time, class_2158.class_2159.field_9809);
        }
    }
}

