/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeOrechid;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipeMarimorphosis
extends RecipeOrechid {
    private final int weightBonus;
    private final class_6862<class_1959> biomes;

    public RecipeMarimorphosis(class_2960 id, class_2248 input, StateIngredient output, int weight, int weightBonus, class_6862<class_1959> biomes) {
        super(id, input, output, weight);
        this.weightBonus = weightBonus;
        this.biomes = biomes;
    }

    @Override
    public int getWeight(@NotNull class_1937 level, @NotNull class_2338 pos) {
        if (level.method_23753(pos).method_40220(this.biomes)) {
            return this.getWeight() + this.weightBonus;
        }
        return this.getWeight();
    }

    @Override
    public class_3956<?> method_17716() {
        return ModRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    @Override
    public class_1865<?> method_8119() {
        return ModRecipeTypes.MARIMORPHOSIS_SERIALIZER;
    }

    public int getWeightBonus() {
        return this.weightBonus;
    }

    public class_6862<class_1959> getBiomes() {
        return this.biomes;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeMarimorphosis> {
        public RecipeMarimorphosis fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.method_8121(recipeId, json);
            class_6862 biomes = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"biome_bonus_tag")));
            int weightBonus = class_3518.method_15282((JsonObject)json, (String)"biome_bonus", (int)0);
            if (base.getWeight() + weightBonus <= 0) {
                throw new JsonSyntaxException("Weight combined with bonus cannot be 0 or less");
            }
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, (class_6862<class_1959>)biomes);
        }

        public RecipeMarimorphosis fromNetwork(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
            RecipeOrechid base = (RecipeOrechid)ModRecipeTypes.ORECHID_SERIALIZER.method_8122(recipeId, buffer);
            class_6862 biomes = class_6862.method_40092((class_5321)class_2378.field_25114, (class_2960)buffer.method_10810());
            int weightBonus = buffer.method_10816();
            return new RecipeMarimorphosis(recipeId, base.getInput(), base.getOutput(), base.getWeight(), weightBonus, (class_6862<class_1959>)biomes);
        }

        public void toNetwork(@NotNull class_2540 buffer, @NotNull RecipeMarimorphosis recipe) {
            ModRecipeTypes.ORECHID_SERIALIZER.method_8124(buffer, (class_1860)recipe);
            buffer.method_10812(recipe.biomes.comp_327());
            buffer.method_10804(recipe.weightBonus);
        }
    }
}

