/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandBindable;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.block.tile.mana.IThrottledPacket;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileSpreader
extends TileExposedSimpleInventory
implements IWandBindable,
IKeyLocked,
IThrottledPacket,
IManaSpreader,
IWandable {
    private static final int TICKS_ALLOWED_WITHOUT_PINGBACK = 20;
    private static final double PINGBACK_EXPIRED_SEARCH_DISTANCE = 0.5;
    private static final String TAG_UUID = "uuid";
    private static final String TAG_MANA = "mana";
    private static final String TAG_REQUEST_UPDATE = "requestUpdate";
    private static final String TAG_ROTATION_X = "rotationX";
    private static final String TAG_ROTATION_Y = "rotationY";
    private static final String TAG_PADDING_COLOR = "paddingColor";
    private static final String TAG_CAN_SHOOT_BURST = "canShootBurst";
    private static final String TAG_PINGBACK_TICKS = "pingbackTicks";
    private static final String TAG_LAST_PINGBACK_X = "lastPingbackX";
    private static final String TAG_LAST_PINGBACK_Y = "lastPingbackY";
    private static final String TAG_LAST_PINGBACK_Z = "lastPingbackZ";
    private static final String TAG_FORCE_CLIENT_BINDING_X = "forceClientBindingX";
    private static final String TAG_FORCE_CLIENT_BINDING_Y = "forceClientBindingY";
    private static final String TAG_FORCE_CLIENT_BINDING_Z = "forceClientBindingZ";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final String TAG_MAPMAKER_OVERRIDE = "mapmakerOverrideEnabled";
    private static final String TAG_FORCED_COLOR = "mmForcedColor";
    private static final String TAG_FORCED_MANA_PAYLOAD = "mmForcedManaPayload";
    private static final String TAG_FORCED_TICKS_BEFORE_MANA_LOSS = "mmForcedTicksBeforeManaLoss";
    private static final String TAG_FORCED_MANA_LOSS_PER_TICK = "mmForcedManaLossPerTick";
    private static final String TAG_FORCED_GRAVITY = "mmForcedGravity";
    private static final String TAG_FORCED_VELOCITY_MULTIPLIER = "mmForcedVelocityMultiplier";
    private boolean mapmakerOverride = false;
    private int mmForcedColor = 0x20FF20;
    private int mmForcedManaPayload = 160;
    private int mmForcedTicksBeforeManaLoss = 60;
    private float mmForcedManaLossPerTick = 4.0f;
    private float mmForcedGravity = 0.0f;
    private float mmForcedVelocityMultiplier = 1.0f;
    private String inputKey = "";
    private final String outputKey = "";
    private UUID identity = UUID.randomUUID();
    private int mana;
    public float rotationX;
    public float rotationY;
    @Nullable
    public class_1767 paddingColor = null;
    private boolean requestsClientUpdate = false;
    private boolean hasReceivedInitialPacket = false;
    private IManaReceiver receiver = null;
    private IManaReceiver receiverLastTick = null;
    private boolean poweredLastTick = true;
    public boolean canShootBurst = true;
    public int lastBurstDeathTick = -1;
    public int burstParticleTick = 0;
    public int pingbackTicks = 0;
    public double lastPingbackX = 0.0;
    public double lastPingbackY = -2.147483648E9;
    public double lastPingbackZ = 0.0;
    private List<EntityManaBurst.PositionProperties> lastTentativeBurst;
    private boolean invalidTentativeBurst = false;

    public TileSpreader(class_2338 pos, class_2680 state) {
        super(ModTiles.SPREADER, pos, state);
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getMaxMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getMaxMana());
        this.method_5431();
    }

    public void method_11012() {
        super.method_11012();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.COLLECTOR, ManaNetworkAction.REMOVE);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileSpreader self) {
        class_1799 lens;
        ILensControl control;
        boolean redstoneSpreader;
        Object dir2;
        boolean inNetwork;
        boolean wasInNetwork = inNetwork = ManaNetworkHandler.instance.isCollectorIn(level, self);
        if (!inNetwork && !self.method_11015()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(self, ManaBlockType.COLLECTOR, ManaNetworkAction.ADD);
        }
        boolean powered = false;
        for (Object dir2 : class_2350.values()) {
            class_2338 relPos = worldPosition.method_10093(dir2);
            if (!level.method_22340(relPos)) continue;
            IManaReceiver receiverAt = IXplatAbstractions.INSTANCE.findManaReceiver(level, relPos, level.method_8320(relPos), level.method_8321(relPos), dir2.method_10153());
            if (receiverAt instanceof IManaPool) {
                IManaPool pool = (IManaPool)receiverAt;
                if (wasInNetwork && (pool != self.receiver || self.getVariant() == BlockSpreader.Variant.REDSTONE)) {
                    IKeyLocked locked;
                    if (pool instanceof IKeyLocked && !(locked = (IKeyLocked)((Object)pool)).getOutputKey().equals(self.getInputKey())) continue;
                    int manaInPool = pool.getCurrentMana();
                    if (manaInPool > 0 && !self.isFull()) {
                        int manaMissing = self.getMaxMana() - self.mana;
                        int manaToRemove = Math.min(manaInPool, manaMissing);
                        pool.receiveMana(-manaToRemove);
                        self.receiveMana(manaToRemove);
                    }
                }
            }
            powered = powered || level.method_8459(relPos, dir2);
        }
        if (self.needsNewBurstSimulation()) {
            self.checkForReceiver();
        }
        if (!self.canShootBurst) {
            if (self.pingbackTicks <= 0) {
                double x = self.lastPingbackX;
                double y = self.lastPingbackY;
                double z = self.lastPingbackZ;
                class_238 aabb = new class_238(x, y, z, x, y, z).method_1009(0.5, 0.5, 0.5);
                List bursts = level.method_8390(class_1682.class, aabb, (Predicate)Predicates.instanceOf(IManaBurst.class));
                IManaBurst found = null;
                UUID identity = self.getIdentifier();
                for (IManaBurst burst : bursts) {
                    if (burst == null || !identity.equals(burst.getShooterUUID())) continue;
                    found = burst;
                    break;
                }
                if (found != null) {
                    found.ping();
                } else {
                    self.setCanShoot(true);
                }
            } else {
                --self.pingbackTicks;
            }
        }
        boolean shouldShoot = !powered;
        boolean bl = redstoneSpreader = self.getVariant() == BlockSpreader.Variant.REDSTONE;
        if (redstoneSpreader) {
            boolean bl2 = shouldShoot = powered && !self.poweredLastTick;
        }
        if (shouldShoot && (dir2 = self.receiver) instanceof IKeyLocked) {
            IKeyLocked locked = (IKeyLocked)dir2;
            shouldShoot = locked.getInputKey().equals(self.getOutputKey());
        }
        if ((control = self.getLensController(lens = self.getItemHandler().method_5438(0))) != null) {
            if (redstoneSpreader) {
                if (shouldShoot) {
                    control.onControlledSpreaderPulse(lens, self);
                }
            } else {
                control.onControlledSpreaderTick(lens, self, powered);
            }
            boolean bl3 = shouldShoot = shouldShoot && control.allowBurstShooting(lens, self, powered);
        }
        if (shouldShoot) {
            self.tryShootBurst();
        }
        if (self.receiverLastTick != self.receiver && !level.field_9236) {
            self.requestsClientUpdate = true;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.poweredLastTick = powered;
        self.receiverLastTick = self.receiver;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        super.writePacketNBT(cmp);
        cmp.method_25927(TAG_UUID, this.getIdentifier());
        cmp.method_10569(TAG_MANA, this.mana);
        cmp.method_10548(TAG_ROTATION_X, this.rotationX);
        cmp.method_10548(TAG_ROTATION_Y, this.rotationY);
        cmp.method_10556(TAG_REQUEST_UPDATE, this.requestsClientUpdate);
        cmp.method_10569(TAG_PADDING_COLOR, this.paddingColor == null ? -1 : this.paddingColor.method_7789());
        cmp.method_10556(TAG_CAN_SHOOT_BURST, this.canShootBurst);
        cmp.method_10569(TAG_PINGBACK_TICKS, this.pingbackTicks);
        cmp.method_10549(TAG_LAST_PINGBACK_X, this.lastPingbackX);
        cmp.method_10549(TAG_LAST_PINGBACK_Y, this.lastPingbackY);
        cmp.method_10549(TAG_LAST_PINGBACK_Z, this.lastPingbackZ);
        cmp.method_10582(TAG_INPUT_KEY, this.inputKey);
        cmp.method_10582(TAG_OUTPUT_KEY, "");
        cmp.method_10569(TAG_FORCE_CLIENT_BINDING_X, this.receiver == null ? 0 : this.receiver.getManaReceiverPos().method_10263());
        cmp.method_10569(TAG_FORCE_CLIENT_BINDING_Y, this.receiver == null ? Integer.MIN_VALUE : this.receiver.getManaReceiverPos().method_10264());
        cmp.method_10569(TAG_FORCE_CLIENT_BINDING_Z, this.receiver == null ? 0 : this.receiver.getManaReceiverPos().method_10260());
        cmp.method_10556(TAG_MAPMAKER_OVERRIDE, this.mapmakerOverride);
        cmp.method_10569(TAG_FORCED_COLOR, this.mmForcedColor);
        cmp.method_10569(TAG_FORCED_MANA_PAYLOAD, this.mmForcedManaPayload);
        cmp.method_10569(TAG_FORCED_TICKS_BEFORE_MANA_LOSS, this.mmForcedTicksBeforeManaLoss);
        cmp.method_10548(TAG_FORCED_MANA_LOSS_PER_TICK, this.mmForcedManaLossPerTick);
        cmp.method_10548(TAG_FORCED_GRAVITY, this.mmForcedGravity);
        cmp.method_10548(TAG_FORCED_VELOCITY_MULTIPLIER, this.mmForcedVelocityMultiplier);
        this.requestsClientUpdate = false;
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        super.readPacketNBT(cmp);
        String tagUuidMostDeprecated = "uuidMost";
        String tagUuidLeastDeprecated = "uuidLeast";
        if (cmp.method_25928(TAG_UUID)) {
            this.identity = cmp.method_25926(TAG_UUID);
        } else if (cmp.method_10545(tagUuidLeastDeprecated) && cmp.method_10545(tagUuidMostDeprecated)) {
            long most = cmp.method_10537(tagUuidMostDeprecated);
            long least = cmp.method_10537(tagUuidLeastDeprecated);
            if (this.identity == null || most != this.identity.getMostSignificantBits() || least != this.identity.getLeastSignificantBits()) {
                this.identity = new UUID(most, least);
            }
        }
        this.mana = cmp.method_10550(TAG_MANA);
        this.rotationX = cmp.method_10583(TAG_ROTATION_X);
        this.rotationY = cmp.method_10583(TAG_ROTATION_Y);
        this.requestsClientUpdate = cmp.method_10577(TAG_REQUEST_UPDATE);
        if (cmp.method_10545(TAG_INPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_INPUT_KEY);
        }
        if (cmp.method_10545(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_OUTPUT_KEY);
        }
        this.mapmakerOverride = cmp.method_10577(TAG_MAPMAKER_OVERRIDE);
        this.mmForcedColor = cmp.method_10550(TAG_FORCED_COLOR);
        this.mmForcedManaPayload = cmp.method_10550(TAG_FORCED_MANA_PAYLOAD);
        this.mmForcedTicksBeforeManaLoss = cmp.method_10550(TAG_FORCED_TICKS_BEFORE_MANA_LOSS);
        this.mmForcedManaLossPerTick = cmp.method_10583(TAG_FORCED_MANA_LOSS_PER_TICK);
        this.mmForcedGravity = cmp.method_10583(TAG_FORCED_GRAVITY);
        this.mmForcedVelocityMultiplier = cmp.method_10583(TAG_FORCED_VELOCITY_MULTIPLIER);
        if (cmp.method_10545(TAG_PADDING_COLOR)) {
            class_1767 class_17672 = this.paddingColor = cmp.method_10550(TAG_PADDING_COLOR) == -1 ? null : class_1767.method_7791((int)cmp.method_10550(TAG_PADDING_COLOR));
        }
        if (cmp.method_10545(TAG_CAN_SHOOT_BURST)) {
            this.canShootBurst = cmp.method_10577(TAG_CAN_SHOOT_BURST);
        }
        this.pingbackTicks = cmp.method_10550(TAG_PINGBACK_TICKS);
        this.lastPingbackX = cmp.method_10574(TAG_LAST_PINGBACK_X);
        this.lastPingbackY = cmp.method_10574(TAG_LAST_PINGBACK_Y);
        this.lastPingbackZ = cmp.method_10574(TAG_LAST_PINGBACK_Z);
        if (this.requestsClientUpdate && this.field_11863 != null) {
            int x = cmp.method_10550(TAG_FORCE_CLIENT_BINDING_X);
            int y = cmp.method_10550(TAG_FORCE_CLIENT_BINDING_Y);
            int z = cmp.method_10550(TAG_FORCE_CLIENT_BINDING_Z);
            if (y != Integer.MIN_VALUE) {
                class_2338 pos = new class_2338(x, y, z);
                class_2680 state = this.field_11863.method_8320(pos);
                class_2586 be = this.field_11863.method_8321(pos);
                this.receiver = IXplatAbstractions.INSTANCE.findManaReceiver(this.field_11863, pos, state, be, null);
            } else {
                this.receiver = null;
            }
        }
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.hasReceivedInitialPacket = true;
        }
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public class_1937 getManaReceiverLevel() {
        return this.method_10997();
    }

    @Override
    public class_2338 getManaReceiverPos() {
        return this.method_11016();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (player == null) {
            return false;
        }
        if (!player.method_5715()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        } else {
            class_3965 bpos = ItemLexicon.doRayTrace(this.field_11863, player, class_3959.class_242.field_1348);
            if (!this.field_11863.field_9236) {
                double x = bpos.method_17784().field_1352 - (double)this.method_11016().method_10263() - 0.5;
                double y = bpos.method_17784().field_1351 - (double)this.method_11016().method_10264() - 0.5;
                double z = bpos.method_17784().field_1350 - (double)this.method_11016().method_10260() - 0.5;
                if (bpos.method_17780() != class_2350.field_11033 && bpos.method_17780() != class_2350.field_11036) {
                    class_243 clickVector = new class_243(x, 0.0, z);
                    class_243 relative = new class_243(-0.5, 0.0, 0.0);
                    double angle = Math.acos(clickVector.method_1026(relative) / (relative.method_1033() * clickVector.method_1033())) * 180.0 / Math.PI;
                    this.rotationX = (float)angle + 180.0f;
                    if (clickVector.field_1350 < 0.0) {
                        this.rotationX = 360.0f - this.rotationX;
                    }
                }
                double angle = y * 180.0;
                this.rotationY = -((float)angle);
                this.method_5431();
                this.requestsClientUpdate = true;
            }
        }
        return true;
    }

    private boolean needsNewBurstSimulation() {
        if (this.field_11863.field_9236 && !this.hasReceivedInitialPacket) {
            return false;
        }
        if (this.lastTentativeBurst == null) {
            return true;
        }
        for (EntityManaBurst.PositionProperties props : this.lastTentativeBurst) {
            if (props.contentsEqual(this.field_11863)) continue;
            this.invalidTentativeBurst = props.isInvalidIn(this.field_11863);
            return !this.invalidTentativeBurst;
        }
        return false;
    }

    private void tryShootBurst() {
        EntityManaBurst burst;
        boolean redstone;
        boolean bl = redstone = this.getVariant() == BlockSpreader.Variant.REDSTONE;
        if ((this.receiver != null || redstone) && !this.invalidTentativeBurst && this.canShootBurst && (redstone || this.receiver.canReceiveManaFromBursts() && !this.receiver.isFull()) && (burst = this.getBurst(false)) != null && !this.field_11863.field_9236) {
            this.mana -= burst.getStartingMana();
            burst.setShooterUUID(this.getIdentifier());
            this.field_11863.method_8649((class_1297)burst);
            burst.ping();
            if (!BotaniaConfig.common().silentSpreaders()) {
                this.field_11863.method_8396(null, this.field_11867, ModSounds.spreaderFire, class_3419.field_15245, 0.05f * (this.paddingColor != null ? 0.2f : 1.0f), 0.7f + 0.3f * (float)Math.random());
            }
        }
    }

    public BlockSpreader.Variant getVariant() {
        class_2248 b = this.method_11010().method_26204();
        if (b instanceof BlockSpreader) {
            BlockSpreader spreader = (BlockSpreader)b;
            return spreader.variant;
        }
        return BlockSpreader.Variant.MANA;
    }

    public void checkForReceiver() {
        class_1799 stack = this.getItemHandler().method_5438(0);
        ILensControl control = this.getLensController(stack);
        if (control != null && !control.allowBurstShooting(stack, this, false)) {
            return;
        }
        EntityManaBurst fakeBurst = this.getBurst(true);
        fakeBurst.setScanBeam();
        IManaReceiver receiver = fakeBurst.getCollidedTile(true);
        this.receiver = receiver != null && receiver.getManaReceiverLevel().method_22340(receiver.getManaReceiverPos()) ? receiver : null;
        this.lastTentativeBurst = fakeBurst.propsList;
    }

    @Override
    public IManaBurst runBurstSimulation() {
        EntityManaBurst fakeBurst = this.getBurst(true);
        fakeBurst.setScanBeam();
        fakeBurst.getCollidedTile(true);
        return fakeBurst;
    }

    private EntityManaBurst getBurst(boolean fake) {
        class_1792 class_17922;
        BlockSpreader.Variant variant = this.getVariant();
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(variant.burstMana, variant.preLossTicks, variant.lossPerTick, gravity, variant.motionModifier, variant.color);
        class_1799 lens = this.getItemHandler().method_5438(0);
        if (!lens.method_7960() && (class_17922 = lens.method_7909()) instanceof ILensEffect) {
            ILensEffect lensEffect = (ILensEffect)class_17922;
            lensEffect.apply(lens, props, this.field_11863);
        }
        if (this.getCurrentMana() >= props.maxMana || fake) {
            EntityManaBurst burst = new EntityManaBurst(this.method_10997(), this.method_11016(), this.getRotationX(), this.getRotationY(), fake);
            burst.setSourceLens(lens);
            if (this.mapmakerOverride) {
                burst.setColor(this.mmForcedColor);
                burst.setMana(this.mmForcedManaPayload);
                burst.setStartingMana(this.mmForcedManaPayload);
                burst.setMinManaLoss(this.mmForcedTicksBeforeManaLoss);
                burst.setManaLossPerTick(this.mmForcedManaLossPerTick);
                burst.setGravity(this.mmForcedGravity);
                burst.method_18799(burst.method_18798().method_1021((double)this.mmForcedVelocityMultiplier));
            } else {
                burst.setColor(props.color);
                burst.setMana(props.maxMana);
                burst.setStartingMana(props.maxMana);
                burst.setMinManaLoss(props.ticksBeforeManaLoss);
                burst.setManaLossPerTick(props.manaLossPerTick);
                burst.setGravity(props.gravity);
                burst.method_18799(burst.method_18798().method_1021((double)props.motionModifier));
            }
            return burst;
        }
        return null;
    }

    public ILensControl getLensController(class_1799 stack) {
        ILensControl control;
        class_1792 class_17922;
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof ILensControl && (control = (ILensControl)class_17922).isControlLens(stack)) {
            return control;
        }
        return null;
    }

    @Override
    public void onClientDisplayTick() {
        if (this.field_11863 != null) {
            EntityManaBurst burst = this.getBurst(true);
            burst.getCollidedTile(false);
        }
    }

    @Override
    public float getManaYieldMultiplier(IManaBurst burst) {
        return 1.0f;
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int index, class_1799 stack) {
                return !stack.method_7960() && stack.method_7909() instanceof ILens;
            }
        };
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.checkForReceiver();
            if (!this.field_11863.field_9236) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    @Override
    public class_2338 getBinding() {
        if (this.receiver == null) {
            return null;
        }
        return this.receiver.getManaReceiverPos();
    }

    @Override
    public int getMaxMana() {
        return this.getVariant().manaCapacity;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        return true;
    }

    @Override
    public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
        class_265 shape = player.field_6002.method_8320(pos).method_26218((class_1922)player.field_6002, pos);
        class_238 axis = shape.method_1110() ? new class_238(pos) : shape.method_1107().method_996(pos);
        class_243 thisVec = class_243.method_24953((class_2382)this.method_11016());
        class_243 blockVec = new class_243(axis.field_1323 + (axis.field_1320 - axis.field_1323) / 2.0, axis.field_1322 + (axis.field_1325 - axis.field_1322) / 2.0, axis.field_1321 + (axis.field_1324 - axis.field_1321) / 2.0);
        class_243 diffVec = blockVec.method_1020(thisVec);
        class_243 diffVec2D = new class_243(diffVec.field_1352, diffVec.field_1350, 0.0);
        class_243 rotVec = new class_243(0.0, 1.0, 0.0);
        double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
        if (blockVec.field_1352 < thisVec.field_1352) {
            angle = -angle;
        }
        this.rotationX = (float)angle + 90.0f;
        rotVec = new class_243(diffVec.field_1352, 0.0, diffVec.field_1350);
        angle = MathHelper.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
        if (blockVec.field_1351 < thisVec.field_1351) {
            angle = -angle;
        }
        this.rotationY = (float)angle;
        this.method_5431();
        return true;
    }

    @Override
    public void markDispatchable() {
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public void setRotationX(float rot) {
        this.rotationX = rot;
    }

    @Override
    public void setRotationY(float rot) {
        this.rotationY = rot;
    }

    public void rotate(class_2470 rotation) {
        switch (rotation) {
            case field_11463: {
                this.rotationX += 270.0f;
                break;
            }
            case field_11464: {
                this.rotationX += 180.0f;
                break;
            }
            case field_11465: {
                this.rotationX += 90.0f;
                break;
            }
        }
        if (this.rotationX >= 360.0f) {
            this.rotationX -= 360.0f;
        }
    }

    public void mirror(class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                this.rotationX = 360.0f - this.rotationX;
                break;
            }
            case field_11301: {
                this.rotationX = 180.0f - this.rotationX;
                break;
            }
        }
        if (this.rotationX < 0.0f) {
            this.rotationX += 360.0f;
        }
    }

    @Override
    public void commitRedirection() {
        this.method_5431();
    }

    @Override
    public void setCanShoot(boolean canShoot) {
        this.canShootBurst = canShoot;
    }

    @Override
    public int getBurstParticleTick() {
        return this.burstParticleTick;
    }

    @Override
    public void setBurstParticleTick(int i) {
        this.burstParticleTick = i;
    }

    @Override
    public int getLastBurstDeathTick() {
        return this.lastBurstDeathTick;
    }

    @Override
    public void setLastBurstDeathTick(int i) {
        this.lastBurstDeathTick = i;
    }

    @Override
    public void pingback(IManaBurst burst, UUID expectedIdentity) {
        if (this.getIdentifier().equals(expectedIdentity)) {
            this.pingbackTicks = 20;
            class_1682 e = burst.entity();
            this.lastPingbackX = e.method_23317();
            this.lastPingbackY = e.method_23318();
            this.lastPingbackZ = e.method_23321();
            this.setCanShoot(false);
        }
    }

    @Override
    public UUID getIdentifier() {
        return this.identity;
    }

    public static class WandHud
    implements IWandHUD {
        private final TileSpreader spreader;

        public WandHud(TileSpreader spreader) {
            this.spreader = spreader;
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            String name = new class_1799((class_1935)this.spreader.method_11010().method_26204()).method_7964().getString();
            int color = this.spreader.getVariant().hudColor;
            BotaniaAPIClient.instance().drawSimpleManaHUD(ms, color, this.spreader.getCurrentMana(), this.spreader.getMaxMana(), name);
            class_1799 lens = this.spreader.getItemHandler().method_5438(0);
            if (!lens.method_7960()) {
                class_2561 lensName = lens.method_7964();
                int width = 16 + mc.field_1772.method_27525((class_5348)lensName) / 2;
                int x = mc.method_22683().method_4486() / 2 - width;
                int y = mc.method_22683().method_4502() / 2 + 50;
                mc.field_1772.method_30881(ms, lensName, (float)(x + 20), (float)(y + 5), color);
                mc.method_1480().method_4023(lens, x, y);
            }
            if (this.spreader.receiver != null) {
                class_2338 receiverPos = this.spreader.receiver.getManaReceiverPos();
                class_1799 recieverStack = new class_1799((class_1935)this.spreader.field_11863.method_8320(receiverPos).method_26204());
                if (!recieverStack.method_7960()) {
                    String stackName = recieverStack.method_7964().getString();
                    int width = 16 + mc.field_1772.method_1727(stackName) / 2;
                    int x = mc.method_22683().method_4486() / 2 - width;
                    int y = mc.method_22683().method_4502() / 2 + 30;
                    mc.field_1772.method_1720(ms, stackName, (float)(x + 20), (float)(y + 5), color);
                    mc.method_1480().method_4023(recieverStack, x, y);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

