/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileRFGenerator
extends TileMod
implements IManaReceiver {
    private static final int MANA_TO_FE = IXplatAbstractions.INSTANCE.isForge() ? 10 : 3;
    public static final int MAX_ENERGY = 1280 * MANA_TO_FE;
    private static final String TAG_MANA = "mana";
    private int energy = 0;

    public TileRFGenerator(class_2338 pos, class_2680 state) {
        super(ModTiles.FLUXFIELD, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TileRFGenerator self) {
        int toTransfer = Math.min(self.energy, 160 * MANA_TO_FE);
        int unconsumed = IXplatAbstractions.INSTANCE.transferEnergyToNeighbors(level, pos, toTransfer);
        if (unconsumed != toTransfer) {
            self.energy -= toTransfer - unconsumed;
            self.method_5431();
        }
    }

    @Override
    public class_1937 getManaReceiverLevel() {
        return this.method_10997();
    }

    @Override
    public class_2338 getManaReceiverPos() {
        return this.method_11016();
    }

    @Override
    public int getCurrentMana() {
        return this.energy / MANA_TO_FE;
    }

    @Override
    public boolean isFull() {
        return this.energy >= MAX_ENERGY;
    }

    @Override
    public void receiveMana(int mana) {
        this.energy = Math.min(MAX_ENERGY, this.energy + mana * MANA_TO_FE);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.energy);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.energy = cmp.method_10550(TAG_MANA);
    }

    public int getEnergy() {
        return this.energy;
    }
}

