/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1767;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5545;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockTinyPotato;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TileTinyPotato
extends TileExposedSimpleInventory
implements class_1275 {
    private static final class_2960 BIRTHDAY_ADVANCEMENT = ResourceLocationHelper.prefix("challenge/tiny_potato_birthday");
    private static final boolean IS_BIRTHDAY = TileTinyPotato.isTinyPotatoBirthday();
    private static final String TAG_NAME = "name";
    private static final int JUMP_EVENT = 0;
    public int jumpTicks = 0;
    public class_2561 name = class_2561.method_43470((String)"");
    private int nextDoIt = 0;
    private int birthdayTick = 0;
    private static final List<class_2248> ALL_CANDLE_CAKES = List.of(class_2246.field_27143, class_2246.field_27144, class_2246.field_27145, class_2246.field_27146, class_2246.field_27147, class_2246.field_27148, class_2246.field_27149, class_2246.field_27150, class_2246.field_27151, class_2246.field_27152, class_2246.field_27153, class_2246.field_27154, class_2246.field_27155, class_2246.field_27156, class_2246.field_27157, class_2246.field_27158, class_2246.field_27142);

    public TileTinyPotato(class_2338 pos, class_2680 state) {
        super(ModTiles.TINY_POTATO, pos, state);
    }

    public void interact(class_1657 player, class_1268 hand, class_1799 stack, class_2350 side) {
        if (!this.field_11863.field_9236) {
            int index = side.method_10146();
            class_1799 stackAt = this.getItemHandler().method_5438(index);
            if (!stackAt.method_7960() && stack.method_7960()) {
                player.method_6122(hand, stackAt);
                this.getItemHandler().method_5447(index, class_1799.field_8037);
            } else if (!stack.method_7960()) {
                class_1799 copy = stack.method_7971(1);
                if (stack.method_7960()) {
                    player.method_6122(hand, stackAt);
                } else if (!stackAt.method_7960()) {
                    player.method_31548().method_7398(stackAt);
                }
                this.getItemHandler().method_5447(index, copy);
            }
            this.jump();
            if (this.name.getString().toLowerCase(Locale.ROOT).trim().endsWith("shia labeouf") && this.nextDoIt == 0) {
                this.nextDoIt = 40;
                this.field_11863.method_8396(null, this.field_11867, ModSounds.doit, class_3419.field_15245, 1.0f, 1.0f);
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                class_1799 son = this.getItemHandler().method_5438(i);
                if (son.method_7960() || !son.method_31574(ModBlocks.tinyPotato.method_8389())) continue;
                player.method_43496((class_2561)class_2561.method_43470((String)"Don't talk to me or my son ever again."));
                return;
            }
            player.method_7281(ModStats.TINY_POTATOES_PETTED);
            PlayerHelper.grantCriterion((class_3222)player, ResourceLocationHelper.prefix("main/tiny_potato_pet"), "code_triggered");
        }
    }

    private void jump() {
        if (this.jumpTicks == 0) {
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 0, 20);
        }
    }

    public boolean method_11004(int id, int param) {
        if (id == 0) {
            this.jumpTicks = param;
            return true;
        }
        return super.method_11004(id, param);
    }

    public static void commonTick(class_1937 level, class_2338 pos, class_2680 state, TileTinyPotato self) {
        if (self.jumpTicks > 0) {
            --self.jumpTicks;
        }
        if (!level.field_9236) {
            if (level.field_9229.method_43048(100) == 0) {
                self.jump();
            }
            if (self.nextDoIt > 0) {
                --self.nextDoIt;
            }
            if (IS_BIRTHDAY) {
                self.tickBirthday();
            }
        }
    }

    private void tickBirthday() {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
        class_2338 facingPos = this.method_11016().method_10093(facing);
        if (this.field_11863.method_22340(facingPos)) {
            class_2680 facingState = this.field_11863.method_8320(facingPos);
            class_1767 cakeColor = TileTinyPotato.getLitCakeColor(facingState, this.field_11863.method_8409());
            List<class_1657> players = PlayerHelper.getRealPlayersIn(this.field_11863, VecHelper.boxForRange(class_243.method_24953((class_2382)this.method_11016()), 8.0));
            if (cakeColor != null && !players.isEmpty()) {
                ++this.birthdayTick;
                List<Integer> messageTimes = List.of(Integer.valueOf(100), Integer.valueOf(170), Integer.valueOf(240), Integer.valueOf(310), Integer.valueOf(380));
                int messageIndex = messageTimes.indexOf(this.birthdayTick);
                if (messageIndex != -1) {
                    Object[] objectArray;
                    if (messageIndex == 1) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = TileTinyPotato.getTinyPotatoAge();
                    } else {
                        objectArray = ObjectArrays.EMPTY_ARRAY;
                    }
                    Object[] args = objectArray;
                    class_5250 message = class_2561.method_43470((String)"<").method_10852(this.method_5476()).method_27693("> ").method_10852((class_2561)class_2561.method_43469((String)("botania.tater_birthday." + messageIndex), (Object[])args));
                    for (class_1657 player : players) {
                        player.method_43496((class_2561)message);
                    }
                    this.jump();
                    BlockTinyPotato.spawnHearts((class_3218)this.field_11863, this.method_11016());
                }
                if (messageIndex == messageTimes.size() - 1) {
                    class_2487 explosion = new class_2487();
                    explosion.method_10567("Type", (byte)class_1781.class_1782.field_7977.method_7816());
                    explosion.method_10556("Flicker", true);
                    explosion.method_10556("Trail", true);
                    explosion.method_10572("Colors", List.of(Integer.valueOf(cakeColor.method_7790()), Integer.valueOf(13787301), Integer.valueOf(14987213), Integer.valueOf(0xFEFEFE), Integer.valueOf(5754616)));
                    class_2499 explosions = new class_2499();
                    explosions.add((Object)explosion);
                    class_1799 rocket = new class_1799((class_1935)class_1802.field_8639);
                    class_2487 rocketFireworks = rocket.method_7911("Fireworks");
                    rocketFireworks.method_10567("Flight", (byte)0);
                    rocketFireworks.method_10566("Explosions", (class_2520)explosions);
                    this.field_11863.method_8649((class_1297)new class_1671(this.field_11863, (double)facingPos.method_10263() + 0.5, (double)facingPos.method_10264() + 0.5, (double)facingPos.method_10260() + 0.5, rocket));
                    this.field_11863.method_8650(facingPos, false);
                    this.field_11863.method_20290(2001, facingPos, class_2248.method_9507((class_2680)facingState));
                    this.field_11863.method_8396(null, this.method_11016(), class_3417.field_20614, class_3419.field_15245, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                    for (class_1657 player : players) {
                        PlayerHelper.grantCriterion((class_3222)player, BIRTHDAY_ADVANCEMENT, "code_triggered");
                    }
                }
            }
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        super.writePacketNBT(cmp);
        cmp.method_10582(TAG_NAME, class_2561.class_2562.method_10867((class_2561)this.name));
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        super.readPacketNBT(cmp);
        this.name = class_2561.class_2562.method_10877((String)cmp.method_10558(TAG_NAME));
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(6){

            public int method_5444() {
                return 1;
            }
        };
    }

    @NotNull
    public class_2561 method_5477() {
        return ModBlocks.tinyPotato.method_9518();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.name.getString().isEmpty() ? null : this.name;
    }

    @NotNull
    public class_2561 method_5476() {
        return this.method_16914() ? this.method_5797() : this.method_5477();
    }

    @Nullable
    private static class_1767 getLitCakeColor(class_2680 state, class_5819 rand) {
        int idx = ALL_CANDLE_CAKES.indexOf(state.method_26204());
        if (idx == -1) {
            return null;
        }
        if (!((Boolean)state.method_11654((class_2769)class_5545.field_27183)).booleanValue()) {
            return null;
        }
        if (idx == 16) {
            return class_1767.method_7791((int)rand.method_43048(16));
        }
        return class_1767.method_7791((int)idx);
    }

    private static boolean isTinyPotatoBirthday() {
        LocalDateTime now = LocalDateTime.now();
        return now.getMonth() == Month.JULY && now.getDayOfMonth() == 19;
    }

    private static int getTinyPotatoAge() {
        LocalDateTime now = LocalDateTime.now();
        return now.getYear() - 2014;
    }
}

