/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3730;
import net.minecraft.class_3854;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.lib.ModTags;

public class TileCocoon
extends TileMod {
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    private static final float SPECIAL_CHANCE = 0.075f;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;
    public boolean gaiaSpiritGiven;

    public TileCocoon(class_2338 pos, class_2680 state) {
        super(ModTiles.COCOON, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileCocoon self) {
        ++self.timePassed;
        if (self.timePassed >= 2400) {
            self.hatch();
        }
    }

    private void hatch() {
        if (!this.field_11863.field_9236) {
            this.timePassed = 0;
            this.field_11863.method_22352(this.field_11867, false);
            class_1308 entity = null;
            class_2338 placePos = this.field_11867;
            float rareChance = this.gaiaSpiritGiven ? 1.0f : 0.075f;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            ArrayList<class_2338> validWater = new ArrayList<class_2338>();
            for (class_2350 d : class_2350.values()) {
                class_2338 blockPos;
                class_2338 class_23382 = blockPos = d == class_2350.field_11036 ? this.field_11867 : this.field_11867.method_10093(d);
                if (!this.field_11863.method_22340(blockPos) || !this.field_11863.method_8320(blockPos).method_27852(class_2246.field_10382)) continue;
                validWater.add(blockPos);
            }
            if (Math.random() < (double)shulkerChance) {
                entity = (class_1308)class_1299.field_6109.method_5883(this.field_11863);
            } else if (Math.random() < (double)villagerChance) {
                class_1646 villager = (class_1646)class_1299.field_6077.method_5883(this.field_11863);
                if (villager != null) {
                    class_3854 type = class_3854.method_16930((class_6880)this.field_11863.method_23753(this.field_11867));
                    villager.method_7195(villager.method_7231().method_16922(type));
                }
                entity = villager;
            } else if (!validWater.isEmpty()) {
                placePos = (class_2338)validWater.get(this.field_11863.field_9229.method_43048(validWater.size()));
                entity = Math.random() < (double)rareChance ? this.random(ModTags.Entities.COCOON_RARE_AQUATIC) : this.random(ModTags.Entities.COCOON_COMMON_AQUATIC);
            } else {
                entity = Math.random() < (double)rareChance ? this.random(ModTags.Entities.COCOON_RARE) : this.random(ModTags.Entities.COCOON_COMMON);
            }
            if (entity != null) {
                if ((double)this.field_11863.field_9229.method_43057() < 0.01) {
                    class_5250 name = class_2561.method_43470((String)"Jeanne d'");
                    name.method_10852(entity.method_5477());
                    name.method_10852((class_2561)class_2561.method_43470((String)" [SSR]"));
                    entity.method_5665((class_2561)name.method_27692(class_124.field_1065));
                    entity.method_5880(true);
                }
                entity.method_5814((double)placePos.method_10263() + 0.5, (double)placePos.method_10264() + 0.5, (double)placePos.method_10260() + 0.5);
                if (entity instanceof class_1296) {
                    class_1296 ageable = (class_1296)entity;
                    ageable.method_5614(-24000);
                }
                entity.method_5943((class_5425)this.field_11863, this.field_11863.method_8404(this.method_11016()), class_3730.field_16467, null, null);
                entity.method_5971();
                this.field_11863.method_8649((class_1297)entity);
                entity.method_5990();
            }
        }
    }

    public void forceRare() {
        this.gaiaSpiritGiven = true;
        this.timePassed = Math.max(this.timePassed, 1200);
    }

    @Nullable
    private class_1308 random(class_6862<class_1299<?>> tag) {
        class_1297 entity;
        class_1299 type = class_2378.field_11145.method_40266(tag).flatMap(t -> t.method_40243(this.field_11863.field_9229)).map(class_6880::comp_349).orElse(null);
        if (type == null) {
            return null;
        }
        if (type == class_1299.field_6085 && (double)this.field_11863.field_9229.method_43057() < 0.01) {
            type = class_1299.field_6143;
        }
        return (entity = type.method_5883(this.field_11863)) instanceof class_1308 ? (class_1308)entity : null;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_TIME_PASSED, this.timePassed);
        cmp.method_10569(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.method_10569(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
        cmp.method_10556(TAG_GAIA_SPIRIT_GIVEN, this.gaiaSpiritGiven);
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.timePassed = cmp.method_10550(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.method_10550(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.method_10550(TAG_CHORUS_FRUIT_GIVEN);
        this.gaiaSpiritGiven = cmp.method_10577(TAG_GAIA_SPIRIT_GIVEN);
    }
}

