/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileOrechid
extends TileEntityFunctionalFlower {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    protected SubTileOrechid(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SubTileOrechid(class_2338 pos, class_2680 state) {
        this(ModSubtiles.ORECHID, pos, state);
    }

    @Override
    public void tickFlower() {
        class_2680 state;
        class_2338 coords;
        super.tickFlower();
        if (this.method_10997().field_9236 || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        int cost = this.getCost();
        if (this.getMana() >= cost && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getOreToPut(coords, this.method_10997().method_8320(coords))) != null) {
            this.method_10997().method_8501(coords, state);
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.method_10997().method_20290(2001, coords, class_2248.method_9507((class_2680)state));
            }
            this.playSound(coords);
            this.addMana(-cost);
            this.sync();
        }
    }

    protected void playSound(class_2338 coords) {
        this.method_10997().method_8396(null, coords, ModSounds.orechid, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Nullable
    private class_2680 getOreToPut(class_2338 coords, class_2680 state) {
        ArrayList<Output> values = new ArrayList<Output>();
        for (IOrechidRecipe recipe : OrechidManager.getFor(this.method_10997().method_8433(), this.getRecipeType()).get((Object)state.method_26204())) {
            Output output = new Output(recipe, recipe.getWeight(this.method_10997(), coords));
            values.add(output);
        }
        return class_6011.method_34986((class_5819)this.method_10997().field_9229, values).map(oo -> oo.recipe.getOutput(this.method_10997(), coords).pick(this.method_10997().method_8409())).orElse(null);
    }

    private class_2338 getCoordsToPut() {
        ArrayList<class_2338> possibleCoords = new ArrayList<class_2338>();
        Predicate<class_2680> matcher = this.getReplaceMatcher();
        for (class_2338 pos : class_2338.method_10097((class_2338)this.getEffectivePos().method_10069(-this.getRange(), -this.getRangeY(), -this.getRange()), (class_2338)this.getEffectivePos().method_10069(this.getRange(), this.getRangeY(), this.getRange()))) {
            class_2680 state = this.method_10997().method_8320(pos);
            if (!matcher.test(state)) continue;
            possibleCoords.add(pos.method_10062());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (class_2338)possibleCoords.get(this.method_10997().field_9229.method_43048(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public class_3956<? extends IOrechidRecipe> getRecipeType() {
        return ModRecipeTypes.ORECHID_TYPE;
    }

    public Predicate<class_2680> getReplaceMatcher() {
        ListMultimap<class_2248, ? extends IOrechidRecipe> map = OrechidManager.getFor(this.method_10997().method_8433(), this.getRecipeType());
        return state -> map.containsKey((Object)state.method_26204());
    }

    public int getCost() {
        return IXplatAbstractions.INSTANCE.gogLoaded() ? 700 : 17500;
    }

    public int getDelay() {
        return IXplatAbstractions.INSTANCE.gogLoaded() ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }

    private static class Output
    implements class_6008 {
        private final class_6007 weight;
        private final IOrechidRecipe recipe;

        public Output(IOrechidRecipe recipe, int weight) {
            this.weight = class_6007.method_34977((int)weight);
            this.recipe = recipe;
        }

        public class_6007 method_34979() {
            return this.weight;
        }
    }
}

