/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1548;
import net.minecraft.class_1549;
import net.minecraft.class_1551;
import net.minecraft.class_1560;
import net.minecraft.class_1576;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileLoonuim
extends TileEntityFunctionalFlower {
    private static final int COST = 35000;
    private static final int RANGE = 5;
    private static final String TAG_LOOT_TABLE = "lootTable";
    public static final Set<Class<? extends class_1588>> VALID_MOBS = Set.of(class_1548.class, class_1560.class, class_1613.class, class_1627.class, class_1628.class, class_1642.class);
    private class_2960 lootTable = new class_2960("minecraft", "chests/simple_dungeon");

    public SubTileLoonuim(class_2338 pos, class_2680 state) {
        super(ModSubtiles.LOONIUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        class_1937 world = this.method_10997();
        if (!world.field_9236 && this.redstoneSignal == 0 && this.ticksExisted % 100 == 0 && this.getMana() >= 35000 && world.method_8407() != class_1267.field_5801) {
            ObjectArrayList stacks;
            class_1799 stack;
            class_5819 rand = world.field_9229;
            do {
                class_47 ctx = new class_47.class_48((class_3218)world).method_309(class_173.field_1175);
                stacks = ((class_3218)world).method_8503().method_3857().method_367(this.lootTable).method_319(ctx);
                if (stacks.isEmpty()) {
                    return;
                }
                Collections.shuffle(stacks);
            } while ((stack = (class_1799)stacks.get(0)).method_7960() || stack.method_31573(ModTags.Items.LOONIUM_BLACKLIST));
            int bound = 11;
            int xp = this.getEffectivePos().method_10263() - 5 + rand.method_43048(bound);
            int yp = this.getEffectivePos().method_10264();
            int zp = this.getEffectivePos().method_10260() - 5 + rand.method_43048(bound);
            class_2338 pos = new class_2338(xp, yp - 1, zp);
            do {
                if ((pos = pos.method_10084()).method_10264() < world.method_31600()) continue;
                return;
            } while (world.method_8320(pos).method_26228((class_1922)world, pos));
            pos = pos.method_10084();
            double x = (double)pos.method_10263() + Math.random();
            double y = (double)pos.method_10264() + Math.random();
            double z = (double)pos.method_10260() + Math.random();
            Object entity = null;
            if (world.field_9229.method_43048(50) == 0) {
                entity = new class_1560(class_1299.field_6091, world);
            } else if (world.field_9229.method_43048(10) == 0) {
                entity = new class_1548(class_1299.field_6046, world);
                if (world.field_9229.method_43048(200) == 0) {
                    class_2487 charged = new class_2487();
                    charged.method_10556("powered", true);
                    entity.method_5749(charged);
                }
            } else {
                switch (world.field_9229.method_43048(3)) {
                    case 0: {
                        if (world.field_9229.method_43048(10) == 0) {
                            entity = new class_1576(class_1299.field_6071, world);
                            break;
                        }
                        if (world.field_9229.method_43048(5) == 0) {
                            entity = new class_1551(class_1299.field_6123, world);
                            break;
                        }
                        entity = new class_1642(world);
                        break;
                    }
                    case 1: {
                        if (world.field_9229.method_43048(10) == 0) {
                            entity = new class_1627(class_1299.field_6098, world);
                            break;
                        }
                        entity = new class_1613(class_1299.field_6137, world);
                        break;
                    }
                    case 2: {
                        entity = world.field_9229.method_43048(10) == 0 ? new class_1549(class_1299.field_6084, world) : new class_1628(class_1299.field_6079, world);
                    }
                }
            }
            entity.method_5641(x, y, z, world.field_9229.method_43057() * 360.0f, 0.0f);
            entity.method_18799(class_243.field_1353);
            entity.method_5996(class_5134.field_23716).method_26837(new class_1322("Loonium Modififer Health", 2.0, class_1322.class_1323.field_6330));
            entity.method_5996(class_5134.field_23721).method_26837(new class_1322("Loonium Modififer Damage", 1.5, class_1322.class_1323.field_6330));
            entity.method_6092(new class_1293(class_1294.field_5918, entity instanceof class_1548 ? 100 : Integer.MAX_VALUE, 0));
            entity.method_6092(new class_1293(class_1294.field_5924, entity instanceof class_1548 ? 100 : Integer.MAX_VALUE, 0));
            IXplatAbstractions.INSTANCE.looniumComponent((class_1309)entity).setDrop(stack);
            entity.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16469, null, null);
            world.method_8649((class_1297)entity);
            entity.method_5990();
            this.addMana(-35000);
            this.sync();
        }
    }

    @Override
    public int getColor() {
        return 2574848;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.method_10545(TAG_LOOT_TABLE)) {
            this.lootTable = new class_2960(cmp.method_10558(TAG_LOOT_TABLE));
        }
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10582(TAG_LOOT_TABLE, this.lootTable.toString());
    }

    public static void dropLooniumItems(class_1309 living, Consumer<class_1799> consumer) {
        LooniumComponent comp = IXplatAbstractions.INSTANCE.looniumComponent(living);
        if (comp != null && !comp.getDrop().method_7960()) {
            consumer.accept(comp.getDrop());
        }
    }
}

