/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2473;
import net.minecraft.class_2500;
import net.minecraft.class_2513;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import net.minecraft.class_3830;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.BotaniaConfig;

public class SubTileAgricarnation
extends TileEntityFunctionalFlower {
    private static final Set<class_3614> MATERIALS = ImmutableSet.of((Object)class_3614.field_15935, (Object)class_3614.field_15925, (Object)class_3614.field_15945, (Object)class_3614.field_15923, (Object)class_3614.field_15954, (Object)class_3614.field_15947, (Object[])new class_3614[]{class_3614.field_15946, class_3614.field_15938});
    private static final int RANGE = 5;
    private static final int RANGE_MINI = 2;

    protected SubTileAgricarnation(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SubTileAgricarnation(class_2338 pos, class_2680 state) {
        this(ModSubtiles.AGRICARNATION, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.ticksExisted % 6 == 0 && this.redstoneSignal == 0) {
            int range = this.getRange();
            int x = this.getEffectivePos().method_10263() + this.method_10997().field_9229.method_43048(range * 2 + 1) - range;
            int z = this.getEffectivePos().method_10260() + this.method_10997().field_9229.method_43048(range * 2 + 1) - range;
            for (int i = 4; i > -2; --i) {
                int y = this.getEffectivePos().method_10264() + i;
                class_2338 pos = new class_2338(x, y, z);
                if (this.method_10997().method_22347(pos) || !this.isPlant(pos) || this.getMana() <= 5) continue;
                class_2680 state = this.method_10997().method_8320(pos);
                this.addMana(-5);
                state.method_26199((class_3218)this.field_11863, pos, this.field_11863.field_9229);
                if (BotaniaConfig.common().blockBreakParticles()) {
                    this.method_10997().method_20290(2005, pos, 6 + this.method_10997().field_9229.method_43048(4));
                }
                this.method_10997().method_43128(null, (double)x, (double)y, (double)z, ModSounds.agricarnation, class_3419.field_15245, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                break;
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    private boolean isPlant(class_2338 pos) {
        class_2256 mealable;
        class_2680 state = this.method_10997().method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2500) {
            return false;
        }
        if (!(!(block instanceof class_2261) || block instanceof class_2302 || block instanceof class_2513 || block instanceof class_2473 || block instanceof class_3830)) {
            return false;
        }
        return MATERIALS.contains(state.method_26207()) && block instanceof class_2256 && (mealable = (class_2256)block).method_9651((class_1922)this.method_10997(), pos, state, this.method_10997().field_9236);
    }

    @Override
    public int getColor() {
        return 9369640;
    }

    @Override
    public int getMaxMana() {
        return 200;
    }

    public int getRange() {
        return 5;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileAgricarnation {
        public Mini(class_2338 pos, class_2680 state) {
            super(ModSubtiles.AGRICARNATION_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 2;
        }
    }
}

