/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TilePlatform;

public class BlockPlatform
extends BlockMod
implements IManaCollisionGhost,
class_2343 {
    private final Variant variant;

    public BlockPlatform(@NotNull Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
    }

    public Variant getVariant() {
        return this.variant;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        TilePlatform platform;
        class_2586 te = world.method_8321(pos);
        if (te instanceof TilePlatform && (platform = (TilePlatform)te).getCamoState() != null) {
            return platform.getCamoState().method_26218(world, pos);
        }
        return super.method_9530(state, world, pos, context);
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, class_3726 context) {
        if (this.variant.collide.test(pos, context)) {
            return super.method_9530(state, world, pos, context);
        }
        return class_259.method_1073();
    }

    public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
        return 1.0f;
    }

    @NotNull
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new TilePlatform(pos, state);
    }

    @Override
    public IManaCollisionGhost.Behaviour getGhostBehaviour() {
        return IManaCollisionGhost.Behaviour.SKIP_ALL;
    }

    public static boolean isValidBlock(@Nullable class_2680 state, class_1937 world, class_2338 pos) {
        return state != null && (state.method_26216((class_1922)world, pos) || state.method_26217() == class_2464.field_11458);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (this.variant.indestructible) {
            tooltip.add((class_2561)class_2561.method_43471((String)"botaniamisc.creative").method_27692(class_124.field_1080));
        }
    }

    @NotNull
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 tile = world.method_8321(pos);
        class_1799 currentStack = player.method_5998(hand);
        if (this.variant.indestructible && !player.method_7337()) {
            return class_1269.field_5811;
        }
        if (!currentStack.method_7960() && class_2248.method_9503((class_1792)currentStack.method_7909()) != class_2246.field_10124 && tile instanceof TilePlatform) {
            TilePlatform camo = (TilePlatform)tile;
            class_1750 ctx = new class_1750(player, hand, currentStack, hit);
            class_2680 changeState = class_2248.method_9503((class_1792)currentStack.method_7909()).method_9605(ctx);
            if (BlockPlatform.isValidBlock(changeState, world, pos) && !(changeState.method_26204() instanceof BlockPlatform) && changeState.method_26207() != class_3614.field_15959) {
                if (!world.field_9236) {
                    camo.setCamoState(changeState);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static enum Variant {
        ABSTRUSE(false, (pos, context) -> {
            if (context instanceof class_3727) {
                class_3727 econtext = (class_3727)context;
                class_1297 e = econtext.method_32480();
                return e == null || e.method_23318() > (double)pos.method_10264() + 0.9 && !context.method_16193();
            }
            return true;
        }),
        SPECTRAL(false, (pos, context) -> false),
        INFRANGIBLE(true, (pos, context) -> true);

        public final boolean indestructible;
        public final BiPredicate<class_2338, class_3726> collide;

        private Variant(boolean i, BiPredicate<class_2338, class_3726> p) {
            this.indestructible = i;
            this.collide = p;
        }
    }
}

