/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2402;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockAltar
extends BlockMod
implements class_2343,
class_2402 {
    public static final class_2754<IPetalApothecary.State> FLUID = class_2754.method_11850((String)"fluid", IPetalApothecary.State.class);
    private static final class_265 BASE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final class_265 PILLAR = class_2248.method_9541((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final class_265 TOP = class_2248.method_9541((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 TOP_CUTOUT = class_2248.method_9541((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 SHAPE = class_259.method_1084((class_265)class_259.method_1084((class_265)BASE, (class_265)PILLAR), (class_265)class_259.method_1072((class_265)TOP, (class_265)TOP_CUTOUT, (class_247)class_247.field_16886));
    public final Variant variant;

    public boolean method_10310(@NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3611 fluid) {
        return state.method_11654(FLUID) == IPetalApothecary.State.EMPTY && fluid == class_3612.field_15910;
    }

    public boolean method_10311(@NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3610 fluidState) {
        if (this.method_10310((class_1922)level, pos, state, fluidState.method_15772())) {
            level.method_8652(pos, (class_2680)state.method_11657(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)), 3);
            return true;
        }
        return false;
    }

    protected BlockAltar(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
        this.method_9590((class_2680)this.method_9564().method_11657(FLUID, (Comparable)((Object)IPetalApothecary.State.EMPTY)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FLUID});
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return SHAPE;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            TileAltar tile = (TileAltar)world.method_8321(pos);
            if (tile.collideEntityItem(itemEntity)) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof TileAltar)) {
            return class_1269.field_5811;
        }
        TileAltar apothecary = (TileAltar)class_25862;
        boolean mainHandEmpty = player.method_6047().method_7960();
        if (apothecary.canAddLastRecipe() && mainHandEmpty) {
            apothecary.trySetLastRecipe(player);
            return class_1269.field_5812;
        }
        if (!apothecary.isEmpty() && mainHandEmpty) {
            InventoryHelper.withdrawFromInventory(apothecary, player);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(apothecary);
            return class_1269.field_5812;
        }
        if (this.tryWithdrawFluid(player, hand, apothecary, pos) || this.tryDepositFluid(player, hand, apothecary, pos)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (world.field_9229.method_43048(20) == 1 && state.method_11654(FLUID) == IPetalApothecary.State.EMPTY) {
            world.method_8501(pos, (class_2680)state.method_11657(FLUID, (Comparable)((Object)IPetalApothecary.State.WATER)));
        }
    }

    private boolean tryWithdrawFluid(class_1657 player, class_1268 hand, TileAltar altar, class_2338 pos) {
        class_3611 fluid = altar.getFluid().asVanilla();
        if (fluid == class_3612.field_15906 || fluid == class_3612.field_15910 && IXplatAbstractions.INSTANCE.gogLoaded()) {
            return false;
        }
        boolean success = IXplatAbstractions.INSTANCE.insertFluidIntoPlayerItem(player, hand, fluid);
        if (success) {
            altar.setFluid(IPetalApothecary.State.EMPTY);
            if (fluid == class_3612.field_15910) {
                player.field_6002.method_8396(player, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
            } else if (fluid == class_3612.field_15908) {
                player.field_6002.method_8396(player, pos, class_3417.field_15202, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return success;
    }

    private boolean tryDepositFluid(class_1657 player, class_1268 hand, TileAltar altar, class_2338 pos) {
        if (altar.getFluid() != IPetalApothecary.State.EMPTY) {
            return false;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (class_3611)class_3612.field_15910)) {
            altar.setFluid(IPetalApothecary.State.WATER);
            player.field_6002.method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        if (IXplatAbstractions.INSTANCE.extractFluidFromPlayerItem(player, hand, (class_3611)class_3612.field_15908)) {
            altar.setFluid(IPetalApothecary.State.LAVA);
            player.field_6002.method_8396(player, pos, class_3417.field_15010, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @NotNull
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new TileAltar(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.field_9236) {
            return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::clientTick);
        }
        return BlockAltar.createTickerHelper(type, ModTiles.ALTAR, TileAltar::serverTick);
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        boolean blockChanged;
        boolean bl = blockChanged = !state.method_27852(newState.method_26204());
        if (blockChanged || newState.method_11654(FLUID) != IPetalApothecary.State.WATER) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)inventory.getItemHandler());
            }
            if (blockChanged) {
                super.method_9536(state, world, pos, newState, isMoving);
            }
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(FLUID) == IPetalApothecary.State.WATER ? 15 : 0;
    }

    public static enum Variant {
        DEFAULT,
        FOREST,
        PLAINS,
        MOUNTAIN,
        FUNGAL,
        SWAMP,
        DESERT,
        TAIGA,
        MESA,
        MOSSY;

    }
}

