/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import java.util.ArrayList;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.tile.RenderTileFloatingFlower;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;

public class RenderTileSpecialFlower<T extends TileEntitySpecialFlower>
implements class_827<T> {
    public RenderTileSpecialFlower(class_5614.class_5615 ctx) {
    }

    public void render(TileEntitySpecialFlower tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        class_1297 class_12972;
        if (tile.isFloating()) {
            RenderTileFloatingFlower.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
        }
        if (!((class_12972 = class_310.method_1551().field_1719) instanceof class_1309)) {
            return;
        }
        class_1309 view = (class_1309)class_12972;
        if (!ItemMonocle.hasMonocle(view)) {
            return;
        }
        class_2338 pos = null;
        class_239 ray = class_310.method_1551().field_1765;
        if (ray != null && ray.method_17783() == class_239.class_240.field_1332) {
            pos = ((class_3965)ray).method_17777();
        }
        if ((hasBindingAttempt = RenderTileSpecialFlower.hasBindingAttempt(view, tile.method_11016())) || tile.method_11016().equals((Object)pos)) {
            TileEntitySpecialFlower flower = tile;
            ms.method_22903();
            if (hasBindingAttempt) {
                ms.method_22904(0.0, 0.005, 0.0);
            }
            RenderTileSpecialFlower.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.method_22904(0.0, 0.002, 0.0);
            RenderTileSpecialFlower.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.method_22909();
        }
    }

    public static void renderRadius(class_2586 tile, class_4587 ms, class_4597 buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.method_22903();
            ms.method_22904((double)(-tile.method_11016().method_10263()), (double)(-tile.method_11016().method_10264()), (double)(-tile.method_11016().method_10260()));
            if (descriptor instanceof RadiusDescriptor.Circle) {
                RadiusDescriptor.Circle circle = (RadiusDescriptor.Circle)descriptor;
                RenderTileSpecialFlower.renderCircle(ms, buffers, circle.subtileCoords(), circle.radius());
            } else if (descriptor instanceof RadiusDescriptor.Rectangle) {
                RadiusDescriptor.Rectangle rectangle = (RadiusDescriptor.Rectangle)descriptor;
                RenderTileSpecialFlower.renderRectangle(ms, buffers, rectangle.aabb(), true, null, (byte)32);
            }
            ms.method_22909();
        }
    }

    public static boolean hasBindingAttempt(class_1309 view, class_2338 tilePos) {
        class_1799 stackHeld = PlayerHelper.getFirstHeldItemClass(view, ItemTwigWand.class);
        if (!stackHeld.method_7960() && ItemTwigWand.getBindMode(stackHeld)) {
            return ItemTwigWand.getBindingAttempt(stackHeld).filter(arg_0 -> ((class_2338)tilePos).equals(arg_0)).isPresent();
        }
        return false;
    }

    private static void renderCircle(class_4587 ms, class_4597 buffers, class_2338 center, double radius) {
        ms.method_22903();
        double x = (double)center.method_10263() + 0.5;
        double y = center.method_10264();
        double z = (double)center.method_10260() + 0.5;
        ms.method_22904(x, y, z);
        int color = class_3532.method_15369((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int alpha = 32;
        float f = 0.0625f;
        int totalAngles = 360;
        int drawAngles = 360;
        int step = totalAngles / drawAngles;
        radius -= (double)f;
        class_4588 buffer = buffers.getBuffer(RenderHelper.CIRCLE);
        class_1159 mat = ms.method_23760().method_23761();
        Runnable centerFunc = () -> buffer.method_22918(mat, 0.0f, f, 0.0f).method_1336(r, g, b, alpha).method_1344();
        ArrayList<Runnable> vertexFuncs = new ArrayList<Runnable>();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.method_22918(mat, xp, f, zp).method_1336(r, g, b, alpha).method_1344());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        radius += (double)f;
        float f1 = f + f / 4.0f;
        int alpha2 = 64;
        centerFunc = () -> buffer.method_22918(mat, 0.0f, f1, 0.0f).method_1336(r, g, b, alpha2).method_1344();
        vertexFuncs.clear();
        for (int i = 0; i < totalAngles + 1; i += step) {
            double rad = (double)(totalAngles - i) * Math.PI / 180.0;
            float xp = (float)(Math.cos(rad) * radius);
            float zp = (float)(Math.sin(rad) * radius);
            vertexFuncs.add(() -> buffer.method_22918(mat, xp, f1, zp).method_1336(r, g, b, alpha2).method_1344());
        }
        RenderHelper.triangleFan(centerFunc, vertexFuncs);
        ms.method_22909();
    }

    public static void renderRectangle(class_4587 ms, class_4597 buffers, class_238 aabb, boolean inner, @Nullable Integer color, byte alpha) {
        ms.method_22903();
        ms.method_22904(aabb.field_1323, aabb.field_1322, aabb.field_1321);
        if (color == null) {
            color = class_3532.method_15369((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float f = 0.0625f;
        float x = (float)(aabb.field_1320 - aabb.field_1323 - (double)f);
        float z = (float)(aabb.field_1324 - aabb.field_1321 - (double)f);
        class_4588 buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        class_1159 mat = ms.method_23760().method_23761();
        buffer.method_22918(mat, x, f, f).method_1336(r, g, b, (int)alpha).method_1344();
        buffer.method_22918(mat, f, f, f).method_1336(r, g, b, (int)alpha).method_1344();
        buffer.method_22918(mat, f, f, z).method_1336(r, g, b, (int)alpha).method_1344();
        buffer.method_22918(mat, x, f, z).method_1336(r, g, b, (int)alpha).method_1344();
        if (inner) {
            float f1 = f + f / 4.0f;
            alpha = (byte)(alpha * 2);
            buffer.method_22918(mat, x += f, f1, 0.0f).method_1336(r, g, b, (int)alpha).method_1344();
            buffer.method_22918(mat, 0.0f, f1, 0.0f).method_1336(r, g, b, (int)alpha).method_1344();
            buffer.method_22918(mat, 0.0f, f1, z += f).method_1336(r, g, b, (int)alpha).method_1344();
            buffer.method_22918(mat, x, f1, z).method_1336(r, g, b, (int)alpha).method_1344();
        }
        ms.method_22909();
    }
}

