/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ManaInfusionProcessor
implements IComponentProcessor {
    private List<IManaInfusionRecipe> recipes;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider variables) {
        if (variables.has("recipes") && variables.has("group")) {
            BotaniaAPI.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (variables.has("group")) {
            String group = variables.get("group").asString();
            builder.addAll(PatchouliUtils.getRecipeGroup(ModRecipeTypes.MANA_INFUSION_TYPE, group));
        } else {
            for (IVariable s : variables.get("recipes").asListOrSingleton()) {
                IManaInfusionRecipe recipe = PatchouliUtils.getRecipe(ModRecipeTypes.MANA_INFUSION_TYPE, new class_2960(s.asString()));
                if (recipe == null) continue;
                builder.add((Object)recipe);
            }
        }
        this.recipes = builder.build();
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        switch (key) {
            case "heading": {
                if (!this.hasCustomHeading) {
                    return IVariable.from((Object)this.recipes.get(0).method_8110().method_7964());
                }
                return null;
            }
            case "input": {
                return PatchouliUtils.interweaveIngredients(this.recipes.stream().map(r -> (class_1856)r.method_8117().get(0)).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(IManaInfusionRecipe::method_8110).map(IVariable::from).collect(Collectors.toList()));
            }
            case "catalyst": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(IManaInfusionRecipe::getRecipeCatalyst).flatMap(ingr -> {
                    if (ingr == null) {
                        return Stream.of(class_1799.field_8037);
                    }
                    return ingr.getDisplayedStacks().stream();
                }).map(IVariable::from).collect(Collectors.toList()));
            }
            case "mana": {
                return IVariable.wrapList((Iterable)this.recipes.stream().mapToInt(IManaInfusionRecipe::getManaToConsume).mapToObj(IVariable::wrap).collect(Collectors.toList()));
            }
            case "drop": {
                class_5250 q = class_2561.method_43470((String)"(?)").method_27692(class_124.field_1067);
                return IVariable.from((Object)class_2561.method_43471((String)"botaniamisc.drop").method_27693(" ").method_10852((class_2561)q));
            }
            case "dropTip0": 
            case "dropTip1": {
                class_5250 drop = class_2561.method_43472((String)"key.drop").method_27692(class_124.field_1060);
                return IVariable.from((Object)class_2561.method_43469((String)("botaniamisc." + key), (Object[])new Object[]{drop}));
            }
        }
        return null;
    }
}

