/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IClientXplatAbstractions;
import vazkii.botania.xplat.IXplatAbstractions;

public final class HUDHandler {
    public static final class_2960 manaBar = new class_2960("botania:textures/gui/mana_hud.png");

    private HUDHandler() {
    }

    public static void onDrawScreenPost(class_4587 ms, float partialTicks) {
        class_239 pos;
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842) {
            return;
        }
        class_3695 profiler = mc.method_16011();
        class_1799 main = mc.field_1724.method_6047();
        class_1799 offhand = mc.field_1724.method_6079();
        profiler.method_15396("botania-hud");
        if (class_310.method_1551().field_1761.method_2908()) {
            class_1799 dodgeRing;
            class_1799 tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (class_1309)mc.field_1724);
            if (!tiara.method_7960()) {
                profiler.method_15396("flugelTiara");
                ItemFlightTiara.ClientLogic.renderHUD(ms, (class_1657)mc.field_1724, tiara);
                profiler.method_15407();
            }
            if (!(dodgeRing = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, (class_1309)mc.field_1724)).method_7960()) {
                profiler.method_15396("dodgeRing");
                ItemDodgeRing.ClientLogic.renderHUD(ms, (class_1657)mc.field_1724, dodgeRing, partialTicks);
                profiler.method_15407();
            }
        }
        if ((pos = mc.field_1765) instanceof class_3965) {
            class_3965 result = (class_3965)pos;
            class_2338 bpos = result.method_17777();
            class_2680 state = mc.field_1687.method_8320(bpos);
            class_2586 tile = mc.field_1687.method_8321(bpos);
            if (PlayerHelper.hasAnyHeldItem((class_1657)mc.field_1724)) {
                IWandHUD hud;
                if (PlayerHelper.hasHeldItemClass((class_1657)mc.field_1724, ItemTwigWand.class) && (hud = IClientXplatAbstractions.INSTANCE.findWandHud((class_1937)mc.field_1687, bpos, state, tile)) != null) {
                    profiler.method_15396("wandItem");
                    hud.renderHUD(ms, mc);
                    profiler.method_15407();
                }
                if (tile instanceof TilePool) {
                    TilePool pool = (TilePool)tile;
                    if (!mc.field_1724.method_6047().method_7960()) {
                        HUDHandler.renderPoolRecipeHUD(ms, pool, mc.field_1724.method_6047());
                    }
                }
            }
            if (!PlayerHelper.hasHeldItem((class_1657)mc.field_1724, ModItems.lexicon)) {
                if (tile instanceof TileAltar) {
                    TileAltar altar = (TileAltar)tile;
                    TileAltar.Hud.render(altar, ms, mc);
                } else if (tile instanceof TileRuneAltar) {
                    TileRuneAltar runeAltar = (TileRuneAltar)tile;
                    TileRuneAltar.Hud.render(runeAltar, ms, mc);
                } else if (tile instanceof TileCorporeaCrystalCube) {
                    TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube)tile;
                    HUDHandler.renderCrystalCubeHUD(ms, cube);
                }
            }
        }
        if (!TileCorporeaIndex.getNearbyValidIndexes((class_1657)mc.field_1724).isEmpty() && mc.field_1755 instanceof class_408) {
            profiler.method_15396("nearIndex");
            HUDHandler.renderNearIndexDisplay(ms);
            profiler.method_15407();
        }
        if (!main.method_7960() && main.method_7909() instanceof ItemCraftingHalo) {
            profiler.method_15396("craftingHalo_main");
            ItemCraftingHalo.Rendering.renderHUD(ms, (class_1657)mc.field_1724, main);
            profiler.method_15407();
        } else if (!offhand.method_7960() && offhand.method_7909() instanceof ItemCraftingHalo) {
            profiler.method_15396("craftingHalo_off");
            ItemCraftingHalo.Rendering.renderHUD(ms, (class_1657)mc.field_1724, offhand);
            profiler.method_15407();
        }
        if (!main.method_7960() && main.method_7909() instanceof ItemSextant) {
            profiler.method_15396("sextant");
            ItemSextant.Hud.render(ms, (class_1657)mc.field_1724, main);
            profiler.method_15407();
        }
        if (ItemMonocle.hasMonocle((class_1309)mc.field_1724)) {
            profiler.method_15396("monocle");
            ItemMonocle.Hud.render(ms, (class_1657)mc.field_1724);
            profiler.method_15407();
        }
        profiler.method_15396("manaBar");
        class_746 player = mc.field_1724;
        if (!player.method_7325()) {
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            class_1661 mainInv = player.method_31548();
            class_1263 accInv = BotaniaAPI.instance().getAccessoriesInventory((class_1657)player);
            int invSize = mainInv.method_5439();
            int size = invSize + accInv.method_5439();
            for (int i = 0; i < size; ++i) {
                boolean useAccessories = i >= invSize;
                Object inv = useAccessories ? accInv : mainInv;
                class_1799 stack = inv.method_5438(i - (useAccessories ? invSize : 0));
                if (stack.method_7960()) continue;
                anyRequest = anyRequest || stack.method_31573(ModTags.Items.MANA_USING_ITEMS);
            }
            List<class_1799> items = ManaItemHandler.instance().getManaItems((class_1657)player);
            List<class_1799> acc = ManaItemHandler.instance().getManaAccesories((class_1657)player);
            for (class_1799 stack : Iterables.concat(items, acc)) {
                IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
                if (manaItem.isNoExport()) continue;
                totalMana += manaItem.getMana();
                totalMaxMana += manaItem.getMaxMana();
            }
            if (anyRequest) {
                HUDHandler.renderManaInvBar(ms, totalMana, totalMaxMana);
            }
        }
        profiler.method_15405("itemsRemaining");
        ItemsRemainingRenderHandler.render(ms, partialTicks);
        profiler.method_15407();
        profiler.method_15407();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderManaInvBar(class_4587 ms, int totalMana, int totalMaxMana) {
        class_310 mc = class_310.method_1551();
        int width = 182;
        int x = mc.method_22683().method_4486() / 2 - width / 2;
        int y = mc.method_22683().method_4502() - BotaniaConfig.client().manaBarHeight();
        width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = class_3532.method_15369((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)class_156.method_658() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)manaBar);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 251, width, 5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(class_4587 ms, TilePool tile, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("poolRecipe");
        IManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.method_10997().method_8320(tile.method_11016().method_10074()));
        if (recipe != null) {
            int x = mc.method_22683().method_4486() / 2 - 11;
            int y = mc.method_22683().method_4502() / 2 + 10;
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.field_1724.method_5477().getString().equals("haighyorkie") && mc.field_1724.method_5715() ? 23 : 8;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderTexture((int)0, (class_2960)manaBar);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.method_1480().method_4023(stack, x - 20, y);
            mc.method_1480().method_4023(recipe.method_8110(), x + 26, y);
            mc.method_1480().method_4025(mc.field_1772, recipe.method_8110(), x + 26, y);
            RenderSystem.disableBlend();
        }
        profiler.method_15407();
    }

    private static void renderCrystalCubeHUD(class_4587 ms, TileCorporeaCrystalCube tile) {
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("crystalCube");
        class_1799 target = tile.getRequestTarget();
        if (!target.method_7960()) {
            String s1 = target.method_7964().getString();
            String s2 = tile.getItemCount() + "x";
            int strlen = Math.max(mc.field_1772.method_1727(s1), mc.field_1772.method_1727(s2));
            int w = mc.method_22683().method_4486();
            int h = mc.method_22683().method_4502();
            int boxH = h / 2 + (tile.locked ? 20 : 10);
            class_332.method_25294((class_4587)ms, (int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)boxH, (int)0x44000000);
            class_332.method_25294((class_4587)ms, (int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(boxH + 2), (int)0x44000000);
            mc.field_1772.method_1720(ms, s1, (float)(w / 2 + 30), (float)(h / 2 - 10), 0x6666FF);
            mc.field_1772.method_1720(ms, tile.getItemCount() + "x", (float)(w / 2 + 30), (float)(h / 2), 0xFFFFFF);
            if (tile.locked) {
                mc.field_1772.method_1720(ms, class_1074.method_4662((String)"botaniamisc.locked", (Object[])new Object[0]), (float)(w / 2 + 30), (float)(h / 2 + 10), 0xFFAA00);
            }
            mc.method_1480().method_4023(target, w / 2 + 10, h / 2 - 10);
        }
        profiler.method_15407();
    }

    private static void renderNearIndexDisplay(class_4587 ms) {
        class_310 mc = class_310.method_1551();
        String txt0 = class_1074.method_4662((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = class_124.field_1080 + class_1074.method_4662((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = class_124.field_1080 + class_1074.method_4662((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.field_1772.method_1727(txt0), Math.max(mc.field_1772.method_1727(txt1), mc.field_1772.method_1727(txt2))) + 20;
        int x = mc.method_22683().method_4486() - l - 20;
        int y = mc.method_22683().method_4502() - 60;
        class_332.method_25294((class_4587)ms, (int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x44000000);
        class_332.method_25294((class_4587)ms, (int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x44000000);
        mc.method_1480().method_4023(new class_1799((class_1935)ModBlocks.corporeaIndex), x, y + 10);
        mc.field_1772.method_1720(ms, txt0, (float)(x + 20), (float)y, 0xFFFFFF);
        mc.field_1772.method_1720(ms, txt1, (float)(x + 20), (float)(y + 14), 0xFFFFFF);
        mc.field_1772.method_1720(ms, txt2, (float)(x + 20), (float)(y + 24), 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(class_4587 ms, int color, int mana, int maxMana, String name) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        class_310 mc = class_310.method_1551();
        int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(name) / 2;
        int y = mc.method_22683().method_4502() / 2 + 10;
        mc.field_1772.method_1720(ms, name, (float)x, (float)y, color);
        x = mc.method_22683().method_4486() / 2 - 51;
        HUDHandler.renderManaBar(ms, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.disableBlend();
    }

    public static void drawComplexManaHUD(int color, class_4587 ms, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {
        HUDHandler.drawSimpleManaHUD(ms, color, mana, maxMana, name);
        class_310 mc = class_310.method_1551();
        int x = mc.method_22683().method_4486() / 2 + 55;
        int y = mc.method_22683().method_4502() / 2 + 12;
        mc.method_1480().method_4023(bindDisplay, x, y);
        RenderSystem.disableDepthTest();
        ms.method_22903();
        ms.method_22904(0.0, 0.0, (double)(mc.method_1480().field_4730 + 50.0f + 200.0f + 1.0f));
        if (properlyBound) {
            mc.field_1772.method_1720(ms, "\u2714", (float)(x + 10), (float)(y + 9), 19456);
            mc.field_1772.method_1720(ms, "\u2714", (float)(x + 10), (float)(y + 8), 774669);
        } else {
            mc.field_1772.method_1720(ms, "\u2718", (float)(x + 10), (float)(y + 9), 0x4C0000);
            mc.field_1772.method_1720(ms, "\u2718", (float)(x + 10), (float)(y + 8), 13764621);
        }
        ms.method_22909();
        RenderSystem.enableDepthTest();
    }

    public static void renderManaBar(class_4587 ms, int x, int y, int color, float alpha, int mana, int maxMana) {
        class_310 mc = class_310.method_1551();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)manaBar);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

