/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1162;
import net.minecraft.class_243;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BoltParticleOptions {
    private final BoltRenderInfo renderInfo;
    private final class_243 start;
    private final class_243 end;
    private final int segments;
    private final int count;
    private final float size;
    private final int lifespan;
    private final SpawnFunction spawnFunction;
    private final FadeFunction fadeFunction;

    public BoltParticleOptions(class_243 start, class_243 end) {
        this(BoltRenderInfo.DEFAULT, start, end);
    }

    public BoltParticleOptions(BoltRenderInfo info, class_243 start, class_243 end) {
        this(info, start, end, (int)Math.sqrt(start.method_1022(end) * 100.0));
    }

    public BoltParticleOptions(BoltRenderInfo info, class_243 start, class_243 end, int segments) {
        this(info, start, end, segments, 1, 0.1f, 30, SpawnFunction.delay(60.0f), FadeFunction.fade(0.5f));
    }

    public BoltParticleOptions(BoltRenderInfo info, class_243 start, class_243 end, int segments, int count, float size, int lifespan, SpawnFunction spawnFunction, FadeFunction fadeFunction) {
        this.renderInfo = info;
        this.start = start;
        this.end = end;
        this.segments = segments;
        this.count = count;
        this.size = size;
        this.lifespan = lifespan;
        this.spawnFunction = spawnFunction;
        this.fadeFunction = fadeFunction;
    }

    public BoltParticleOptions count(int count) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, count, this.size, this.lifespan, this.spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions size(float size) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, size, this.lifespan, this.spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions spawn(SpawnFunction spawnFunction) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, this.lifespan, spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions fade(FadeFunction fadeFunction) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, this.lifespan, this.spawnFunction, fadeFunction);
    }

    public BoltParticleOptions lifespan(int lifespan) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, lifespan, this.spawnFunction, this.fadeFunction);
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public SpawnFunction getSpawnFunction() {
        return this.spawnFunction;
    }

    public FadeFunction getFadeFunction() {
        return this.fadeFunction;
    }

    public class_1162 getColor() {
        return this.renderInfo.color;
    }

    public List<BoltQuads> generate() {
        Random random = new Random();
        ArrayList<BoltQuads> quads = new ArrayList<BoltQuads>();
        class_243 diff = this.end.method_1020(this.start);
        float totalDistance = (float)diff.method_1033();
        block0: for (int i = 0; i < this.count; ++i) {
            ArrayDeque<BoltInstructions> drawQueue = new ArrayDeque<BoltInstructions>();
            drawQueue.add(new BoltInstructions(this.start, 0.0f, class_243.field_1353, null, false));
            while (!drawQueue.isEmpty()) {
                class_243 segmentEnd;
                BoltInstructions data = (BoltInstructions)drawQueue.poll();
                class_243 perpendicularDist = data.perpendicularDist();
                float progress = data.progress() + 1.0f / (float)this.segments * (1.0f - this.renderInfo.parallelNoise + random.nextFloat() * this.renderInfo.parallelNoise * 2.0f);
                float segmentDiffScale = this.renderInfo.spreadFunction.getMaxSpread(progress);
                if (progress >= 1.0f && segmentDiffScale <= 0.0f) {
                    segmentEnd = this.end;
                } else {
                    float maxDiff = this.renderInfo.spreadFactor * segmentDiffScale * totalDistance;
                    class_243 randVec = BoltParticleOptions.findRandomOrthogonalVector(diff, random);
                    double rand = this.renderInfo.randomFunction.getRandom(random);
                    perpendicularDist = this.renderInfo.segmentSpreader.getSegmentAdd(perpendicularDist, randVec, maxDiff, segmentDiffScale, progress, rand);
                    segmentEnd = this.start.method_1019(diff.method_1021((double)progress)).method_1019(perpendicularDist);
                }
                float boltSize = this.size * (0.5f + (1.0f - progress) * 0.5f);
                Pair<BoltQuads, QuadCache> quadData = this.createQuads(data.cache(), data.start(), segmentEnd, boltSize);
                quads.add((BoltQuads)quadData.getLeft());
                if (progress >= 1.0f) continue block0;
                if (!data.isBranch()) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), false));
                } else if (random.nextFloat() < this.renderInfo.branchContinuationFactor) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
                while (random.nextFloat() < this.renderInfo.branchInitiationFactor * (1.0f - progress)) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
            }
        }
        return quads;
    }

    private static class_243 findRandomOrthogonalVector(class_243 vec, Random rand) {
        class_243 newVec = new class_243(-0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
        return vec.method_1036(newVec).method_1029();
    }

    private Pair<BoltQuads, QuadCache> createQuads(@Nullable QuadCache cache, class_243 startPos, class_243 end, float size) {
        class_243 diff = end.method_1020(startPos);
        class_243 rightAdd = diff.method_1036(new class_243(0.5, 0.5, 0.5)).method_1029().method_1021((double)size);
        class_243 backAdd = diff.method_1036(rightAdd).method_1029().method_1021((double)size);
        class_243 rightAddSplit = rightAdd.method_1021(0.5);
        class_243 start = cache != null ? cache.prevEnd() : startPos;
        class_243 startRight = cache != null ? cache.prevEndRight() : start.method_1019(rightAdd);
        class_243 startBack = cache != null ? cache.prevEndBack() : start.method_1019(rightAddSplit).method_1019(backAdd);
        class_243 endRight = end.method_1019(rightAdd);
        class_243 endBack = end.method_1019(rightAddSplit).method_1019(backAdd);
        BoltQuads quads = new BoltQuads();
        quads.addQuad(start, end, endRight, startRight);
        quads.addQuad(startRight, endRight, end, start);
        quads.addQuad(startRight, endRight, endBack, startBack);
        quads.addQuad(startBack, endBack, endRight, startRight);
        return Pair.of((Object)quads, (Object)new QuadCache(end, endRight, endBack));
    }

    public static class BoltRenderInfo {
        public static final BoltRenderInfo DEFAULT = BoltRenderInfo.defaultConfig();
        private final float parallelNoise;
        private final float spreadFactor;
        private final float branchInitiationFactor;
        private final float branchContinuationFactor;
        private final class_1162 color;
        private final RandomFunction randomFunction;
        private final SpreadFunction spreadFunction;
        private final SegmentSpreader segmentSpreader;

        private BoltRenderInfo(float parallelNoise, float spreadFactor, float branchInitiationFactor, float branchContinuationFactor, class_1162 color, RandomFunction randomFunction, SpreadFunction spreadFunction, SegmentSpreader segmentSpreader) {
            this.parallelNoise = parallelNoise;
            this.spreadFactor = spreadFactor;
            this.branchInitiationFactor = branchInitiationFactor;
            this.branchContinuationFactor = branchContinuationFactor;
            this.color = color;
            this.randomFunction = randomFunction;
            this.spreadFunction = spreadFunction;
            this.segmentSpreader = segmentSpreader;
        }

        private static BoltRenderInfo defaultConfig() {
            return new BoltRenderInfo(0.1f, 0.1f, 0.0f, 0.0f, new class_1162(0.0f, 0.7764f, 1.0f, 0.8f), RandomFunction.GAUSSIAN, SpreadFunction.SINE, SegmentSpreader.NO_MEMORY);
        }

        public BoltRenderInfo noise(float parallelNoise, float spreadFactor) {
            return new BoltRenderInfo(parallelNoise, spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo branching(float branchInitiationFactor, float branchContinuationFactor) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, branchInitiationFactor, branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo spreader(SegmentSpreader segmentSpreader) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, segmentSpreader);
        }

        public BoltRenderInfo randomFunction(RandomFunction randomFunction) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo spreadFunction(SpreadFunction spreadFunction) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo color(class_1162 color) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }
    }

    public static interface SpawnFunction {
        public static final SpawnFunction NO_DELAY = rand -> Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        public static final SpawnFunction CONSECUTIVE = new SpawnFunction(){

            @Override
            public Pair<Float, Float> getSpawnDelayBounds(Random rand) {
                return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }

            @Override
            public boolean isConsecutive() {
                return true;
            }
        };

        public static SpawnFunction delay(float delay) {
            return rand -> Pair.of((Object)Float.valueOf(delay), (Object)Float.valueOf(delay));
        }

        public static SpawnFunction noise(float delay, float noise) {
            return rand -> Pair.of((Object)Float.valueOf(delay - noise), (Object)Float.valueOf(delay + noise));
        }

        public Pair<Float, Float> getSpawnDelayBounds(Random var1);

        default public float getSpawnDelay(Random rand) {
            Pair<Float, Float> bounds = this.getSpawnDelayBounds(rand);
            return ((Float)bounds.getLeft()).floatValue() + (((Float)bounds.getRight()).floatValue() - ((Float)bounds.getLeft()).floatValue()) * rand.nextFloat();
        }

        default public boolean isConsecutive() {
            return false;
        }
    }

    public static interface FadeFunction {
        public static final FadeFunction NONE = (totalBolts, lifeScale) -> Pair.of((Object)0, (Object)totalBolts);

        public static FadeFunction fade(float fade) {
            return (totalBolts, lifeScale) -> {
                int start = lifeScale > 1.0f - fade ? (int)((float)totalBolts * (lifeScale - (1.0f - fade)) / fade) : 0;
                int end = lifeScale < fade ? (int)((float)totalBolts * (lifeScale / fade)) : totalBolts;
                return Pair.of((Object)start, (Object)end);
            };
        }

        public Pair<Integer, Integer> getRenderBounds(int var1, float var2);
    }

    private record BoltInstructions(class_243 start, float progress, class_243 perpendicularDist, @Nullable QuadCache cache, boolean isBranch) {
    }

    private record QuadCache(class_243 prevEnd, class_243 prevEndRight, class_243 prevEndBack) {
    }

    public static interface SpreadFunction {
        public static final SpreadFunction LINEAR_ASCENT = progress -> progress;
        public static final SpreadFunction LINEAR_ASCENT_DESCENT = progress -> (progress - Math.max(0.0f, 2.0f * progress - 1.0f)) / 0.5f;
        public static final SpreadFunction SINE = progress -> (float)Math.sin(Math.PI * (double)progress);

        public float getMaxSpread(float var1);
    }

    public static interface RandomFunction {
        public static final RandomFunction UNIFORM = Random::nextFloat;
        public static final RandomFunction GAUSSIAN = rand -> (float)rand.nextGaussian();

        public float getRandom(Random var1);
    }

    public static interface SegmentSpreader {
        public static final SegmentSpreader NO_MEMORY = (perpendicularDist, randVec, maxDiff, scale, progress, rand) -> randVec.method_1021((double)maxDiff * rand);

        public static SegmentSpreader memory(float memoryFactor) {
            return (perpendicularDist, randVec, maxDiff, spreadScale, progress, rand) -> {
                double nextDiff = (double)(maxDiff * (1.0f - memoryFactor)) * rand;
                class_243 cur = randVec.method_1021(nextDiff);
                double length = (perpendicularDist = perpendicularDist.method_1019(cur)).method_1033();
                if (length > (double)maxDiff) {
                    perpendicularDist = perpendicularDist.method_1021((double)maxDiff / length);
                }
                return perpendicularDist.method_1019(cur);
            };
        }

        public class_243 getSegmentAdd(class_243 var1, class_243 var2, float var3, float var4, float var5, double var6);
    }

    public static class BoltQuads {
        private final List<class_243> vecs = new ArrayList<class_243>();

        protected void addQuad(class_243 ... quadVecs) {
            this.vecs.addAll(Arrays.asList(quadVecs));
        }

        public List<class_243> getVecs() {
            return this.vecs;
        }
    }
}

