/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_840;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.DelegatedVertexConsumer;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.mixin.client.AccessorItemRenderer;
import vazkii.botania.mixin.client.AccessorRenderType;

public final class RenderHelper
extends class_1921 {
    private static final class_1921 STAR;
    public static final class_1921 RECTANGLE;
    public static final class_1921 CIRCLE;
    public static final class_1921 RED_STRING;
    public static final class_1921 LINE_1_NO_DEPTH;
    public static final class_1921 LINE_4_NO_DEPTH;
    public static final class_1921 LINE_5_NO_DEPTH;
    public static final class_1921 LINE_8_NO_DEPTH;
    public static final class_1921 SPARK;
    public static final class_1921 LIGHT_RELAY;
    public static final class_1921 ICON_OVERLAY;
    public static final class_1921 BABYLON_ICON;
    public static final class_1921 MANA_POOL_WATER;
    public static final class_1921 TERRA_PLATE;
    public static final class_1921 ENCHANTER;
    public static final class_1921 HALO;
    public static final class_1921 MANA_PYLON_GLOW;
    public static final class_1921 NATURA_PYLON_GLOW;
    public static final class_1921 GAIA_PYLON_GLOW;
    public static final class_1921 MANA_PYLON_GLOW_DIRECT;
    public static final class_1921 NATURA_PYLON_GLOW_DIRECT;
    public static final class_1921 GAIA_PYLON_GLOW_DIRECT;
    public static final class_1921 ASTROLABE_PREVIEW;
    public static final class_1921 STARFIELD;
    public static final class_1921 LIGHTNING;
    private static final Function<class_2960, class_1921> DOPPLEGANGER;

    private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode, int bufSize, boolean hasCrumbling, boolean sortOnUpload, class_1921.class_4688 glState) {
        return AccessorRenderType.create(name, format, mode, bufSize, hasCrumbling, sortOnUpload, glState);
    }

    private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode, int bufSize, class_1921.class_4688 glState) {
        return RenderHelper.makeLayer(name, format, mode, bufSize, false, false, glState);
    }

    private RenderHelper(String string, class_293 vertexFormat, class_293.class_5596 mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
        throw new UnsupportedOperationException("Should not be instantiated");
    }

    private static class_1921 getPylonGlowDirect(String name, class_2960 texture) {
        return RenderHelper.getPylonGlow(name, texture, true);
    }

    private static class_1921 getPylonGlow(String name, class_2960 texture) {
        return RenderHelper.getPylonGlow(name, texture, false);
    }

    private static class_1921 getPylonGlow(String name, class_2960 texture, boolean direct) {
        class_1921.class_4688.class_4689 glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::pylon)).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385);
        if (!direct) {
            glState = glState.method_23610(class_4668.field_25643);
        }
        return RenderHelper.makeLayer("botania:" + name, class_290.field_1580, class_293.class_5596.field_27382, 128, glState.method_23617(false));
    }

    private static class_1921.class_4688 lineState(double width, boolean direct, boolean noDepth) {
        class_1921.class_4688.class_4689 builder = class_1921.class_4688.method_23598().method_34578(field_29433).method_23609(new class_4668.class_4677(OptionalDouble.of(width))).method_23607(field_22241).method_23615(field_21370).method_23616(noDepth ? field_21350 : field_21349).method_23603(field_21345);
        if (!direct) {
            builder = builder.method_23610(field_25643);
        }
        if (noDepth) {
            builder = builder.method_23604(field_21346);
        }
        return builder.method_23617(false);
    }

    public static class_1921 getHaloLayer(class_2960 texture) {
        class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(class_4668.field_29439).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, true, false)).method_23603(new class_4668.class_4671(false)).method_23615(field_21370).method_23617(false);
        return RenderHelper.makeLayer("botania:crafting_halo", class_290.field_20887, class_293.class_5596.field_27382, 64, false, true, glState);
    }

    public static class_1921 getDopplegangerLayer(class_2960 texture) {
        return DOPPLEGANGER.apply(texture);
    }

    public static void drawTexturedModalRect(class_4587 ms, int x, int y, int u, int v, int width, int height) {
        class_332.method_25290((class_4587)ms, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)256, (int)256);
    }

    public static void renderStar(class_4587 ms, class_4597 buffers, int color, float xScale, float yScale, float zScale, long seed) {
        class_4588 buffer = buffers.getBuffer(STAR);
        float semiPeriodTicks = 200.0f;
        float ticks = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
        float f1 = class_3532.method_15379((float)class_3532.method_15374((float)((float)Math.PI / semiPeriodTicks * ticks))) * 0.9f + 0.1f;
        float f2 = f1 > 0.0f ? (f1 - 0.7f) / 0.2f : 0.0f;
        Random random = new Random(seed);
        ms.method_22903();
        ms.method_22905(xScale, yScale, zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360.0f));
            ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360.0f));
            ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360.0f));
            ms.method_22907(class_1160.field_20703.method_23214(random.nextFloat() * 360.0f));
            ms.method_22907(class_1160.field_20705.method_23214(random.nextFloat() * 360.0f));
            ms.method_22907(class_1160.field_20707.method_23214(random.nextFloat() * 360.0f + f1 * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            class_1159 mat = ms.method_23760().method_23761();
            Runnable center = () -> buffer.method_22918(mat, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, f1).method_1344();
            Runnable[] vertices = new Runnable[]{() -> buffer.method_22918(mat, -0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, 0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, 0.0f, f3, 1.0f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, -0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344()};
            RenderHelper.triangleFan(center, vertices);
            ++i;
        }
        ms.method_22909();
    }

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderHelper.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void renderProgressPie(class_4587 ms, int x, int y, float progress, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        mc.method_1480().method_4023(stack, x, y);
        RenderSystem.clear((int)256, (boolean)true);
        GL11.glEnable((int)2960);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        mc.method_1480().method_4023(stack, x, y);
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        int degs = (int)(360.0f * progress);
        float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10.0) * 0.5f + 0.5f);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        class_1159 mat = ms.method_23760().method_23761();
        class_287 buf = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        buf.method_22918(mat, (float)centerX, (float)centerY, 0.0f).method_22915(0.0f, 0.5f, 0.5f, a).method_1344();
        for (int i = degs; i > 0; --i) {
            float rad = (float)(i - 90) / 180.0f * (float)Math.PI;
            buf.method_22918(mat, (float)centerX + class_3532.method_15362((float)rad) * (float)r, (float)centerY + class_3532.method_15374((float)rad) * (float)r, 0.0f).method_22915(0.0f, 1.0f, 0.5f, a).method_1344();
        }
        buf.method_22918(mat, (float)centerX, (float)centerY, 0.0f).method_22915(0.0f, 1.0f, 0.5f, a).method_1344();
        class_289.method_1348().method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        GL11.glDisable((int)2960);
    }

    public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay, @Nullable class_1087 model) {
        ms.method_22903();
        if (model == null) {
            model = class_310.method_1551().method_1480().method_4019(stack, entity.field_6002, entity, entity.method_5628());
        }
        model.method_4709().method_3503(class_809.class_811.field_4315).method_23075(false, ms);
        ms.method_22904(-0.5, -0.5, -0.5);
        if (!model.method_4713() && !stack.method_31574(class_1802.field_8547)) {
            class_1921 rendertype = class_4696.method_23678((class_1799)stack, (boolean)true);
            class_4588 ivertexbuilder = class_918.method_29711((class_4597)buffers, (class_1921)rendertype, (boolean)true, (boolean)stack.method_7958());
            RenderHelper.renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
        }
        ms.method_22909();
    }

    public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay) {
        RenderHelper.renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
    }

    private static void renderBakedItemModel(class_1087 model, class_1799 stack, int color, int light, int overlay, class_4587 ms, class_4588 buffer) {
        class_5819 random = class_5819.method_43047();
        long i = 42L;
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(42L);
            RenderHelper.renderBakedItemQuads(ms, buffer, color, model.method_4707(null, direction, random), stack, light, overlay);
        }
        random.method_43052(42L);
        RenderHelper.renderBakedItemQuads(ms, buffer, color, model.method_4707(null, null, random), stack, light, overlay);
    }

    private static void renderBakedItemQuads(class_4587 ms, class_4588 buffer, int color, List<class_777> quads, class_1799 stack, int light, int overlay) {
        final float a = (float)(color >> 24 & 0xFF) / 255.0f;
        final float r = (float)(color >> 16 & 0xFF) / 255.0f;
        final float g = (float)(color >> 8 & 0xFF) / 255.0f;
        final float b = (float)(color & 0xFF) / 255.0f;
        buffer = new DelegatedVertexConsumer(buffer){

            public class_4588 method_22915(float red, float green, float blue, float alpha) {
                return super.method_22915(r, g, b, a);
            }
        };
        ((AccessorItemRenderer)class_310.method_1551().method_1480()).callRenderQuadList(ms, buffer, quads, stack, light, overlay);
    }

    public static void renderIcon(class_4587 ms, class_4588 buffer, int x, int y, class_1058 icon, int width, int height, float alpha) {
        class_1159 mat = ms.method_23760().method_23761();
        int fullbright = 0xF000F0;
        buffer.method_22918(mat, (float)x, (float)(y + height), 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(icon.method_4594(), icon.method_4575()).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, (float)(x + width), (float)(y + height), 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(icon.method_4577(), icon.method_4575()).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, (float)(x + width), (float)y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(icon.method_4577(), icon.method_4593()).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, (float)x, (float)y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(icon.method_4594(), icon.method_4593()).method_22916(fullbright).method_1344();
    }

    static {
        MANA_PYLON_GLOW = RenderHelper.getPylonGlow("mana_pylon_glow", RenderTilePylon.MANA_TEXTURE);
        NATURA_PYLON_GLOW = RenderHelper.getPylonGlow("natura_pylon_glow", RenderTilePylon.NATURA_TEXTURE);
        GAIA_PYLON_GLOW = RenderHelper.getPylonGlow("gaia_pylon_glow", RenderTilePylon.GAIA_TEXTURE);
        MANA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("mana_pylon_glow_direct", RenderTilePylon.MANA_TEXTURE);
        NATURA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("natura_pylon_glow_direct", RenderTilePylon.NATURA_TEXTURE);
        GAIA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("gaia_pylon_glow_direct", RenderTilePylon.GAIA_TEXTURE);
        ASTROLABE_PREVIEW = new AstrolabeLayer();
        class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23616(field_21350).method_23615(class_4668.field_21367).method_23617(false);
        STAR = RenderHelper.makeLayer("botania:star", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);
        glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21370).method_23610(field_25643).method_23603(field_21345).method_23617(false);
        RECTANGLE = RenderHelper.makeLayer("botania:rectangle_highlight", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
        CIRCLE = RenderHelper.makeLayer("botania:circle_highlight", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);
        RED_STRING = RenderHelper.makeLayer("botania:red_string", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(1.0, false, false));
        LINE_1_NO_DEPTH = RenderHelper.makeLayer("botania:line_1_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(1.0, true, true));
        LINE_4_NO_DEPTH = RenderHelper.makeLayer("botania:line_4_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(4.0, true, true));
        LINE_5_NO_DEPTH = RenderHelper.makeLayer("botania:line_5_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, RenderHelper.lineState(5.0, true, true));
        LINE_8_NO_DEPTH = RenderHelper.makeLayer("botania:line_8_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, RenderHelper.lineState(8.0, true, true));
        glState = class_1921.class_4688.method_23598().method_34578(field_29441).method_34577((class_4668.class_5939)class_4668.field_21376).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(true);
        SPARK = RenderHelper.makeLayer("botania:spark", class_290.field_20888, class_293.class_5596.field_27382, 256, glState);
        glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::halo)).method_34577((class_4668.class_5939)class_4668.field_21376).method_23615(field_21370).method_23610(field_25643).method_23617(true);
        LIGHT_RELAY = RenderHelper.makeLayer("botania:light_relay", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(field_29441).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(true);
        ICON_OVERLAY = RenderHelper.makeLayer("botania:icon_overlay", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::manaPool)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        MANA_POOL_WATER = RenderHelper.makeLayer("botania:mana_pool_water", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::terraPlate)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        TERRA_PLATE = RenderHelper.makeLayer("botania:terra_plate_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::enchanter)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        ENCHANTER = RenderHelper.makeLayer("botania:enchanter_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        class_4668.class_4683 babylonTexture = new class_4668.class_4683(new class_2960("botania:textures/misc/babylon.png"), false, true);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)babylonTexture).method_34578(new class_4668.class_5942(CoreShaders::halo)).method_23615(field_21370).method_23610(field_25643).method_23603(field_21345).method_23617(true);
        BABYLON_ICON = RenderHelper.makeLayer("botania:babylon", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        class_4668.class_4683 haloTexture = new class_4668.class_4683(ItemFlightTiara.textureHalo, false, true);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)haloTexture).method_34578(new class_4668.class_5942(CoreShaders::halo)).method_23615(field_21370).method_23603(field_21345).method_23617(true);
        HALO = RenderHelper.makeLayer("botania:halo", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::starfield)).method_34577((class_4668.class_5939)class_4668.class_5940.method_34560().method_34563(class_840.field_4406, false, false).method_34563(class_840.field_4407, false, false).method_34562()).method_23617(false);
        STARFIELD = RenderHelper.makeLayer("botania:starfield", class_290.field_1592, class_293.class_5596.field_27382, 256, false, false, glState);
        glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21367).method_23617(false);
        LIGHTNING = RenderHelper.makeLayer("botania:lightning", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
        DOPPLEGANGER = class_156.method_34866(texture -> {
            class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::doppleganger)).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return RenderHelper.makeLayer("botania:doppleganger", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, glState);
        });
    }

    private static class AstrolabeLayer
    extends class_1921 {
        public AstrolabeLayer() {
            super("botania:astrolabe", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, () -> {
                class_4722.method_24076().method_23516();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> class_4722.method_24076().method_23518());
        }
    }
}

