/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;

public interface CorporeaHelper {
    public static final Supplier<CorporeaHelper> INSTANCE = Suppliers.memoize(() -> {
        try {
            return (CorporeaHelper)Class.forName("vazkii.botania.common.impl.corporea.CorporeaHelperImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find CorporeaHelperImpl, using a dummy");
            return new CorporeaHelper(){};
        }
    });

    public static CorporeaHelper instance() {
        return INSTANCE.get();
    }

    default public List<ICorporeaNode> getNodesOnNetwork(ICorporeaSpark spark) {
        return Collections.emptyList();
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return 0;
    }

    default public int getCountInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> inventories) {
        return 0;
    }

    default public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, ICorporeaSpark spark) {
        return Collections.emptyMap();
    }

    default public Map<ICorporeaNode, Integer> getInventoriesWithMatchInNetwork(ICorporeaRequestMatcher matcher, List<ICorporeaNode> inventories) {
        return Collections.emptyMap();
    }

    default public ICorporeaRequestMatcher createMatcher(class_1799 stack, boolean checkNBT) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaRequestMatcher createMatcher(String name) {
        return ICorporeaRequestMatcher.Dummy.INSTANCE;
    }

    default public ICorporeaResult requestItem(class_1799 stack, ICorporeaSpark spark, boolean checkNBT, boolean doit) {
        return this.requestItem(this.createMatcher(stack, checkNBT), stack.method_7947(), spark, doit);
    }

    default public ICorporeaResult requestItem(String name, int count, ICorporeaSpark spark, boolean doit) {
        return this.requestItem(this.createMatcher(name), count, spark, doit);
    }

    default public ICorporeaResult requestItem(ICorporeaRequestMatcher matcher, int itemCount, ICorporeaSpark spark, boolean doit) {
        return ICorporeaResult.Dummy.INSTANCE;
    }

    @Nullable
    default public ICorporeaSpark getSparkForBlock(class_1937 world, class_2338 pos) {
        return null;
    }

    default public boolean doesBlockHaveSpark(class_1937 world, class_2338 pos) {
        return this.getSparkForBlock(world, pos) != null;
    }

    default public int signalStrengthForRequestSize(int requestSize) {
        return 0;
    }

    default public <T extends ICorporeaRequestMatcher> void registerRequestMatcher(class_2960 id, Class<T> clazz, Function<class_2487, T> deserializer) {
    }
}

