/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.test.TestingUtil;

public class BindingTest {
    private static final String TEMPLATE = "botania:block/flower_binding_arena";

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void functionalFlowerAutoBindTest(class_4516 helper) {
        this.autobindTest(helper, ModBlocks.creativePool, ModSubtiles.clayconiaFloating, 10);
    }

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void generatingFlowerAutoBindTest(class_4516 helper) {
        this.autobindTest(helper, ModBlocks.manaSpreader, ModSubtiles.endoflameFloating, 6);
    }

    private void autobindTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
        class_2338 middle = new class_2338(16, 16, 16);
        helper.method_35984(middle, bindTargetBlock);
        class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();
        List<class_2338> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<class_2338> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.method_36003(1L, () -> {
            justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
            tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
            helper.method_36036();
        });
    }

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void functionalFlowerManualBindTest(class_4516 helper) {
        this.manualBindTest(helper, ModBlocks.creativePool, ModSubtiles.clayconiaFloating, 10);
    }

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void generatingFlowerManualBindTest(class_4516 helper) {
        this.manualBindTest(helper, ModBlocks.manaSpreader, ModSubtiles.endoflameFloating, 6);
    }

    private void manualBindTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
        class_2338 middle = new class_2338(16, 16, 16);
        List<class_2338> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<class_2338> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.method_35984(middle, bindTargetBlock);
        class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();
        justCloseEnough.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));
        tooFarAway.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));
        justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
        tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
        helper.method_36036();
    }

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void functionalFlowerObedienceStick(class_4516 helper) {
        this.obedienceStickTest(helper, ModBlocks.creativePool, ModSubtiles.clayconiaFloating, 10);
    }

    @class_6302(method_35936="botania:block/flower_binding_arena")
    public void generatingFlowerObedienceStick(class_4516 helper) {
        this.obedienceStickTest(helper, ModBlocks.manaSpreader, ModSubtiles.endoflameFloating, 6);
    }

    private void obedienceStickTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
        class_2338 middle = new class_2338(16, 16, 16);
        List<class_2338> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<class_2338> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.method_35984(middle, bindTargetBlock);
        class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();
        class_1657 player = helper.method_36021();
        player.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.obedienceStick));
        TestingUtil.useItemOn(helper, player, class_1268.field_5808, middle);
        justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
        tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
        helper.method_36036();
    }

    private static List<class_2338> placeAxialFlowers(class_4516 helper, class_2338 center, class_2248 flower, int distance) {
        return Arrays.stream(class_2350.values()).map(dir -> center.method_10079(dir, distance)).peek(pos -> helper.method_35984(pos, flower)).collect(Collectors.toList());
    }

    private static void assertFlowerBoundTo(class_4516 helper, class_2338 relativePos, @Nullable class_2338 absoluteBindTarget) {
        Object message = absoluteBindTarget == null ? "Flower should not have bound" : "Flower should have bound to " + absoluteBindTarget;
        class_2586 be = TestingUtil.assertAnyBlockEntity(helper, relativePos);
        if (be instanceof TileEntityGeneratingFlower) {
            TileEntityGeneratingFlower tege = (TileEntityGeneratingFlower)be;
            TestingUtil.assertEqualsAt(helper, relativePos, tege.getBinding(), absoluteBindTarget, () -> BindingTest.lambda$assertFlowerBoundTo$11((String)message));
        } else if (be instanceof TileEntityFunctionalFlower) {
            TileEntityFunctionalFlower tefe = (TileEntityFunctionalFlower)be;
            TestingUtil.assertEqualsAt(helper, relativePos, tefe.getBinding(), absoluteBindTarget, () -> BindingTest.lambda$assertFlowerBoundTo$12((String)message));
        } else {
            TestingUtil.throwPositionedAssertion(helper, relativePos, () -> "Expected a flower here");
        }
    }

    private static /* synthetic */ String lambda$assertFlowerBoundTo$12(String message) {
        return message;
    }

    private static /* synthetic */ String lambda$assertFlowerBoundTo$11(String message) {
        return message;
    }
}

