/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.function.BiConsumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogicRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.FullItemFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1767;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaFabricCapabilities;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.api.mana.ManaNetworkCallback;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.advancements.ModCriteriaTriggers;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.string.BlockRedStringInterceptor;
import vazkii.botania.common.block.subtile.functional.SubTileDaffomill;
import vazkii.botania.common.block.subtile.functional.SubTileTigerseye;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.command.SkyblockCommand;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.handler.CommonTickHandler;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.handler.PaintableData;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.handler.SleepingHandler;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.DefaultHornHarvestable;
import vazkii.botania.common.impl.corporea.DefaultCorporeaMatchers;
import vazkii.botania.common.item.ItemBlackHoleTalisman;
import vazkii.botania.common.item.ItemEnderHand;
import vazkii.botania.common.item.ItemGrassSeeds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.ItemManaMirror;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.material.ItemEnderAir;
import vazkii.botania.common.item.relic.ItemFlugelEye;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.rod.ItemCobbleRod;
import vazkii.botania.common.item.rod.ItemDirtRod;
import vazkii.botania.common.item.rod.ItemDiviningRod;
import vazkii.botania.common.item.rod.ItemExchangeRod;
import vazkii.botania.common.item.rod.ItemFireRod;
import vazkii.botania.common.item.rod.ItemGravityRod;
import vazkii.botania.common.item.rod.ItemMissileRod;
import vazkii.botania.common.item.rod.ItemRainbowRod;
import vazkii.botania.common.item.rod.ItemTerraformRod;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.LootHandler;
import vazkii.botania.common.loot.ModLootModifiers;
import vazkii.botania.common.world.ModFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.fabric.FiberBotaniaConfig;
import vazkii.botania.fabric.integration.tr_energy.FluxfieldTRStorage;
import vazkii.botania.fabric.internal_caps.RedStringContainerStorage;
import vazkii.botania.fabric.network.FabricPacketHandler;
import vazkii.botania.fabric.tile.FabricTileRedStringContainer;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.PatchouliAPI;

public class FabricCommonInitializer
implements ModInitializer {
    public void onInitialize() {
        this.coreInit();
        this.registryInit();
        PaintableData.init();
        DefaultCorporeaMatchers.init();
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.alfPortal), TileAlfPortal.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.terraPlate), TileTerraPlate.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_2378.field_11146.method_10221((Object)ModBlocks.enchanter), TileEnchanter.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), EntityDoppleganger.ARENA_MULTIBLOCK.get());
        OrechidManager.registerListener();
        TileCraftCrate.registerListener();
        this.registerCapabilities();
        this.registerEvents();
    }

    private void coreInit() {
        FiberBotaniaConfig.setup();
        EquipmentHandler.init();
        FabricPacketHandler.init();
    }

    private void registryInit() {
        ModSounds.init(FabricCommonInitializer.bind(class_2378.field_11156));
        ModBlocks.registerBlocks(FabricCommonInitializer.bind(class_2378.field_11146));
        ModBlocks.registerItemBlocks(FabricCommonInitializer.bind(class_2378.field_11142));
        ModFluffBlocks.registerBlocks(FabricCommonInitializer.bind(class_2378.field_11146));
        ModFluffBlocks.registerItemBlocks(FabricCommonInitializer.bind(class_2378.field_11142));
        ModTiles.registerTiles(FabricCommonInitializer.bind(class_2378.field_11137));
        ModItems.registerItems(FabricCommonInitializer.bind(class_2378.field_11142));
        ModSubtiles.registerBlocks(FabricCommonInitializer.bind(class_2378.field_11146));
        ModSubtiles.registerItemBlocks(FabricCommonInitializer.bind(class_2378.field_11142));
        ModSubtiles.registerTEs(FabricCommonInitializer.bind(class_2378.field_11137));
        ModBlocks.addDispenserBehaviours();
        ModBlocks.addAxeStripping();
        int blazeTime = 2400;
        FuelRegistry.INSTANCE.add((class_1935)ModBlocks.blazeBlock.method_8389(), (Object)(blazeTime * (IXplatAbstractions.INSTANCE.gogLoaded() ? 5 : 10)));
        ModItems.registerMenuTypes(FabricCommonInitializer.bind(class_2378.field_17429));
        ModItems.registerRecipeSerializers(FabricCommonInitializer.bind(class_2378.field_17598));
        ModRecipeTypes.registerRecipeTypes(FabricCommonInitializer.bind(class_2378.field_17598));
        ModEntities.registerEntities(FabricCommonInitializer.bind(class_2378.field_11145));
        ModEntities.registerAttributes(FabricDefaultAttributeRegistry::register);
        PixieHandler.registerAttribute(FabricCommonInitializer.bind(class_2378.field_23781));
        MinecartComparatorLogicRegistry.register(ModEntities.POOL_MINECART, (minecart, state, pos) -> minecart.getComparatorLevel());
        ModPotions.registerPotions(FabricCommonInitializer.bind(class_2378.field_11159));
        ModBrews.registerBrews();
        ModFeatures.registerFeatures(FabricCommonInitializer.bind(class_2378.field_11138));
        SkyblockChunkGenerator.init();
        if (BotaniaConfig.common().worldgenEnabled()) {
            BiomeModifications.addFeature(ctx -> {
                class_1959.class_1961 category = ctx.getBiome().method_8688();
                return !ModFeatures.TYPE_BLACKLIST.contains(category);
            }, (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)((class_5321)class_5458.field_35761.method_29113((Object)ModFeatures.MYSTICAL_FLOWERS_PLACED).orElseThrow()));
            BiomeModifications.addFeature(ctx -> ctx.getBiome().method_8688() != class_1959.class_1961.field_9360, (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)((class_5321)class_5458.field_35761.method_29113((Object)ModFeatures.MYSTICAL_MUSHROOMS_PLACED).orElseThrow()));
        }
        ModCriteriaTriggers.init();
        ModLootModifiers.init();
        ModParticles.registerParticles(FabricCommonInitializer.bind(class_2378.field_11141));
        ModStats.init();
    }

    private void registerEvents() {
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            UseBlockCallback.EVENT.register(SkyblockWorldEvents::onPlayerInteract);
        }
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> ((ItemExchangeRod)ModItems.exchangeRod).onLeftClick(player, world, hand, pos, direction));
        AttackEntityCallback.EVENT.register(ItemGravityRod::onAttack);
        AttackEntityCallback.EVENT.register(ItemTerraSword::attackEntity);
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        EntitySleepEvents.ALLOW_SLEEPING.register(SleepingHandler::trySleep);
        EntityTrackingEvents.START_TRACKING.register(SubTileDaffomill::onItemTrack);
        LootTableLoadingCallback.EVENT.register((resourceManager, manager, id, supplier, setter) -> LootHandler.lootLoad(id, arg_0 -> ((FabricLootSupplierBuilder)supplier).withPool(arg_0)));
        ManaNetworkCallback.EVENT.register(ManaNetworkHandler.instance::onNetworkEvent);
        ServerEntityEvents.ENTITY_LOAD.register(SubTileTigerseye::pacifyAfterLoad);
        ServerLifecycleEvents.SERVER_STARTED.register(this::serverAboutToStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ItemFlightTiara.playerLoggedOut(handler.field_14140));
        ServerPlayerEvents.AFTER_RESPAWN.register(ItemKeepIvy::onPlayerRespawn);
        ServerTickEvents.END_WORLD_TICK.register(CommonTickHandler::onTick);
        ServerTickEvents.END_WORLD_TICK.register(ItemGrassSeeds::onTickEnd);
        ServerTickEvents.END_WORLD_TICK.register(ItemTerraAxe::onTickEnd);
        UseBlockCallback.EVENT.register(BlockRedStringInterceptor::onInteract);
        UseBlockCallback.EVENT.register(ItemLokiRing::onPlayerInteract);
        UseItemCallback.EVENT.register(ItemEnderAir::onPlayerInteract);
    }

    private static <T> BiConsumer<T, class_2960> bind(class_2378<? super T> registry) {
        return (t, id) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)t);
    }

    private void registerCapabilities() {
        FluidStorage.ITEM.registerForItems((stack, context) -> new FullItemFluidStorage(context, class_1802.field_8428, FluidVariant.of((class_3611)class_3612.field_15910), 81000L), new class_1935[]{ModItems.waterBowl});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemDirtRod.AvatarBehavior(), new class_1935[]{ModItems.dirtRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemDiviningRod.AvatarBehavior(), new class_1935[]{ModItems.diviningRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemFireRod.AvatarBehavior(), new class_1935[]{ModItems.fireRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemMissileRod.AvatarBehavior(), new class_1935[]{ModItems.missileRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemRainbowRod.AvatarBehavior(), new class_1935[]{ModItems.rainbowRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new ItemTornadoRod.AvatarBehavior(), new class_1935[]{ModItems.tornadoRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new ItemDirtRod.BlockProvider(stack), new class_1935[]{ModItems.dirtRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new ItemBlackHoleTalisman.BlockProvider(stack), new class_1935[]{ModItems.blackHoleTalisman});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new ItemCobbleRod.BlockProvider(), new class_1935[]{ModItems.cobbleRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new ItemEnderHand.BlockProvider(stack), new class_1935[]{ModItems.enderHand});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new ItemTerraformRod.BlockProvider(), new class_1935[]{ModItems.terraformRod});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new ItemFlugelEye.CoordBoundItem(st), new class_1935[]{ModItems.flugelEye});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new ItemManaMirror.CoordBoundItem(st), new class_1935[]{ModItems.manaMirror});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new ItemTwigWand.CoordBoundItem(st), new class_1935[]{ModItems.twigWand});
        BotaniaFabricCapabilities.EXOFLAME_HEATABLE.registerFallback((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof class_2609) {
                class_2609 furnace = (class_2609)blockEntity;
                return new ExoflameFurnaceHandler.FurnaceExoflameHeatable(furnace);
            }
            return null;
        });
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> (world, pos, stack, hornType) -> hornType == IHornHarvestable.EnumHornType.CANOPY, new class_2248[]{class_2246.field_10597, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22123, class_2246.field_22124});
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> DefaultHornHarvestable.INSTANCE, (class_2248[])Arrays.stream(class_1767.values()).map(ModBlocks::getMushroom).toArray(class_2248[]::new));
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> DefaultHornHarvestable.INSTANCE, (class_2248[])Arrays.stream(class_1767.values()).map(ModBlocks::getShinyFlower).toArray(class_2248[]::new));
        BotaniaFabricCapabilities.HOURGLASS_TRIGGER.registerForBlockEntities((be, c) -> {
            TileAnimatedTorch torch = (TileAnimatedTorch)be;
            return hourglass -> torch.toggle();
        }, new class_2591[]{ModTiles.ANIMATED_TORCH});
        BotaniaFabricCapabilities.WANDABLE.registerForBlocks((world, pos, state, blockEntity, context) -> (player, stack, side) -> ((BlockPistonRelay)state.method_26204()).onUsedByWand(player, stack, world, pos), new class_2248[]{ModBlocks.pistonRelay});
        BotaniaFabricCapabilities.WANDABLE.registerSelf(new class_2591[]{ModTiles.ALF_PORTAL, ModTiles.ANIMATED_TORCH, ModTiles.CORPOREA_CRYSTAL_CUBE, ModTiles.CORPOREA_RETAINER, ModTiles.CRAFT_CRATE, ModTiles.ENCHANTER, ModTiles.HOURGLASS, ModTiles.PLATFORM, ModTiles.POOL, ModTiles.RUNE_ALTAR, ModTiles.SPREADER, ModTiles.TURNTABLE, ModSubtiles.DAFFOMILL, ModSubtiles.HOPPERHOCK, ModSubtiles.HOPPERHOCK_CHIBI, ModSubtiles.RANNUNCARPUS, ModSubtiles.RANNUNCARPUS_CHIBI});
        ItemStorage.SIDED.registerForBlockEntity(FabricTileRedStringContainer::getStorage, ModTiles.RED_STRING_CONTAINER);
        ItemStorage.SIDED.registerForBlockEntity(RedStringContainerStorage::new, ModTiles.RED_STRING_DISPENSER);
        if (IXplatAbstractions.INSTANCE.isModLoaded("team_reborn_energy")) {
            FluxfieldTRStorage.register();
        }
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.method_3816()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockCommand.register(dispatcher);
        }
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        TileCorporeaIndex.clearIndexCache();
    }
}

