/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2521;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4778;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockBuriedPetals;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.decor.panes.BlockModPane;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorBlockModelGenerators;
import vazkii.botania.mixin.AccessorTextureSlot;

public class BlockstateProvider
implements class_2405 {
    private final class_2403 generator;
    private final List<class_4917> blockstates = new ArrayList<class_4917>();
    private final Map<class_2960, Supplier<JsonElement>> models = new HashMap<class_2960, Supplier<JsonElement>>();
    private final BiConsumer<class_2960, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(class_2403 generator) {
        this.generator = generator;
    }

    @Nonnull
    public String method_10321() {
        return "Botania Blockstates and Models";
    }

    public void method_10319(class_2408 hashCache) throws IOException {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Path root = this.generator.method_10313();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        for (class_4917 class_49172 : this.blockstates) {
            class_2960 id = class_2378.field_11146.method_10221((Object)class_49172.method_25743());
            path = root.resolve("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json");
            try {
                class_2405.method_10320((Gson)gson, (class_2408)hashCache, (JsonElement)((JsonElement)class_49172.get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating blockstate file for {}", (Object)id, (Object)ex);
            }
        }
        for (Map.Entry entry : this.models.entrySet()) {
            class_2960 modelId = (class_2960)entry.getKey();
            path = root.resolve("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json");
            try {
                class_2405.method_10320((Gson)gson, (class_2408)hashCache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating model file {}", (Object)modelId, (Object)ex);
            }
        }
    }

    private void registerStatesAndModels() {
        Set<class_2248> remainingBlocks = class_2378.field_11146.method_10220().filter(b -> "botania".equals(class_2378.field_11146.method_10221(b).method_12836())).collect(Collectors.toSet());
        remainingBlocks.remove(ModBlocks.ghostRail);
        remainingBlocks.remove(ModBlocks.solidVines);
        this.manualModel(remainingBlocks, ModBlocks.cocoon);
        this.manualModel(remainingBlocks, ModBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, ModBlocks.distributor);
        this.manualModel(remainingBlocks, ModBlocks.prism);
        this.manualModel(remainingBlocks, ModBlocks.runeAltar);
        this.manualModel(remainingBlocks, ModBlocks.spawnerClaw);
        class_2960 alfPortalModel = class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.alfPortal), class_4944.method_25864((class_2248)ModBlocks.alfPortal), this.modelOutput);
        class_2960 alfPortalActivatedModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated"), class_4944.method_25875((class_2960)class_4941.method_25843((class_2248)ModBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.alfPortal).method_25775((class_4926)class_4926.method_25783(BotaniaStateProps.ALFPORTAL_STATE).method_25793((Comparable)((Object)AlfPortalState.OFF), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalModel)).method_25793((Comparable)((Object)AlfPortalState.ON_X), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel)).method_25793((Comparable)((Object)AlfPortalState.ON_Z), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(ModBlocks.alfPortal);
        this.singleVariantBlockState(ModBlocks.bifrostPerm, class_4943.field_22972.method_25852(class_4941.method_25842((class_2248)ModBlocks.bifrostPerm), class_4944.method_25864((class_2248)ModBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(ModBlocks.bifrostPerm);
        this.singleVariantBlockState(ModBlocks.cacophonium, class_4943.field_22976.method_25846(ModBlocks.cacophonium, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)class_2246.field_10179)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.cacophonium);
        class_4942 crateTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23018});
        class_2960 craftCrateBottomTex = class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)"_bottom");
        class_4926.class_4927 crateDispatch = class_4926.method_25783(BotaniaStateProps.CRATE_PATTERN);
        for (CratePattern pattern : CratePattern.values()) {
            String suffix = pattern == CratePattern.NONE ? "" : "_" + pattern.method_15434().substring("crafty_".length());
            class_2960 model = crateTemplate.method_25852(class_4941.method_25843((class_2248)ModBlocks.craftCrate, (String)suffix), new class_4944().method_25868(class_4945.field_23014, craftCrateBottomTex).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.method_25793((Comparable)((Object)pattern), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model));
        }
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)ModBlocks.craftCrate).method_25775((class_4926)crateDispatch));
        remainingBlocks.remove(ModBlocks.craftCrate);
        class_2960 corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        class_2960 corpBlock = class_4944.method_25860((class_2248)ModBlocks.corporeaBlock);
        class_2960 corpSlabBottomModel = class_4943.field_22909.method_25846((class_2248)ModBlocks.corporeaSlab, new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabTopModel = class_4943.field_22910.method_25852(class_4941.method_25843((class_2248)ModBlocks.corporeaSlab, (String)"_top"), new class_4944().method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock), this.modelOutput);
        class_2960 corpSlabDoubleModel = class_4943.field_22977.method_25852(ResourceLocationHelper.prefix("block/corporea_double_slab"), new class_4944().method_25868(class_4945.field_23018, corpSlabSide).method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock), this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeSlabState((class_2248)ModBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(ModBlocks.corporeaSlab);
        this.stairsBlock(remainingBlocks, (class_2248)ModBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        this.wallBlock(remainingBlocks, ModBlocks.corporeaBrickWall, class_4944.method_25860((class_2248)ModBlocks.corporeaBrick));
        this.blockstates.add((class_4917)class_4925.method_25771((class_2248)ModBlocks.elfGlass, (class_4935[])((class_4935[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            class_2960 model = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)ModBlocks.elfGlass, (String)("_" + i)), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)ModBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
        }).toArray(class_4935[]::new))));
        remainingBlocks.remove(ModBlocks.elfGlass);
        this.singleVariantBlockState(ModBlocks.enchantedSoil, class_4943.field_22977.method_25846(ModBlocks.enchantedSoil, class_4944.method_25898((class_2248)ModBlocks.enchantedSoil).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)), this.modelOutput));
        remainingBlocks.remove(ModBlocks.enchantedSoil);
        class_2960 pumpkinModel = class_4943.field_22978.method_25846(ModBlocks.felPumpkin, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_side")).method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)ModBlocks.felPumpkin)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)class_2246.field_10261, (String)"_top")), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.felPumpkin, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)pumpkinModel)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.felPumpkin);
        class_4942 eightByEightTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021});
        this.singleVariantBlockState(ModBlocks.forestEye, eightByEightTemplate.method_25846(ModBlocks.forestEye, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_bottom")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_top")).method_25868(class_4945.field_23019, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_north")).method_25868(class_4945.field_23020, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_south")).method_25868(class_4945.field_23022, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_west")).method_25868(class_4945.field_23021, class_4944.method_25866((class_2248)ModBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.forestEye);
        class_2960 plateFile = class_4941.method_25842((class_2248)ModBlocks.incensePlate);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)ModBlocks.incensePlate, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plateFile)).method_25775(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.incensePlate);
        class_4942 fourHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.lightLauncher, fourHighBottomTopTemplate.method_25846(ModBlocks.lightLauncher, new class_4944().method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_end")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)ModBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.lightLauncher);
        this.singleVariantBlockState(ModBlocks.openCrate, crateTemplate.method_25846(ModBlocks.openCrate, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)ModBlocks.openCrate)).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)ModBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.openCrate);
        class_4942 threeHighBottomTopTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new class_4945[]{class_4945.field_23014, class_4945.field_23015, class_4945.field_23018});
        this.singleVariantBlockState(ModBlocks.sparkChanger, threeHighBottomTopTemplate.method_25846(ModBlocks.sparkChanger, class_4944.method_25898((class_2248)ModBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(ModBlocks.sparkChanger);
        this.singleVariantBlockState(ModBlocks.starfield, fourHighBottomTopTemplate.method_25846(ModBlocks.starfield, class_4944.method_25898((class_2248)ModBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(ModBlocks.starfield);
        this.singleVariantBlockState(ModBlocks.terraPlate, threeHighBottomTopTemplate.method_25846(ModBlocks.terraPlate, class_4944.method_25898((class_2248)ModBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(ModBlocks.terraPlate);
        class_4942 tenByTenAllTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        this.singleVariantBlockState(ModBlocks.tinyPlanet, tenByTenAllTemplate.method_25846(ModBlocks.tinyPlanet, class_4944.method_25864((class_2248)ModBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(ModBlocks.tinyPlanet);
        this.singleVariantBlockState(ModBlocks.turntable, class_4943.field_22977.method_25846(ModBlocks.turntable, class_4944.method_25898((class_2248)ModBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(ModBlocks.turntable);
        class_2960[] topTexs = new class_2960[6];
        class_2960[] sideTexs = new class_2960[6];
        class_2960[] topStrippedTexs = new class_2960[6];
        class_2960[] sideStrippedTexs = new class_2960[6];
        class_2960[] sideGlimmeringTexs = new class_2960[6];
        class_2960[] sideGlimmeringStrippedTexs = new class_2960[6];
        class_2960[] logModels = new class_2960[6];
        class_2960[] strippedLogModels = new class_2960[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            int index = i2 + 1;
            sideTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)("/" + index));
            topTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)"_top");
            sideStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)("/" + index));
            topStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)"_top");
            sideGlimmeringTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogGlimmering, (String)("/" + index));
            sideGlimmeringStrippedTexs[i2] = class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStrippedGlimmering, (String)("/" + index));
            logModels[i2] = class_4941.method_25843((class_2248)ModBlocks.dreamwood, (String)("_" + index));
            strippedLogModels[i2] = class_4941.method_25843((class_2248)ModBlocks.dreamwoodStripped, (String)("_" + index));
        }
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLog, topTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwood, sideTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStairs, sideTexs, sideTexs, sideTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodWall, sideTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedWall, sideStrippedTexs);
        this.pillar(remainingBlocks, ModBlocks.livingwoodLog, class_4944.method_25866((class_2248)ModBlocks.livingwoodLog, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwood, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStripped, class_4944.method_25866((class_2248)ModBlocks.livingwoodLogStripped, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStripped, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogGlimmering, class_4944.method_25866((class_2248)ModBlocks.livingwoodLog, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodGlimmering, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStrippedGlimmering, class_4944.method_25866((class_2248)ModBlocks.livingwoodLogStripped, (String)"_top"), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStrippedGlimmering, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillarAlt(remainingBlocks, ModBlocks.livingwoodFramed, class_4944.method_25860((class_2248)ModBlocks.livingwoodPatternFramed), class_4944.method_25860((class_2248)ModBlocks.livingwoodFramed));
        this.pillarAlt(remainingBlocks, ModBlocks.dreamwoodFramed, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPatternFramed), class_4944.method_25860((class_2248)ModBlocks.dreamwoodFramed));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStairs, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedStairs, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodSlab, class_4941.method_25842((class_2248)ModBlocks.livingwood), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog), class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedSlab, class_4941.method_25842((class_2248)ModBlocks.livingwoodStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped), class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodWall, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedWall, class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockWall, class_4944.method_25860((class_2248)ModBlocks.livingrock));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockBrickWall, class_4944.method_25860((class_2248)ModBlocks.livingrockBrick));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockBrickMossyWall, class_4944.method_25860((class_2248)ModBlocks.livingrockBrickMossy));
        this.fenceBlock(ModFluffBlocks.dreamwoodFence, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.dreamwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.dreamwoodPlanks));
        this.fenceBlock(ModFluffBlocks.livingwoodFence, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.livingwoodFenceGate, class_4944.method_25860((class_2248)ModBlocks.livingwoodPlanks));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFence);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFenceGate);
        this.particleOnly(remainingBlocks, ModBlocks.animatedTorch, class_4944.method_25860((class_2248)class_2246.field_10523));
        this.particleOnly(remainingBlocks, ModBlocks.avatar, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.bellows, class_4944.method_25860((class_2248)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.brewery, class_4944.method_25860((class_2248)ModBlocks.livingrock));
        this.particleOnly(remainingBlocks, ModBlocks.corporeaIndex, class_4944.method_25860((class_2248)ModBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDetector, class_4944.method_25860((class_2248)ModBlocks.lightRelayDetector));
        this.singleVariantBlockState(ModBlocks.fakeAir, new class_4942(Optional.empty(), Optional.empty(), new class_4945[0]).method_25846(ModBlocks.fakeAir, new class_4944(), this.modelOutput));
        remainingBlocks.remove(ModBlocks.fakeAir);
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayFork, class_4944.method_25860((class_2248)ModBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHead, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHeadWall, class_4944.method_25860((class_2248)class_2246.field_10114));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaPylon, class_4944.method_25860((class_2248)ModBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, ModBlocks.hourglass, class_4944.method_25860((class_2248)ModBlocks.manaGlass));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDefault, class_4944.method_25860((class_2248)ModBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, ModBlocks.manaFlame, new class_2960("block/fire_0"));
        this.particleOnly(remainingBlocks, ModBlocks.manaPylon, class_4944.method_25860((class_2248)ModBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.naturaPylon, class_4944.method_25860((class_2248)ModBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.teruTeruBozu, class_4944.method_25860((class_2248)class_2246.field_10446));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayToggle, class_4944.method_25860((class_2248)ModBlocks.lightRelayToggle));
        Predicate<class_2248> flowers = b -> b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockModFlower;
        class_4942 crossTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new class_4945[]{class_4945.field_23025});
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockMotifFlower).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832().replace("_motif", "");
            this.singleVariantBlockState((class_2248)b, crossTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23025, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.corporeaFunnel, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4943.field_22974.method_25846(b, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)b, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)b, (String)"_end")), this.modelOutput)));
        class_4942 drumModelTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23018});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.gatheringDrum, ModBlocks.canopyDrum, ModBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((class_2248)b, drumModelTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23015, ResourceLocationHelper.prefix("block/drum_top")).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)b)), this.modelOutput)));
        class_4945 outsideSlot = AccessorTextureSlot.make("outside");
        class_4945 coreSlot = AccessorTextureSlot.make("core");
        class_4942 spreaderTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_23017, class_4945.field_27791, outsideSlot});
        class_4942 spreaderCoreTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_core")), Optional.of("_core"), new class_4945[]{coreSlot});
        class_4942 spreaderPaddingTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_padding")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23017, class_4945.field_23018});
        class_4942 spreaderScaffoldingTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_scaffolding")), Optional.of("_scaffolding"), new class_4945[]{class_4945.field_23015, class_4945.field_23018, class_4945.field_23014});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaSpreader, ModBlocks.redstoneSpreader, ModBlocks.gaiaSpreader, ModBlocks.elvenSpreader).forEach(b -> {
            class_2960 outside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? class_4944.method_25860((class_2248)ModBlocks.livingwoodLog) : (b == ModBlocks.elvenSpreader ? class_4944.method_25866((class_2248)ModBlocks.dreamwoodLog, (String)"/4") : class_4944.method_25866((class_2248)b, (String)"_outside"));
            class_2960 inside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? class_4944.method_25860((class_2248)ModBlocks.livingwoodLogStripped) : (b == ModBlocks.elvenSpreader ? class_4944.method_25866((class_2248)ModBlocks.dreamwoodLogStripped, (String)"/4") : class_4944.method_25866((class_2248)b, (String)"_inside"));
            this.singleVariantBlockState((class_2248)b, spreaderTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)b, (String)"_back")).method_25868(class_4945.field_27791, inside).method_25868(outsideSlot, outside), this.modelOutput));
            spreaderCoreTemplate.method_25846(b, new class_4944().method_25868(coreSlot, class_4944.method_25866((class_2248)b, (String)"_core")), this.modelOutput);
            if (b != ModBlocks.redstoneSpreader) {
                spreaderScaffoldingTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_scaffolding_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_scaffolding_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)b, (String)"_scaffolding_bottom")), this.modelOutput);
            }
        });
        for (class_1767 color : class_1767.values()) {
            String[] wool = ColorHelper.WOOL_MAP.apply(color);
            spreaderPaddingTemplate.method_25852(ResourceLocationHelper.prefix("block/" + color.method_7792() + "_spreader_padding"), new class_4944().method_25868(class_4945.field_23016, class_4944.method_25860((class_2248)wool)).method_25868(class_4945.field_23017, class_4944.method_25860((class_2248)wool)).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)wool)), this.modelOutput);
        }
        class_4945 liquidSlot = AccessorTextureSlot.make("liquid");
        class_4942 poolTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool")), Optional.empty(), new class_4945[]{class_4945.field_23010});
        class_4942 poolFullTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool_full")), Optional.of("_full"), new class_4945[]{class_4945.field_23010, liquidSlot});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaPool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.creativePool).forEach(b -> {
            class_2960 tex = b == ModBlocks.manaPool || b == ModBlocks.fabulousPool ? class_4944.method_25860((class_2248)ModBlocks.livingrock) : class_4944.method_25860((class_2248)b);
            poolFullTemplate.method_25846(b, class_4944.method_25875((class_2960)tex).method_25868(liquidSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
            this.singleVariantBlockState((class_2248)b, poolTemplate.method_25846(b, class_4944.method_25875((class_2960)tex), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.pump, ModBlocks.tinyPotato).forEach(b -> this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)b))).method_25775(AccessorBlockModelGenerators.horizontalDispatch())));
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.enderEye, ModBlocks.manaDetector).forEach(b -> {
            class_2960 offModel = class_4943.field_22972.method_25846(b, class_4944.method_25864((class_2248)b), this.modelOutput);
            class_2960 onModel = class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)b, (String)"_powered"), class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12484).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)offModel)).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)onModel))));
        });
        class_2960 petalBlockModel = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new class_4945[]{class_4945.field_23010}).method_25852(ResourceLocationHelper.prefix("block/petal_block"), new class_4944().method_25868(class_4945.field_23010, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockPetalBlock).forEach(b -> this.singleVariantBlockState((class_2248)b, petalBlockModel));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltGrass).forEach(b -> {
            class_2960 model = class_4943.field_22977.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25860((class_2248)class_2246.field_10566)).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25771((class_2248)b, (class_4935[])AccessorBlockModelGenerators.createRotatedVariants(model)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockRedString).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModDoubleFlower).forEach(b -> {
            class_2960 bottom = class_4943.field_22921.method_25846(b, class_4944.method_25877((class_2248)b), this.modelOutput);
            class_2960 top = class_4943.field_22921.method_25852(class_4941.method_25843((class_2248)b, (String)"_top"), class_4944.method_25880((class_2960)class_4944.method_25866((class_2248)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((class_4917)class_4925.method_25769((class_2248)b).method_25775((class_4926)class_4926.method_25783((class_2769)class_2521.field_10929).method_25793((Comparable)class_2756.field_12607, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottom)).method_25793((Comparable)class_2756.field_12609, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)top))));
        });
        for (String variant : new String[]{"desert", "forest", "fungal", "mesa", "mountain", "plains", "swamp", "taiga"}) {
            class_2960 baseId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone");
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(baseId).get();
            this.cubeAll(base);
            class_2960 cobbleId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone");
            class_2248 cobble = (class_2248)class_2378.field_11146.method_17966(cobbleId).get();
            this.cubeAll(cobble);
            class_2960 cobbleWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone_wall");
            class_2248 cobbleWall = (class_2248)class_2378.field_11146.method_17966(cobbleWallId).get();
            this.wallBlock(remainingBlocks, cobbleWall, class_4944.method_25860((class_2248)cobble));
            class_2960 brickId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks");
            class_2248 brick = (class_2248)class_2378.field_11146.method_17966(brickId).get();
            this.cubeAll(brick);
            class_2960 brickWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks_wall");
            class_2248 brickWall = (class_2248)class_2378.field_11146.method_17966(brickWallId).get();
            this.wallBlock(remainingBlocks, brickWall, class_4944.method_25860((class_2248)brick));
            class_2960 chiseledBricksId = ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks");
            class_2248 chiseledBricks = (class_2248)class_2378.field_11146.method_17966(chiseledBricksId).get();
            this.cubeAll(chiseledBricks);
            remainingBlocks.removeAll(Arrays.asList(base, cobble, brick, chiseledBricks));
        }
        for (String variant : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            class_2960 quartzId = ResourceLocationHelper.prefix(variant + "_quartz");
            class_2248 quartz = (class_2248)class_2378.field_11146.method_17966(quartzId).get();
            this.singleVariantBlockState(quartz, class_4943.field_22977.method_25846(quartz, class_4944.method_25898((class_2248)quartz), this.modelOutput));
            class_2960 pillarId = ResourceLocationHelper.prefix(variant + "_quartz_pillar");
            class_2248 pillar = (class_2248)class_2378.field_11146.method_17966(pillarId).get();
            class_2960 pillarModel = class_4943.field_22974.method_25846(pillar, class_4944.method_25870((class_2960)class_4944.method_25866((class_2248)pillar, (String)"_side"), (class_2960)class_4944.method_25866((class_2248)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(AccessorBlockModelGenerators.createAxisAlignedPillarBlock(pillar, pillarModel));
            class_2960 chiseledId = ResourceLocationHelper.prefix("chiseled_" + variant + "_quartz");
            class_2248 chiseled = (class_2248)class_2378.field_11146.method_17966(chiseledId).get();
            this.singleVariantBlockState(chiseled, class_4943.field_22974.method_25846(chiseled, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)chiseled, (String)"_side")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockBuriedPetals).forEach(b -> {
            class_1767 color = ((BlockBuriedPetals)b).color;
            class_2960 wool = new class_2960("block/" + color.method_15434() + "_wool");
            this.particleOnly(remainingBlocks, (class_2248)b, wool);
        });
        class_4945 gobletSlot = AccessorTextureSlot.make("goblet");
        class_4945 topBottomSlot = AccessorTextureSlot.make("top_bottom");
        class_4942 apothecaryTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new class_4945[]{class_4945.field_23018, gobletSlot, topBottomSlot});
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltar).forEach(b -> this.singleVariantBlockState((class_2248)b, apothecaryTemplate.method_25846(b, new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)b, (String)"_side")).method_25868(gobletSlot, class_4944.method_25866((class_2248)b, (String)"_goblet")).method_25868(topBottomSlot, class_4944.method_25866((class_2248)b, (String)"_top_bottom")), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockFloatingFlower).forEach(b -> this.singleVariantBlockState((class_2248)b, class_4941.method_25842((class_2248)b)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModPane).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23032, class_4944.method_25860((class_2248)b)).method_25868(class_4945.field_23031, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            class_2960 postModel = class_4943.field_22953.method_25846(b, mapping, this.modelOutput);
            class_2960 sideModel = class_4943.field_22954.method_25846(b, mapping, this.modelOutput);
            class_2960 sideAltModel = class_4943.field_22955.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideModel = class_4943.field_22951.method_25846(b, mapping, this.modelOutput);
            class_2960 noSideAltModel = class_4943.field_22952.method_25846(b, mapping, this.modelOutput);
            this.blockstates.add((class_4917)class_4922.method_25758((class_2248)b).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)postModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)sideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideAltModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noSideModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2510).forEach(b -> {
            String name = class_2378.field_11146.method_10221(b).method_12832();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_2960 side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                class_2960 bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                class_2960 top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)b, side, bottom, top);
            } else {
                class_2960 tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)b, tex, tex, tex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof class_2482).forEach(slabBlock -> {
            String name = class_2378.field_11146.method_10221(slabBlock).method_12832();
            String baseName = name.substring(0, name.length() - "_slab".length());
            class_2248 base = (class_2248)class_2378.field_11146.method_17966(ResourceLocationHelper.prefix(baseName)).get();
            boolean quartz = name.contains("quartz");
            if (quartz) {
                class_2960 side = class_4944.method_25866((class_2248)base, (String)"_side");
                class_2960 bottom = class_4944.method_25866((class_2248)base, (String)"_bottom");
                class_2960 top = class_4944.method_25866((class_2248)base, (String)"_top");
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.slabBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)slabBlock, doubleModel, side, bottom, top);
            } else {
                class_2960 baseTex = class_4944.method_25860((class_2248)base);
                class_2960 doubleModel = class_4941.method_25842((class_2248)base);
                this.slabBlock((Set<class_2248>)new HashSet<class_2248>(), (class_2248)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        remainingBlocks.forEach(this::cubeAll);
    }

    protected void particleOnly(Set<class_2248> blocks, class_2248 b, class_2960 particle) {
        this.singleVariantBlockState(b, class_4943.field_22908.method_25846(b, class_4944.method_25891((class_2960)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<class_2248> blocks, class_2248 b) {
        this.singleVariantBlockState(b, class_4941.method_25842((class_2248)b));
        blocks.remove(b);
    }

    protected void stairsBlock(Set<class_2248> blocks, class_2248 block, class_2960 sideTex, class_2960 bottomTex, class_2960 topTex) {
        this.stairsBlockWithVariants(blocks, block, new class_2960[]{sideTex}, new class_2960[]{bottomTex}, new class_2960[]{topTex});
    }

    protected void stairsBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] innerModels = new class_2960[length];
        class_2960[] straightModels = new class_2960[length];
        class_2960[] outerModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]).method_25868(class_4945.field_23015, topTextures[i]);
            class_2960 modelIdInner = class_4941.method_25843((class_2248)block, (String)("_inner" + suffix));
            class_2960 modelIdStraight = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdOuter = class_4941.method_25843((class_2248)block, (String)("_outer" + suffix));
            innerModels[i] = class_4943.field_22913.method_25852(modelIdInner, mapping, this.modelOutput);
            straightModels[i] = class_4943.field_22912.method_25852(modelIdStraight, mapping, this.modelOutput);
            outerModels[i] = class_4943.field_22914.method_25852(modelIdOuter, mapping, this.modelOutput);
        }
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels);
    }

    protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] straightModels, class_2960[] outerModels) {
        class_4926.class_4929 propertyDispatch = class_4926.method_25785((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12518, (class_2769)class_2741.field_12503);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            for (class_2760 half : class_2760.values()) {
                for (class_2778 stairsShape : class_2778.values()) {
                    boolean isRight;
                    boolean isLeft = stairsShape == class_2778.field_12712 || stairsShape == class_2778.field_12708;
                    boolean bl = isRight = stairsShape == class_2778.field_12713 || stairsShape == class_2778.field_12709;
                    int rotationOffset = isLeft && half == class_2760.field_12617 ? -1 : (isRight && half == class_2760.field_12619 ? 1 : 0);
                    class_4936.class_4937[] rotations = class_4936.class_4937.values();
                    class_4936.class_4937 yRot = switch (direction) {
                        case class_2350.field_11034 -> rotations[(4 + rotationOffset) % 4];
                        case class_2350.field_11039 -> rotations[(2 + rotationOffset) % 4];
                        case class_2350.field_11035 -> rotations[(1 + rotationOffset) % 4];
                        case class_2350.field_11043 -> rotations[(3 + rotationOffset) % 4];
                        default -> throw new IllegalStateException();
                    };
                    class_4936.class_4937 xRot = switch (half) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2760.field_12617 -> class_4936.class_4937.field_22890;
                        case class_2760.field_12619 -> class_4936.class_4937.field_22892;
                    };
                    class_2960[] models = switch (stairsShape) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2778.field_12710 -> straightModels;
                        case class_2778.field_12709, class_2778.field_12708 -> outerModels;
                        case class_2778.field_12713, class_2778.field_12712 -> innerModels;
                    };
                    propertyDispatch.method_25807((Comparable)direction, (Comparable)half, (Comparable)stairsShape, Stream.of(models).map(rl -> {
                        class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, rl);
                        if (xRot != class_4936.class_4937.field_22890) {
                            variant.method_25828(class_4936.field_22885, (Object)xRot);
                        }
                        if (yRot != class_4936.class_4937.field_22890) {
                            variant.method_25828(class_4936.field_22886, (Object)yRot);
                        }
                        variant.method_25828(class_4936.field_22888, (Object)true);
                        return variant;
                    }).toList());
                }
            }
        }
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)propertyDispatch));
        blocks.remove(block);
    }

    protected void slabBlock(Set<class_2248> blocks, class_2248 block, class_2960 doubleModel, class_2960 side, class_2960 bottom, class_2960 top) {
        this.slabBlockWithVariants(blocks, block, new class_2960[]{doubleModel}, new class_2960[]{side}, new class_2960[]{bottom}, new class_2960[]{top});
    }

    protected void slabBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] doubleModels, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] bottomModels = new class_2960[length];
        class_2960[] topModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23018, sideTextures[i]).method_25868(class_4945.field_23014, bottomTextures[i]).method_25868(class_4945.field_23015, topTextures[i]);
            class_2960 modelIdBottom = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)("_top" + suffix));
            bottomModels[i] = class_4943.field_22909.method_25852(modelIdBottom, mapping, this.modelOutput);
            topModels[i] = class_4943.field_22910.method_25852(modelIdTop, mapping, this.modelOutput);
        }
        this.slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels);
    }

    protected void slabBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] bottomModels, class_2960[] topModels, class_2960[] doubleModels) {
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12485).method_25794((Comparable)class_2771.field_12681, Stream.of(bottomModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2771.field_12679, Stream.of(topModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2771.field_12682, Stream.of(doubleModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())));
        blocks.remove(block);
    }

    protected void wallBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture) {
        this.wallBlockWithVariants(blocks, block, new class_2960[]{texture});
    }

    protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures) {
        int length = sideTextures.length;
        class_2960[] postModels = new class_2960[length];
        class_2960[] lowModels = new class_2960[length];
        class_2960[] tallModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            class_4944 mapping = new class_4944().method_25868(class_4945.field_23027, sideTextures[i]);
            class_2960 modelIdPost = class_4941.method_25843((class_2248)block, (String)("_post" + suffix));
            class_2960 modelIdLow = class_4941.method_25843((class_2248)block, (String)("_side" + suffix));
            class_2960 modelIdTall = class_4941.method_25843((class_2248)block, (String)("_side_tall" + suffix));
            postModels[i] = class_4943.field_22991.method_25852(modelIdPost, mapping, this.modelOutput);
            lowModels[i] = class_4943.field_22992.method_25852(modelIdLow, mapping, this.modelOutput);
            tallModels[i] = class_4943.field_22993.method_25852(modelIdTall, mapping, this.modelOutput);
        }
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels);
    }

    protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] tallModels) {
        class_4922 multiPartGenerator = class_4922.method_25758((class_2248)block);
        multiPartGenerator.method_25761((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), Stream.of(postModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList());
        List<class_2754> wallSides = List.of(class_2741.field_22174, class_2741.field_22177, class_2741.field_22176, class_2741.field_22175);
        for (class_2754 wallSide : wallSides) {
            class_4936.class_4937 yRot = wallSide == class_2741.field_22174 ? class_4936.class_4937.field_22891 : (wallSide == class_2741.field_22177 ? class_4936.class_4937.field_22893 : (wallSide == class_2741.field_22176 ? class_4936.class_4937.field_22892 : class_4936.class_4937.field_22890));
            multiPartGenerator.method_25761((class_4918)class_4918.method_25744().method_25751((class_2769)wallSide, (Comparable)class_4778.field_22179), Stream.of(lowModels).map(rl -> {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, rl);
                if (yRot != class_4936.class_4937.field_22890) {
                    variant.method_25828(class_4936.field_22886, (Object)yRot);
                }
                variant.method_25828(class_4936.field_22888, (Object)true);
                return variant;
            }).toList()).method_25761((class_4918)class_4918.method_25744().method_25751((class_2769)wallSide, (Comparable)class_4778.field_22180), Stream.of(tallModels).map(rl -> {
                class_4935 variant = class_4935.method_25824().method_25828(class_4936.field_22887, rl);
                if (yRot != class_4936.class_4937.field_22890) {
                    variant.method_25828(class_4936.field_22886, (Object)yRot);
                }
                variant.method_25828(class_4936.field_22888, (Object)true);
                return variant;
            }).toList());
        }
        this.blockstates.add((class_4917)multiPartGenerator);
        blocks.remove(block);
    }

    protected void fenceBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 postModel = class_4943.field_22988.method_25846(block, mapping, this.modelOutput);
        class_2960 sideModel = class_4943.field_22989.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceState(block, postModel, sideModel));
    }

    protected void fenceGateBlock(class_2248 block, class_2960 tex) {
        class_4944 mapping = class_4944.method_25869((class_2960)tex);
        class_2960 openModel = class_4943.field_22996.method_25846(block, mapping, this.modelOutput);
        class_2960 closedModel = class_4943.field_22995.method_25846(block, mapping, this.modelOutput);
        class_2960 openWallModel = class_4943.field_22905.method_25846(block, mapping, this.modelOutput);
        class_2960 closedWallModel = class_4943.field_22904.method_25846(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel));
    }

    protected void cubeAll(class_2248 b) {
        class_2960 model = class_4943.field_22972.method_25846(b, class_4944.method_25864((class_2248)b), this.modelOutput);
        this.singleVariantBlockState(b, model);
    }

    protected void singleVariantBlockState(class_2248 b, class_2960 model) {
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)));
    }

    protected void pillar(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
        this.pillarWithVariants(blocks, block, new class_2960[]{top}, new class_2960[]{side});
    }

    protected void pillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] topModels = new class_2960[length];
        class_2960[] horizontalModels = new class_2960[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdHorizontal = class_4941.method_25843((class_2248)block, (String)("_horizontal" + suffix));
            topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalModels[i] = class_4943.field_22975.method_25852(modelIdHorizontal, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
        }
        this.pillarWithModels(blocks, block, topModels, horizontalModels);
    }

    protected void pillarWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] topModels, class_2960[] horizontalModels) {
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12496).method_25794((Comparable)class_2350.class_2351.field_11052, Stream.of(topModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2350.class_2351.field_11051, Stream.of(horizontalModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).toList()).method_25794((Comparable)class_2350.class_2351.field_11048, Stream.of(horizontalModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).toList())));
        blocks.remove(block);
    }

    protected void pillarAlt(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
        this.pillarAltWithVariants(blocks, block, new class_2960[]{top}, new class_2960[]{side});
    }

    protected void pillarAltWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        class_2960[] topModels = new class_2960[length];
        class_2960[] horizontalXModels = new class_2960[length];
        class_2960[] horizontalZModels = new class_2960[length];
        class_4942 horizontalXTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), new class_4945[]{class_4945.field_23013, class_4945.field_23018});
        class_4942 horizontalZTemplate = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), new class_4945[]{class_4945.field_23013, class_4945.field_23018});
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            class_2960 modelIdTop = class_4941.method_25843((class_2248)block, (String)suffix);
            class_2960 modelIdHorizontalX = class_4941.method_25843((class_2248)block, (String)("_horizontal_x" + suffix));
            class_2960 modelIdHorizontalZ = class_4941.method_25843((class_2248)block, (String)("_horizontal_z" + suffix));
            topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalXModels[i] = horizontalXTemplate.method_25852(modelIdHorizontalX, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
            horizontalZModels[i] = horizontalZTemplate.method_25852(modelIdHorizontalZ, class_4944.method_25870((class_2960)sideTextures[i], (class_2960)topTextures[i]), this.modelOutput);
        }
        this.pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
    }

    protected void pillarAltWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] yModels, class_2960[] xModels, class_2960[] zModels) {
        this.blockstates.add((class_4917)class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12496).method_25794((Comparable)class_2350.class_2351.field_11052, Stream.of(yModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2350.class_2351.field_11048, Stream.of(xModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList()).method_25794((Comparable)class_2350.class_2351.field_11051, Stream.of(zModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())));
        blocks.remove(block);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void redStringBlock(class_2248 b) {
        class_2960 selfName = class_4944.method_25860((class_2248)b);
        class_2960 front = ResourceLocationHelper.prefix("block/red_string_sender");
        class_2960 model = class_4943.field_22978.method_25846(b, new class_4944().method_25868(class_4945.field_23015, selfName).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23018, selfName), this.modelOutput);
        this.blockstates.add((class_4917)class_4925.method_25770((class_2248)b, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25775(AccessorBlockModelGenerators.facingDispatch()));
    }
}

