/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_3966;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.entity.EntityThrownItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class ItemGravityRod
extends class_1792 {
    private static final class_3494.class_5123<class_1299<?>> BLACKLIST = ModTags.Entities.SHADED_MESA_BLACKLIST;
    private static final float RANGE = 3.0f;
    private static final int COST = 2;
    private static final Predicate<class_1297> CAN_TARGET = e -> !e.method_7325() && e.method_5805() && !BLACKLIST.method_15141((Object)e.method_5864());
    private static final String TAG_TICKS_TILL_EXPIRE = "ticksTillExpire";
    private static final String TAG_TICKS_COOLDOWN = "ticksCooldown";
    private static final String TAG_TARGET = "target";
    private static final String TAG_DIST = "dist";

    public ItemGravityRod(class_1792.class_1793 props) {
        super(props);
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(class_1799 before, class_1799 after) {
        return !after.method_31574((class_1792)this);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        int ticksTillExpire = ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        if (ticksTillExpire == 0) {
            ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
        }
        if (ticksCooldown > 0) {
            --ticksCooldown;
        }
        if (ticksTillExpire >= 0) {
            --ticksTillExpire;
        }
        ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, ticksTillExpire);
        ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, ticksCooldown);
    }

    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            ItemGravityRod.leftClick(player);
        }
        return false;
    }

    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 entity) {
        return ItemNBTHelper.getInt(stack, TAG_TICKS_TILL_EXPIRE, 0) != 0;
    }

    public static class_1269 onAttack(class_1657 player, class_1937 level, class_1268 hand, class_1297 target, @Nullable class_3966 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(ModItems.gravityRod) && ((ItemGravityRod)stack.method_7909()).onLeftClickEntity(stack, player, target)) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
        int ticksCooldown = ItemNBTHelper.getInt(stack, TAG_TICKS_COOLDOWN, 0);
        double length = ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
        if (ticksCooldown == 0) {
            class_1297 target = null;
            if (targetID != -1 && player.field_6002.method_8469(targetID) != null) {
                class_1297 taritem = player.field_6002.method_8469(targetID);
                boolean found = false;
                class_243 targetVec = VecHelper.fromEntityCenter((class_1297)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.method_1019(player.method_5720().method_1021((double)distance)).method_1031(0.0, 0.5, 0.0);
                    entities = player.field_6002.method_8333((class_1297)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                    if (!entities.contains(taritem)) continue;
                    found = true;
                }
                if (found) {
                    target = player.field_6002.method_8469(targetID);
                }
            }
            if (target == null) {
                class_243 targetVec = VecHelper.fromEntityCenter((class_1297)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    targetVec = targetVec.method_1019(player.method_5720().method_1021((double)distance)).method_1031(0.0, 0.5, 0.0);
                    entities = player.field_6002.method_8333((class_1297)player, VecHelper.boxForRange(targetVec, 3.0), CAN_TARGET);
                }
                if (entities.size() > 0) {
                    target = (class_1297)entities.get(0);
                    length = 5.5;
                    if (target instanceof class_1542) {
                        length = 2.0;
                    }
                }
            }
            if (target != null) {
                if (BLACKLIST.method_15141((Object)target.method_5864())) {
                    return class_1271.method_22431((Object)stack);
                }
                if (ManaItemHandler.instance().requestManaExactForTool(stack, player, 2, true)) {
                    boolean targetIsPlayer = target instanceof class_1657;
                    if (target instanceof class_1542) {
                        class_1542 item = (class_1542)target;
                        item.method_6982(5);
                    }
                    if (target instanceof class_1309) {
                        class_1309 living = (class_1309)target;
                        living.field_6017 = 0.0f;
                        if (living.method_6112(class_1294.field_5909) == null) {
                            living.method_6092(new class_1293(class_1294.field_5909, targetIsPlayer ? 20 : 2, targetIsPlayer ? 1 : 3, true, true));
                        }
                    }
                    class_243 target3 = VecHelper.fromEntityCenter((class_1297)player).method_1019(player.method_5720().method_1021(length)).method_1031(0.0, 0.5, 0.0);
                    if (target instanceof class_1542) {
                        target3 = target3.method_1031(0.0, 0.25, 0.0);
                    }
                    for (int i = 0; i < 4; ++i) {
                        float r = 0.5f + (float)Math.random() * 0.5f;
                        float b = 0.5f + (float)Math.random() * 0.5f;
                        float s = 0.2f + (float)Math.random() * 0.1f;
                        float m = 0.1f;
                        float xm = ((float)Math.random() - 0.5f) * m;
                        float ym = ((float)Math.random() - 0.5f) * m;
                        float zm = ((float)Math.random() - 0.5f) * m;
                        WispParticleData data = WispParticleData.wisp(s, r, 0.0f, b);
                        world.method_8406((class_2394)data, target.method_23317() + (double)(target.method_17681() / 2.0f), target.method_23318() + (double)(target.method_17682() / 2.0f), target.method_23321() + (double)(target.method_17681() / 2.0f), (double)xm, (double)ym, (double)zm);
                    }
                    MathHelper.setEntityMotionFromVector(target, target3, 0.3333333f);
                    if (targetIsPlayer && target instanceof class_3222) {
                        class_3222 p = (class_3222)target;
                        p.field_13987.method_14364((class_2596)new class_2743((class_1297)p));
                    }
                    ItemNBTHelper.setInt(stack, TAG_TARGET, target.method_5628());
                    ItemNBTHelper.setDouble(stack, TAG_DIST, length);
                }
                ItemNBTHelper.setInt(stack, TAG_TICKS_TILL_EXPIRE, 5);
                return class_1271.method_22428((Object)stack);
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    private static void leftClick(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (!stack.method_7960() && stack.method_31574(ModItems.gravityRod)) {
            int targetID = ItemNBTHelper.getInt(stack, TAG_TARGET, -1);
            ItemNBTHelper.getDouble(stack, TAG_DIST, -1.0);
            if (targetID != -1 && player.field_6002.method_8469(targetID) != null) {
                class_1297 target = player.field_6002.method_8469(targetID);
                boolean found = false;
                class_243 vec = VecHelper.fromEntityCenter((class_1297)player);
                List entities = new ArrayList();
                for (int distance = 1; entities.size() == 0 && distance < 25; ++distance) {
                    vec = vec.method_1019(player.method_5720().method_1021((double)distance)).method_1031(0.0, 0.5, 0.0);
                    entities = player.field_6002.method_8333((class_1297)player, new class_238(vec.method_1023(3.0, 3.0, 3.0), vec.method_1031(3.0, 3.0, 3.0)), CAN_TARGET);
                    if (!entities.contains(target)) continue;
                    found = true;
                }
                if (found) {
                    ItemNBTHelper.setInt(stack, TAG_TARGET, -1);
                    ItemNBTHelper.setDouble(stack, TAG_DIST, -1.0);
                    class_243 moveVector = player.method_5720().method_1029();
                    if (target instanceof class_1542) {
                        class_1542 item = (class_1542)target;
                        item.method_6982(20);
                        float mot = ManaItemHandler.instance().hasProficiency(player, stack) ? 2.25f : 1.5f;
                        item.method_18800(moveVector.field_1352 * (double)mot, moveVector.field_1351, moveVector.field_1350 * (double)mot);
                        if (!player.field_6002.field_9236) {
                            EntityThrownItem thrown = new EntityThrownItem(item.field_6002, item.method_23317(), item.method_23318(), item.method_23321(), item);
                            item.field_6002.method_8649((class_1297)thrown);
                        }
                        item.method_31472();
                    } else {
                        if (target instanceof class_1309) {
                            class_1309 living = (class_1309)target;
                            living.method_6015((class_1309)player);
                            living.method_29505(player);
                        }
                        target.method_18799(moveVector.method_18805(3.0, 1.5, 3.0));
                    }
                    ItemNBTHelper.setInt(stack, TAG_TICKS_COOLDOWN, 10);
                }
            }
        }
    }
}

