/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4262;
import net.minecraft.class_5250;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemExchangeRod
extends class_1792
implements IWireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_REPLACEMENT_ITEM = "placedItem";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";
    private static final String TAG_SWAP_HIT_VEC = "swapHitVec";
    private static final String TAG_SWAP_DIRECTION = "swapDirection";
    private static final String TAG_SWAP_CLICKED_AXIS = "swapClickAxis";
    private static final String TAG_TEMPERANCE_STONE = "temperanceStone";

    public ItemExchangeRod(class_1792.class_1793 props) {
        super(props);
    }

    @Nonnull
    public class_1269 method_7884(class_1838 ctx) {
        class_1792 replacement;
        List<class_2338> swap;
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1657 player = ctx.method_8036();
        class_1799 stack = ctx.method_8041();
        class_2680 wstate = world.method_8320(pos);
        class_2248 block = wstate.method_26204();
        if (player != null && player.method_5715()) {
            class_2586 tile = world.method_8321(pos);
            if (tile == null && block.method_8389() != class_1802.field_8162 && BlockPlatform.isValidBlock(wstate, world, pos) && (wstate.method_26225() || block instanceof class_4262 || block instanceof class_2389) && block.method_8389() instanceof class_1747) {
                this.setItemToPlace(stack, block.method_8389());
                this.setSwapTemplateDirection(stack, ctx.method_8038());
                this.setHitPos(stack, ctx.method_17698());
                this.displayRemainderCounter(player, stack);
                return class_1269.field_5812;
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getTargetPositions(world, stack, replacement = this.getItemToPlace(stack), pos, block, ctx.method_8038())).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.method_10263());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.method_10264());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.method_10260());
            this.setSwapClickDirection(stack, ctx.method_8038());
            this.setTarget(stack, block);
        }
        return class_1269.field_5812;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public class_1269 onLeftClick(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 side) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && stack.method_31574((class_1792)this)) {
            int exchange;
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            if (this.canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false) && (exchange = this.exchange(world, player, pos, stack, this.getItemToPlace(stack))) > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, exchange, true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean equipped) {
        boolean temperanceActive;
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = ManaItemHandler.instance().hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        if ((temperanceActive = ItemTemperanceStone.hasTemperanceActive(player)) != stack.method_7948().method_10577(TAG_TEMPERANCE_STONE)) {
            stack.method_7948().method_10556(TAG_TEMPERANCE_STONE, temperanceActive);
        }
        class_1792 replacement = this.getItemToPlace(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            class_2248 target;
            int z;
            int y;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false)) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            List<class_2338> swap = this.getTargetPositions(world, stack, replacement, new class_2338(x, y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)), target = ItemExchangeRod.getTargetState(stack), this.getSwapClickDirection(stack));
            if (swap.size() == 0) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            class_2338 coords = swap.get(world.field_9229.nextInt(swap.size()));
            int exchange = this.exchange(world, player, coords, stack, replacement);
            if (exchange > 0) {
                ManaItemHandler.instance().requestManaForTool(stack, player, exchange, true);
            } else {
                ItemExchangeRod.endSwapping(stack);
            }
        }
    }

    public List<class_2338> getTargetPositions(class_1937 world, class_1799 stack, class_1792 toPlace, class_2338 pos, class_2248 toReplace, class_2350 clickedSide) {
        ArrayList<class_2338> coordsList = new ArrayList<class_2338>();
        class_2350.class_2351 axis = clickedSide.method_10166();
        int xRange = this.getRange(stack, axis, class_2350.class_2351.field_11048);
        int yRange = this.getRange(stack, axis, class_2350.class_2351.field_11052);
        int zRange = this.getRange(stack, axis, class_2350.class_2351.field_11051);
        for (int offsetX = -xRange; offsetX <= xRange; ++offsetX) {
            for (int offsetY = -yRange; offsetY <= yRange; ++offsetY) {
                block2: for (int offsetZ = -zRange; offsetZ <= zRange; ++offsetZ) {
                    class_2338 pos_ = pos.method_10069(offsetX, offsetY, offsetZ);
                    class_2680 currentState = world.method_8320(pos_);
                    if (!currentState.method_27852(toReplace) || currentState.method_26204().method_8389() == toPlace) continue;
                    for (class_2350 dir : class_2350.values()) {
                        class_2338 adjPos = pos_.method_10093(dir);
                        class_2680 adjState = world.method_8320(adjPos);
                        if (class_2248.method_9501((class_265)adjState.method_26222((class_1922)world, pos), (class_2350)dir.method_10153())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    public int exchange(class_1937 world, class_1657 player, class_2338 pos, class_1799 rod, class_1792 replacement) {
        class_2680 stateAt;
        class_2586 tile = world.method_8321(pos);
        if (tile != null) {
            return 0;
        }
        class_1799 placeStack = ItemExchangeRod.removeFromInventory(player, rod, replacement, false);
        if (!placeStack.method_7960() && !(stateAt = world.method_8320(pos)).method_26215() && stateAt.method_26165(player, (class_1922)world, pos) > 0.0f && stateAt.method_26204().method_8389() != replacement) {
            float hardness = stateAt.method_26214((class_1922)world, pos);
            if (!world.field_9236) {
                world.method_22352(pos, !player.method_31549().field_7477);
                class_3965 hit = new class_3965(this.getHitPos(rod, pos), this.getSwapTemplateDirection(rod), pos, false);
                class_1269 result = PlayerHelper.substituteUse(new class_1838(player, class_1268.field_5808, hit), placeStack);
                if (!player.method_31549().field_7477) {
                    if (result.method_23665()) {
                        ItemExchangeRod.removeFromInventory(player, rod, replacement, true);
                        this.displayRemainderCounter(player, rod);
                    } else {
                        ((class_3218)world).method_14199((class_2394)class_2398.field_11237, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 2, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
            return hardness <= 10.0f ? 40 : (int)(20.0 + (double)(3.0f * hardness));
        }
        return 0;
    }

    public boolean canExchange(class_1799 stack) {
        return this.getItemToPlace(stack) != class_1802.field_8162;
    }

    public static class_1799 removeFromInventory(class_1657 player, class_1263 inv, class_1799 tool, class_1792 requested, boolean doit) {
        ArrayList<IBlockProvider> providers = new ArrayList<IBlockProvider>();
        for (int i = inv.method_5439() - 1; i >= 0; --i) {
            class_1799 invStack = inv.method_5438(i);
            if (invStack.method_7960()) continue;
            class_1792 item = invStack.method_7909();
            if (item == requested) {
                class_1799 ret;
                if (doit) {
                    ret = inv.method_5434(i, 1);
                } else {
                    ret = invStack.method_7972();
                    ret.method_7939(1);
                }
                return ret;
            }
            IBlockProvider provider = IXplatAbstractions.INSTANCE.findBlockProvider(invStack);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (requested instanceof class_1747) {
            class_1747 blockItem = (class_1747)requested;
            class_2248 block = blockItem.method_7711();
            for (IBlockProvider prov : providers) {
                if (!prov.provideBlock(player, tool, block, doit)) continue;
                return new class_1799((class_1935)requested);
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 removeFromInventory(class_1657 player, class_1799 tool, class_1792 item, boolean doit) {
        if (player.method_31549().field_7477) {
            return new class_1799((class_1935)item);
        }
        class_1799 outStack = ItemExchangeRod.removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), tool, item, doit);
        if (outStack.method_7960()) {
            outStack = ItemExchangeRod.removeFromInventory(player, (class_1263)player.method_31548(), tool, item, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(class_1657 player, class_1799 stack, class_1792 item) {
        if (player.method_31549().field_7477) {
            return -1;
        }
        int baubleCount = ItemExchangeRod.getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, item);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ItemExchangeRod.getInventoryItemCount(player, (class_1263)player.method_31548(), stack, item);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(class_1657 player, class_1263 inv, class_1799 stack, class_1792 requested) {
        if (player.method_31549().field_7477) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.method_5439(); ++i) {
            IBlockProvider prov;
            class_1799 invStack = inv.method_5438(i);
            if (invStack.method_7960()) continue;
            class_1792 item = invStack.method_7909();
            if (item == requested.method_8389()) {
                count += invStack.method_7947();
            }
            if ((prov = IXplatAbstractions.INSTANCE.findBlockProvider(invStack)) == null || !(requested instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)requested;
            int provCount = prov.getBlockCount(player, stack, blockItem.method_7711());
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(class_1657 player, class_1799 stack) {
        if (!player.field_6002.field_9236) {
            class_1792 item = this.getItemToPlace(stack);
            int count = ItemExchangeRod.getInventoryItemCount(player, stack, item);
            ItemsRemainingRenderHandler.send(player, new class_1799((class_1935)item), count);
        }
    }

    private void setItemToPlace(class_1799 stack, class_1792 item) {
        ItemNBTHelper.setString(stack, TAG_REPLACEMENT_ITEM, class_2378.field_11142.method_10221((Object)item).toString());
    }

    private class_1792 getItemToPlace(class_1799 stack) {
        return (class_1792)class_2378.field_11142.method_10223(class_2960.method_12829((String)ItemNBTHelper.getString(stack, TAG_REPLACEMENT_ITEM, "air")));
    }

    private void setHitPos(class_1799 stack, class_243 vec) {
        class_2499 list = new class_2499();
        list.add((Object)class_2489.method_23241((double)class_3532.method_15385((double)vec.method_10216())));
        list.add((Object)class_2489.method_23241((double)class_3532.method_15385((double)vec.method_10214())));
        list.add((Object)class_2489.method_23241((double)class_3532.method_15385((double)vec.method_10215())));
        stack.method_7948().method_10566(TAG_SWAP_HIT_VEC, (class_2520)list);
    }

    private class_243 getHitPos(class_1799 stack, class_2338 pos) {
        class_2499 list = stack.method_7948().method_10554(TAG_SWAP_HIT_VEC, 6);
        return new class_243((double)pos.method_10263() + list.method_10611(0), (double)pos.method_10264() + list.method_10611(1), (double)pos.method_10260() + list.method_10611(2));
    }

    private void setSwapTemplateDirection(class_1799 stack, class_2350 direction) {
        stack.method_7948().method_10569(TAG_SWAP_DIRECTION, direction.method_10146());
    }

    private class_2350 getSwapTemplateDirection(class_1799 stack) {
        return class_2350.method_10143((int)stack.method_7948().method_10550(TAG_SWAP_DIRECTION));
    }

    private void setSwapClickDirection(class_1799 stack, class_2350 direction) {
        stack.method_7948().method_10569(TAG_SWAP_CLICKED_AXIS, direction.method_10146());
    }

    private class_2350 getSwapClickDirection(class_1799 stack) {
        return class_2350.method_10143((int)stack.method_7948().method_10550(TAG_SWAP_CLICKED_AXIS));
    }

    private int getRange(class_1799 stack, class_2350.class_2351 clickAxis, class_2350.class_2351 rangeAxis) {
        if (stack.method_7948().method_10577(TAG_TEMPERANCE_STONE) && rangeAxis == clickAxis) {
            return 0;
        }
        return 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
    }

    private static void endSwapping(class_1799 stack) {
        ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_X);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Y);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Z);
        ItemNBTHelper.removeEntry(stack, TAG_TARGET_BLOCK_NAME);
        ItemNBTHelper.removeEntry(stack, TAG_SWAP_CLICKED_AXIS);
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_1792 item = this.getItemToPlace(stack);
        class_5250 cmp = super.method_7864(stack).method_27661();
        if (item != class_1802.field_8162) {
            cmp.method_27693(" (");
            class_2561 sub = new class_1799((class_1935)item).method_7964();
            cmp.method_10852((class_2561)sub.method_27661().method_27692(class_124.field_1060));
            cmp.method_27693(")");
        }
        return cmp;
    }

    private void setTarget(class_1799 stack, class_2248 block) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, class_2378.field_11146.method_10221((Object)block).toString());
    }

    public static class_2248 getTargetState(class_1799 stack) {
        class_2960 id = new class_2960(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
        return (class_2248)class_2378.field_11146.method_10223(id);
    }

    @Override
    public List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack) {
        class_1799 holding = player.method_6047();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        class_239 pos = class_310.method_1551().field_1765;
        if (pos != null && pos.method_17783() == class_239.class_240.field_1332) {
            class_2338 bPos = ((class_3965)pos).method_17777();
            class_2248 target = class_310.method_1551().field_1687.method_8320(bPos).method_26204();
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new class_2338(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                target = ItemExchangeRod.getTargetState(stack);
            }
            if (!player.field_6002.method_22347(bPos)) {
                class_1792 item = this.getItemToPlace(stack);
                List<class_2338> coordsList = this.getTargetPositions(player.field_6002, stack, item, bPos, target, ((class_3965)pos).method_17780());
                coordsList.removeIf(arg_0 -> ((class_2338)bPos).equals(arg_0));
                return coordsList;
            }
        }
        return ImmutableList.of();
    }
}

