/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemRelic
extends class_1792
implements IRelic {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemRelic(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.updateRelic(stack, player);
        }
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        if (!this.hasUUID(stack)) {
            tooltip.add((class_2561)new class_2588("botaniamisc.relicUnbound"));
        } else if (!this.getSoulbindUUID(stack).equals(class_310.method_1551().field_1724.method_5667())) {
            tooltip.add((class_2561)new class_2588("botaniamisc.notYourSagittarius"));
        } else {
            tooltip.add((class_2561)new class_2588("botaniamisc.relicSoulbound", new Object[]{class_310.method_1551().field_1724.method_5477()}));
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public void updateRelic(class_1799 stack, class_1657 player) {
        ItemRelic relic;
        class_1792 class_17922;
        if (stack.method_7960() || !(stack.method_7909() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.method_5667(), stack);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                RelicBindTrigger.INSTANCE.trigger(serverPlayer, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.method_5667())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_6012 % 10 != 0 || (class_17922 = stack.method_7909()) instanceof ItemRelic && !(relic = (ItemRelic)class_17922).shouldDamageWrongPlayer())) {
            player.method_5643(ItemRelic.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(class_1657 player, class_1799 stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.method_5667());
    }

    public static class_1282 damageSource() {
        return new class_1282("botania-relic"){};
    }

    @Override
    public void bindToUUID(UUID uuid, class_1799 stack) {
        ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    public UUID getSoulbindUUID(class_1799 stack) {
        if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    public boolean hasUUID(class_1799 stack) {
        return this.getSoulbindUUID(stack) != null;
    }
}

