/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ItemLokiRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";
    private static boolean recCall = false;

    public ItemLokiRing(class_1792.class_1793 props) {
        super(props);
    }

    public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 lookPos) {
        class_1799 lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.method_7960() || !player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        List<class_2338> cursors = ItemLokiRing.getCursorList(lokiRing);
        if (lookPos.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        class_2338 hit = lookPos.method_17777();
        if (stack.method_7960() && hand == class_1268.field_5808) {
            class_2338 originCoords = ItemLokiRing.getBindingCenter(lokiRing);
            if (!world.field_9236) {
                if (originCoords.method_10264() == Integer.MIN_VALUE) {
                    ItemLokiRing.setBindingCenter(lokiRing, hit);
                    ItemLokiRing.setCursorList(lokiRing, null);
                } else if (originCoords.equals((Object)hit)) {
                    ItemLokiRing.exitBindingMode(lokiRing);
                } else {
                    class_2338 relPos = hit.method_10059((class_2382)originCoords);
                    boolean removed = cursors.remove(relPos);
                    if (!removed) {
                        cursors.add(relPos);
                    }
                    ItemLokiRing.setCursorList(lokiRing, cursors);
                }
            }
            return class_1269.field_5812;
        }
        int cost = Math.min(cursors.size(), (int)Math.pow(Math.E, (double)cursors.size() * 0.25));
        class_1799 original = stack.method_7972();
        int successes = 0;
        for (class_2338 cursor : cursors) {
            class_2338 pos = hit.method_10081((class_2382)cursor);
            if (!ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, false)) break;
            class_243 lookHit = lookPos.method_17784();
            class_243 newHitVec = new class_243((double)pos.method_10263() + class_3532.method_15385((double)lookHit.method_10216()), (double)pos.method_10264() + class_3532.method_15385((double)lookHit.method_10214()), (double)pos.method_10260() + class_3532.method_15385((double)lookHit.method_10215()));
            class_3965 newHit = new class_3965(newHitVec, lookPos.method_17780(), pos, false);
            class_1838 ctx = new class_1838(player, hand, newHit);
            class_1269 result = player.method_7337() ? PlayerHelper.substituteUse(ctx, original.method_7972()) : stack.method_7981(ctx);
            if (!result.method_23665()) continue;
            ManaItemHandler.instance().requestManaExact(lokiRing, player, cost, true);
            ++successes;
        }
        if (successes > 0 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            LokiPlaceTrigger.INSTANCE.trigger(serverPlayer, lokiRing, successes);
        }
        return successes > 0 ? class_1269.field_5812 : class_1269.field_5811;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {
        class_1792 item = stack.method_7909();
        class_1799 lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.method_7960() || player.field_6002.field_9236 || !(item instanceof ISequentialBreaker)) {
            return;
        }
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        if (recCall) {
            return;
        }
        recCall = true;
        List<class_2338> cursors = ItemLokiRing.getCursorList(lokiRing);
        try {
            for (class_2338 offset : cursors) {
                class_2338 coords = pos.method_10081((class_2382)offset);
                class_2680 state = player.field_6002.method_8320(coords);
                breaker.breakOtherBlock(player, stack, coords, pos, side);
                ToolCommons.removeBlockWithDrops(player, stack, player.field_6002, coords, s -> s.method_27852(state.method_26204()) && s.method_26207() == state.method_26207());
            }
        }
        finally {
            recCall = false;
        }
    }

    @Override
    public void onUnequipped(class_1799 stack, class_1309 living) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
        super.method_7888(stack, world, entity, slot, held);
        if (slot >= 0) {
            ItemLokiRing.exitBindingMode(stack);
        }
    }

    @Override
    public List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return ImmutableList.of();
        }
        class_239 lookPos = class_310.method_1551().field_1765;
        if (lookPos != null && lookPos.method_17783() == class_239.class_240.field_1332 && !player.field_6002.method_22347(((class_3965)lookPos).method_17777())) {
            List<class_2338> list = ItemLokiRing.getCursorList(stack);
            class_2338 origin = ItemLokiRing.getBindingCenter(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.method_10264() != Integer.MIN_VALUE) {
                    list.set(i, list.get(i).method_10081((class_2382)origin));
                    continue;
                }
                list.set(i, list.get(i).method_10081((class_2382)((class_3965)lookPos).method_17777()));
            }
            return list;
        }
        return ImmutableList.of();
    }

    @Override
    public class_2338 getSourceWireframe(class_1657 player, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        if (ItemLokiRing.getLokiRing(player) == stack) {
            class_2338 currentBuildCenter = ItemLokiRing.getBindingCenter(stack);
            if (currentBuildCenter.method_10264() != Integer.MIN_VALUE) {
                return currentBuildCenter;
            }
            if (mc.field_1765 instanceof class_3965 && mc.field_1765.method_17783() == class_239.class_240.field_1332 && !ItemLokiRing.getCursorList(stack).isEmpty()) {
                return ((class_3965)mc.field_1765).method_17777();
            }
        }
        return null;
    }

    private static class_1799 getLokiRing(class_1657 player) {
        return EquipmentHandler.findOrEmpty(ModItems.lokiRing, (class_1309)player);
    }

    private static class_2338 getBindingCenter(class_1799 stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new class_2338(x, y, z);
    }

    private static void exitBindingMode(class_1799 stack) {
        ItemLokiRing.setBindingCenter(stack, new class_2338(0, Integer.MIN_VALUE, 0));
    }

    private static void setBindingCenter(class_1799 stack, class_2338 pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.method_10263());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.method_10264());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.method_10260());
    }

    private static List<class_2338> getCursorList(class_1799 stack) {
        class_2487 cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<class_2338> cursors = new ArrayList<class_2338>();
        int count = cmp.method_10550(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            class_2487 cursorCmp = cmp.method_10562(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.method_10550(TAG_X_OFFSET);
            int y = cursorCmp.method_10550(TAG_Y_OFFSET);
            int z = cursorCmp.method_10550(TAG_Z_OFFSET);
            cursors.add(new class_2338(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(class_1799 stack, @Nullable List<class_2338> cursors) {
        class_2487 cmp = new class_2487();
        if (cursors != null) {
            int i = 0;
            for (class_2338 cursor : cursors) {
                class_2487 cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.method_10566(TAG_CURSOR_PREFIX + i, (class_2520)cursorCmp);
                ++i;
            }
            cmp.method_10569(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static class_2487 cursorToCmp(class_2338 pos) {
        class_2487 cmp = new class_2487();
        cmp.method_10569(TAG_X_OFFSET, pos.method_10263());
        cmp.method_10569(TAG_Y_OFFSET, pos.method_10264());
        cmp.method_10569(TAG_Z_OFFSET, pos.method_10260());
        return cmp;
    }

    @Override
    public class_2960 getAdvancement() {
        return ResourceLocationHelper.prefix("challenge/loki_ring");
    }
}

