/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import org.apache.commons.lang3.mutable.MutableFloat;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelCloak;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.proxy.IProxy;

public class ItemHolyCloak
extends ItemBauble {
    private static final class_2960 texture = new class_2960("botania:textures/model/cloak_holy.png");
    private static final class_2960 textureGlow = new class_2960("botania:textures/model/cloak_holy_glow.png");
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_IN_EFFECT = "inEffect";

    public ItemHolyCloak(class_1792.class_1793 props) {
        super(props);
        IProxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    public float onPlayerDamage(class_1657 player, class_1282 src, float amount) {
        class_1799 stack;
        if (!(src.method_5538() || (stack = EquipmentHandler.findOrEmpty(this, (class_1309)player)).method_7960() || ItemHolyCloak.isInEffect(stack))) {
            ItemHolyCloak cloak = (ItemHolyCloak)stack.method_7909();
            int cooldown = ItemHolyCloak.getCooldown(stack);
            ItemHolyCloak.setInEffect(stack, true);
            MutableFloat mutAmount = new MutableFloat(amount);
            if (cooldown == 0 && cloak.effectOnDamage(src, mutAmount, player, stack)) {
                ItemHolyCloak.setCooldown(stack, cloak.getCooldownTime(stack));
            }
            ItemHolyCloak.setInEffect(stack, false);
            return mutAmount.getValue().floatValue();
        }
        return amount;
    }

    @Override
    public void onWornTick(class_1799 stack, class_1309 living) {
        int cooldown = ItemHolyCloak.getCooldown(stack);
        if (cooldown > 0) {
            ItemHolyCloak.setCooldown(stack, cooldown - 1);
        }
    }

    protected boolean effectOnDamage(class_1282 src, MutableFloat amount, class_1657 player, class_1799 stack) {
        if (!src.method_5527()) {
            amount.setValue(0.0f);
            player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.holyCloak, class_3419.field_15248, 1.0f, 1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = player.method_23317() + Math.random() * (double)player.method_17681() * 2.0 - (double)player.method_17681();
                double y = player.method_23318() + Math.random() * (double)player.method_17682();
                double z = player.method_23321() + Math.random() * (double)player.method_17681() * 2.0 - (double)player.method_17681();
                boolean yellow = Math.random() > 0.5;
                float r = yellow ? 1.0f : 0.3f;
                float g = yellow ? 1.0f : 0.3f;
                float b = yellow ? 0.3f : 1.0f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.8f + (float)Math.random() * 0.4f, r, g, b, 3);
                player.field_6002.method_8406((class_2394)data, x, y, z, 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    public int getCooldownTime(class_1799 stack) {
        return 200;
    }

    public static int getCooldown(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(class_1799 stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }

    public static boolean isInEffect(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_IN_EFFECT, false);
    }

    public static void setInEffect(class_1799 stack, boolean effect) {
        ItemNBTHelper.setBoolean(stack, TAG_IN_EFFECT, effect);
    }

    class_2960 getCloakTexture() {
        return texture;
    }

    class_2960 getCloakGlowTexture() {
        return textureGlow;
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static ModelCloak model = null;

        @Override
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 player, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemHolyCloak item = (ItemHolyCloak)stack.method_7909();
            AccessoryRenderHelper.rotateIfSneaking(ms, player);
            boolean armor = !player.method_6118(class_1304.field_6174).method_7960();
            ms.method_22904(0.0, armor ? (double)-0.07f : (double)-0.01f, 0.0);
            if (model == null) {
                model = new ModelCloak(class_310.method_1551().method_31974().method_32072(ModModelLayers.CLOAK));
            }
            class_4588 buffer = buffers.getBuffer(model.method_23500(item.getCloakTexture()));
            model.method_2828(ms, buffer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            buffer = buffers.getBuffer(model.method_23500(item.getCloakGlowTexture()));
            model.method_2828(ms, buffer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

