/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;
import vazkii.botania.mixin.AccessorDamageSource;

public class ItemTerrasteelHelm
extends ItemTerrasteelArmor
implements IManaDiscountArmor,
IAncientWillContainer {
    public static final String TAG_ANCIENT_WILL = "AncientWill";

    public ItemTerrasteelHelm(class_1792.class_1793 props) {
        super(class_1304.field_6169, props);
    }

    @Override
    public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
        super.onArmorTick(stack, world, player);
        if (!world.field_9236 && this.hasArmorSet(player)) {
            int food = player.method_7344().method_7586();
            if (food > 0 && food < 18 && player.method_7317() && player.field_6012 % 80 == 0) {
                player.method_6025(1.0f);
            }
            if (player.field_6012 % 10 == 0) {
                ManaItemHandler.instance().dispatchManaExact(stack, player, 10, true);
            }
        }
    }

    @Override
    public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(class_1799 stack, IAncientWillContainer.AncientWillType will) {
        ItemNBTHelper.setBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), true);
    }

    @Override
    public boolean hasAncientWill(class_1799 stack, IAncientWillContainer.AncientWillType will) {
        return ItemTerrasteelHelm.hasAncientWill_(stack, will);
    }

    private static boolean hasAncientWill_(class_1799 stack, IAncientWillContainer.AncientWillType will) {
        return ItemNBTHelper.getBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), false);
    }

    @Override
    public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
        super.addArmorSetDescription(stack, list);
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, type)) continue;
            list.add((class_2561)new class_2588("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc").method_27692(class_124.field_1080));
        }
    }

    public static boolean hasAnyWill(class_1799 stack) {
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!ItemTerrasteelHelm.hasAncientWill_(stack, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTerraArmorSet(class_1657 player) {
        return ((ItemTerrasteelHelm)ModItems.terrasteelHelm).hasArmorSet(player);
    }

    public static float getCritDamageMult(class_1657 player) {
        class_1799 stack;
        if (ItemTerrasteelHelm.hasTerraArmorSet(player) && !(stack = player.method_6118(class_1304.field_6169)).method_7960() && stack.method_7909() instanceof ItemTerrasteelHelm && ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.DHAROK)) {
            return 1.0f + (1.0f - player.method_6032() / player.method_6063()) * 0.5f;
        }
        return 1.0f;
    }

    public static void onEntityAttacked(class_1282 source, float amount, class_1657 player, class_1309 entity) {
        class_1799 stack;
        if (ItemTerrasteelHelm.hasTerraArmorSet(player) && !(stack = player.method_6118(class_1304.field_6169)).method_7960() && stack.method_7909() instanceof ItemTerrasteelHelm) {
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.AHRIM)) {
                entity.method_6092(new class_1293(class_1294.field_5911, 20, 1));
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.GUTHAN)) {
                player.method_6025(amount * 0.25f);
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.TORAG)) {
                entity.method_6092(new class_1293(class_1294.field_5909, 60, 1));
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.VERAC)) {
                ((AccessorDamageSource)source).botania_setBypassArmor();
            }
            if (ItemTerrasteelHelm.hasAncientWill_(stack, IAncientWillContainer.AncientWillType.KARIL)) {
                entity.method_6092(new class_1293(class_1294.field_5920, 60, 1));
            }
        }
    }
}

